/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.util;

import com.imwindow.buildersplus.util.ModDyeItem;
import com.imwindow.buildersplus.util.ModMaterialColor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public enum ModDyeColor {
    WHITE(0, "white", 0xF9FFFE, ModMaterialColor.SNOW, 0xF0F0F0, 0xFFFFFF),
    ORANGE(1, "orange", 16351261, ModMaterialColor.ADOBE, 15435844, 16738335),
    MAGENTA(2, "magenta", 13061821, ModMaterialColor.MAGENTA, 12801229, 0xFF00FF),
    LIGHT_BLUE(3, "light_blue", 3847130, ModMaterialColor.LIGHT_BLUE, 6719955, 10141901),
    YELLOW(4, "yellow", 16701501, ModMaterialColor.YELLOW, 14602026, 0xFFFF00),
    LIME(5, "lime", 8439583, ModMaterialColor.LIME, 4312372, 0xBFFF00),
    PINK(6, "pink", 15961002, ModMaterialColor.PINK, 14188952, 16738740),
    GRAY(7, "gray", 4673362, ModMaterialColor.GRAY, 0x434343, 0x808080),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, ModMaterialColor.LIGHT_GRAY, 0xABABAB, 0xD3D3D3),
    CYAN(9, "cyan", 1481884, ModMaterialColor.CYAN, 2651799, 65535),
    PURPLE(10, "purple", 8991416, ModMaterialColor.PURPLE, 8073150, 10494192),
    BLUE(11, "blue", 3949738, ModMaterialColor.BLUE, 2437522, 255),
    BROWN(12, "brown", 8606770, ModMaterialColor.BROWN, 5320730, 9127187),
    GREEN(13, "green", 6192150, ModMaterialColor.GREEN, 3887386, 65280),
    RED(14, "red", 11546150, ModMaterialColor.RED, 11743532, 0xFF0000),
    BLACK(15, "black", 0x1D1D21, ModMaterialColor.BLACK, 0x1E1B1B, 0),
    MAROON(16, "maroon", 0x7A0000, ModMaterialColor.MAROON, 0x7A0000, 0x7A0000),
    CORAL(17, "coral", 0xFF7171, ModMaterialColor.CORAL, 0xFF7171, 0xFF7171),
    SALMON(18, "salmon", 16748901, ModMaterialColor.SALMON, 16748901, 16748901),
    APRICOT(19, "apricot", 16757865, ModMaterialColor.APRICOT, 16757865, 16757865),
    AMBER(20, "amber", 16701042, ModMaterialColor.AMBER, 16701042, 16701042),
    SIENNA(21, "sienna", 9054976, ModMaterialColor.SIENNA, 9054976, 9054976),
    PEAR(22, "pear", 15859611, ModMaterialColor.PEAR, 15859611, 15859611),
    EMERALD_GREEN(23, "emerald_green", 1030520, ModMaterialColor.EMERALD_GREEN, 1030520, 1030520),
    FOREST_GREEN(24, "forest_green", 26112, ModMaterialColor.FOREST_GREEN, 26112, 26112),
    JADE(25, "jade", 37484, ModMaterialColor.JADE, 37484, 37484),
    TEAL(26, "teal", 32896, ModMaterialColor.TEAL, 32896, 32896),
    TURQUOISE(27, "turquoise", 581332, ModMaterialColor.TURQUOISE, 581332, 581332),
    BURGUNDY(28, "burgundy", 6624041, ModMaterialColor.BURGUNDY, 6624041, 6624041),
    PLUM(29, "plum", 8257608, ModMaterialColor.PLUM, 8257608, 8257608),
    LAVENDER(30, "lavender", 13216767, ModMaterialColor.LAVENDER, 13216767, 13216767),
    CRIMSON(31, "crimson", 11796557, ModMaterialColor.CRIMSON, 11796557, 11796557);

    private static final ModDyeColor[] VALUES;
    private static final Int2ObjectOpenHashMap<ModDyeColor> BY_FIREWORK_COLOR;
    private final int id;
    private final String translationKey;
    private final ModMaterialColor mapColor;
    private final int colorValue;
    private final int swappedColorValue;
    private final float[] colorComponentValues;
    private final int fireworkColor;
    private final Tag tag;
    private final int textColor;

    private ModDyeColor(int idIn, String translationKeyIn, int colorValueIn, ModMaterialColor mapColorIn, int fireworkColorIn, int textColorIn) {
        this.id = idIn;
        this.translationKey = translationKeyIn;
        this.colorValue = colorValueIn;
        this.mapColor = mapColorIn;
        this.textColor = textColorIn;
        int i = (colorValueIn & 0xFF0000) >> 16;
        int j = (colorValueIn & 0xFF00) >> 8;
        int k = colorValueIn & 0xFF;
        this.swappedColorValue = k << 16 | j << 8 | i;
        this.tag = new ItemTags.Wrapper(new ResourceLocation("minecraft", "dyes/" + translationKeyIn));
        this.colorComponentValues = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        this.fireworkColor = fireworkColorIn;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public float[] getColorComponentValues() {
        return this.colorComponentValues;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public static ModDyeColor byId(int colorId) {
        if (colorId < 0 || colorId >= VALUES.length) {
            colorId = 0;
        }
        return VALUES[colorId];
    }

    @Nullable
    public static ModDyeColor byFireworkColor(int fireworkColorIn) {
        return (ModDyeColor)((Object)BY_FIREWORK_COLOR.get(fireworkColorIn));
    }

    public String toString() {
        return this.translationKey;
    }

    public Tag<Item> getTag() {
        return this.tag;
    }

    @Nullable
    public static ModDyeColor getColor(ItemStack stack) {
        if (stack.func_77973_b() instanceof ModDyeItem) {
            return ((ModDyeItem)stack.func_77973_b()).getModDyeColor();
        }
        for (ModDyeColor color : VALUES) {
            if (!stack.func_77973_b().func_206844_a(color.getTag())) continue;
            return color;
        }
        return null;
    }

    static {
        VALUES = (ModDyeColor[])Arrays.stream(ModDyeColor.values()).sorted(Comparator.comparingInt(ModDyeColor::getId)).toArray(ModDyeColor[]::new);
        BY_FIREWORK_COLOR = new Int2ObjectOpenHashMap(Arrays.stream(ModDyeColor.values()).collect(Collectors.toMap(p_199793_0_ -> p_199793_0_.fireworkColor, p_199794_0_ -> p_199794_0_)));
    }
}

