/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.util;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModMaterialColor {
    public static final ModMaterialColor[] COLORS = new ModMaterialColor[64];
    public static final ModMaterialColor MAROON = new ModMaterialColor(0, 0x7A0000);
    public static final ModMaterialColor CORAL = new ModMaterialColor(1, 0xFF7171);
    public static final ModMaterialColor SALMON = new ModMaterialColor(2, 16748901);
    public static final ModMaterialColor APRICOT = new ModMaterialColor(3, 16757865);
    public static final ModMaterialColor AMBER = new ModMaterialColor(4, 16701042);
    public static final ModMaterialColor SIENNA = new ModMaterialColor(5, 9054976);
    public static final ModMaterialColor PEAR = new ModMaterialColor(6, 15859611);
    public static final ModMaterialColor EMERALD_GREEN = new ModMaterialColor(7, 1030520);
    public static final ModMaterialColor FOREST_GREEN = new ModMaterialColor(8, 26112);
    public static final ModMaterialColor JADE = new ModMaterialColor(9, 37484);
    public static final ModMaterialColor TEAL = new ModMaterialColor(10, 32896);
    public static final ModMaterialColor TURQUOISE = new ModMaterialColor(11, 581332);
    public static final ModMaterialColor BURGUNDY = new ModMaterialColor(12, 6624041);
    public static final ModMaterialColor PLUM = new ModMaterialColor(13, 8257608);
    public static final ModMaterialColor LAVENDER = new ModMaterialColor(14, 13216767);
    public static final ModMaterialColor CRIMSON = new ModMaterialColor(15, 11796557);
    public static final ModMaterialColor SNOW = new ModMaterialColor(16, 0xFFFFFF);
    public static final ModMaterialColor ADOBE = new ModMaterialColor(17, 14188339);
    public static final ModMaterialColor MAGENTA = new ModMaterialColor(18, 11685080);
    public static final ModMaterialColor LIGHT_BLUE = new ModMaterialColor(19, 6724056);
    public static final ModMaterialColor YELLOW = new ModMaterialColor(20, 0xE5E533);
    public static final ModMaterialColor LIME = new ModMaterialColor(21, 8375321);
    public static final ModMaterialColor PINK = new ModMaterialColor(22, 15892389);
    public static final ModMaterialColor GRAY = new ModMaterialColor(23, 0x4C4C4C);
    public static final ModMaterialColor LIGHT_GRAY = new ModMaterialColor(24, 0x999999);
    public static final ModMaterialColor CYAN = new ModMaterialColor(25, 5013401);
    public static final ModMaterialColor PURPLE = new ModMaterialColor(26, 8339378);
    public static final ModMaterialColor BLUE = new ModMaterialColor(27, 3361970);
    public static final ModMaterialColor BROWN = new ModMaterialColor(28, 6704179);
    public static final ModMaterialColor GREEN = new ModMaterialColor(29, 6717235);
    public static final ModMaterialColor RED = new ModMaterialColor(30, 0x993333);
    public static final ModMaterialColor BLACK = new ModMaterialColor(31, 0x191919);
    public final int colorValue;
    public final int colorIndex;

    private ModMaterialColor(int index, int color) {
        if (index < 0 || index > 63) {
            throw new IndexOutOfBoundsException("Map colour ID must be between 0 and 63 (inclusive)");
        }
        this.colorIndex = index;
        this.colorValue = color;
        ModMaterialColor.COLORS[index] = this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMapColor(int index) {
        int i = 220;
        if (index == 3) {
            i = 135;
        }
        if (index == 2) {
            i = 255;
        }
        if (index == 0) {
            i = 180;
        }
        int j = (this.colorValue >> 16 & 0xFF) * i / 255;
        int k = (this.colorValue >> 8 & 0xFF) * i / 255;
        int l = (this.colorValue & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }
}

