/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.world.gen;

import com.imwindow.buildersplus.config.ConfigRegistry;
import com.imwindow.buildersplus.init.ModBlocks;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="buildersplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OreGeneration {
    public static final OreFeatureConfig.FillerBlockType GRAVEL = OreFeatureConfig.FillerBlockType.create((String)"GRAVEL", (String)"gravel", (Predicate)new BlockMatcher(Blocks.field_150351_n));
    private static final ArrayList<ConfiguredFeature<?, ?>> plainsGen = new ArrayList();

    @SubscribeEvent
    public static void generateOres(FMLLoadCompleteEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.OCEAN) {
                if (((Boolean)ConfigRegistry.limestoneSpawn.get()).booleanValue()) {
                    OreGeneration.genOre(biome, 4, 30, 5, 70, GRAVEL, ((Block)ModBlocks.LIMESTONE.get()).func_176223_P(), 70);
                }
                OreGeneration.genOre(biome, 4, 40, 5, 70, GRAVEL, ((Block)ModBlocks.GABBRO.get()).func_176223_P(), 40);
                OreGeneration.genOre(biome, 4, 30, 5, 70, GRAVEL, Blocks.field_150348_b.func_176223_P(), 50);
                if (((Boolean)ConfigRegistry.basaltSpawn.get()).booleanValue()) {
                    OreGeneration.genOre(biome, 4, 40, 5, 70, GRAVEL, ((Block)ModBlocks.BASALT.get()).func_176223_P(), 30);
                }
                if (((Boolean)ConfigRegistry.marbleSpawn.get()).booleanValue()) {
                    OreGeneration.genOre(biome, 4, 30, 5, 70, GRAVEL, ((Block)ModBlocks.MARBLE.get()).func_176223_P(), 65);
                }
                OreGeneration.genOre(biome, 4, 30, 5, 70, GRAVEL, Blocks.field_196654_e.func_176223_P(), 70);
                OreGeneration.genOre(biome, 4, 30, 5, 70, GRAVEL, Blocks.field_196656_g.func_176223_P(), 50);
            }
            if (biome.func_201856_r() == Biome.Category.PLAINS) {
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)FlowerConfig.PLAINS_FLOWER_CONFIG).func_227228_a_(Placement.field_215020_f.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 15, 4))));
                continue;
            }
            if (((Boolean)ConfigRegistry.marbleSpawn.get()).booleanValue()) {
                OreGeneration.genOre(biome, 3, 10, 5, 120, OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ModBlocks.MARBLE.get()).func_176223_P(), 50);
            }
            if (((Boolean)ConfigRegistry.limestoneSpawn.get()).booleanValue()) {
                OreGeneration.genOre(biome, 3, 25, 5, 70, OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ModBlocks.LIMESTONE.get()).func_176223_P(), 20);
            }
            if (((Boolean)ConfigRegistry.basaltSpawn.get()).booleanValue()) {
                OreGeneration.genOre(biome, 3, 6, 5, 18, OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ModBlocks.BASALT.get()).func_176223_P(), 30);
            }
            OreGeneration.genOre(biome, 3, 6, 5, 18, OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ModBlocks.GABBRO.get()).func_176223_P(), 30);
            OreGeneration.genOre(biome, 3, 6, 5, 18, OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ModBlocks.DACITE.get()).func_176223_P(), 30);
        }
    }

    private static void genOre(Biome biome, int count, int bottomOffset, int topOffset, int max, OreFeatureConfig.FillerBlockType filler, BlockState defaultBlockstate, int size) {
        CountRangeConfig range = new CountRangeConfig(count, bottomOffset, topOffset, max);
        OreFeatureConfig feature = new OreFeatureConfig(filler, defaultBlockstate, size);
        ConfiguredPlacement config = Placement.field_215028_n.func_227446_a_((IPlacementConfig)range);
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)feature).func_227228_a_(config));
    }

    public static final class FlowerConfig {
        public static final BlockClusterFeatureConfig PLAINS_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)ModBlocks.LAVENDER_DAHLIA.get()).func_176223_P(), 1).func_227407_a_(((Block)ModBlocks.BURGUNDY_DAHLIA.get()).func_176223_P(), 1).func_227407_a_(((Block)ModBlocks.SWORD_LILY.get()).func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    }
}

