/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks.beds;

import com.imwindow.buildersplus.blocks.beds.BD_BedTileEntity;
import com.imwindow.buildersplus.util.ExtraColor;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

public class BD_BedBlock
extends HorizontalBlock
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    protected static final VoxelShape field_220176_c = Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape field_220177_d = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape field_220178_e = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape field_220179_f = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape field_220180_g = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_FACING_SHAPE = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220177_d, field_220179_f});
    protected static final VoxelShape SOUTH_FACING_SHAPE = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220178_e, field_220180_g});
    protected static final VoxelShape WEST_FACING_SHAPE = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220177_d, field_220178_e});
    protected static final VoxelShape EAST_FACING_SHAPE = VoxelShapes.func_216384_a((VoxelShape)field_220176_c, (VoxelShape[])new VoxelShape[]{field_220179_f, field_220180_g});
    private final ExtraColor color;

    public BD_BedBlock(ExtraColor colorIn, AbstractBlock.Properties properties) {
        super(properties);
        this.color = colorIn;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b(PART) != BedPart.HEAD && !(state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!BD_BedBlock.doesBedWork(worldIn)) {
            worldIn.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d());
            if (worldIn.func_180495_p(blockpos).func_203425_a((Block)this)) {
                worldIn.func_217377_a(blockpos, false);
            }
            worldIn.func_230546_a_((Entity)null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)OCCUPIED)).booleanValue()) {
            if (!this.tryWakeUpVillager(worldIn, pos)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied"), true);
            }
            return ActionResultType.SUCCESS;
        }
        player.func_213819_a(pos).ifLeft(p_220173_1_ -> {
            if (p_220173_1_ != null) {
                assert (p_220173_1_.func_221259_a() != null);
                player.func_146105_b(p_220173_1_.func_221259_a(), true);
            }
        });
        return ActionResultType.SUCCESS;
    }

    public static boolean doesBedWork(World world) {
        return world.func_230315_m_().func_241510_j_();
    }

    private boolean tryWakeUpVillager(World world, BlockPos pos) {
        List list = world.func_175647_a(VillagerEntity.class, new AxisAlignedBB(pos), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        ((VillagerEntity)list.get(0)).func_213366_dy();
        return true;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.func_226860_a_(entityIn);
        }
    }

    private void func_226860_a_(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d0, vector3d.field_72449_c);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == BD_BedBlock.getDirectionToOther((BedPart)stateIn.func_177229_b(PART), (Direction)stateIn.func_177229_b((Property)field_185512_D))) {
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((Property)OCCUPIED, facingState.func_177229_b((Property)OCCUPIED)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static Direction getDirectionToOther(BedPart p_208070_0_, Direction direction) {
        return p_208070_0_ == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!worldIn.field_72995_K && player.func_184812_l_() && (bedpart = (BedPart)state.func_177229_b(PART)) == BedPart.FOOT && (blockstate = worldIn.func_180495_p(blockpos = pos.func_177972_a(BD_BedBlock.getDirectionToOther(bedpart, (Direction)state.func_177229_b((Property)field_185512_D))))).func_177230_c() == this && blockstate.func_177229_b(PART) == BedPart.HEAD) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction) : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = BD_BedBlock.func_226862_h_(state).func_176734_d();
        switch (direction) {
            case NORTH: {
                return NORTH_FACING_SHAPE;
            }
            case SOUTH: {
                return SOUTH_FACING_SHAPE;
            }
            case WEST: {
                return WEST_FACING_SHAPE;
            }
        }
        return EAST_FACING_SHAPE;
    }

    public static Direction func_226862_h_(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        return state.func_177229_b(PART) == BedPart.HEAD ? direction.func_176734_d() : direction;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.Type getMergeType(BlockState state) {
        BedPart bedpart = (BedPart)state.func_177229_b(PART);
        return bedpart == BedPart.HEAD ? TileEntityMerger.Type.FIRST : TileEntityMerger.Type.SECOND;
    }

    public Optional<Vector3d> getBedSpawnPosition(EntityType<?> entityType, BlockState state, IWorldReader world, BlockPos pos, float orientation, @Nullable LivingEntity sleeper) {
        if (world instanceof World) {
            return BD_BedBlock.getBedSpawnPosition(entityType, (ICollisionReader)world, pos, orientation);
        }
        return Optional.empty();
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, @Nullable Entity player) {
        return this.getBlock() instanceof BD_BedBlock;
    }

    public void setBedOccupied(BlockState state, World world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    public Direction getBedDirection(BlockState state, IWorldReader world, BlockPos pos) {
        return (Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D);
    }

    public static Optional<Vector3d> getBedSpawnPosition(EntityType<?> p_242652_0_, ICollisionReader p_242652_1_, BlockPos p_242652_2_, float p_242652_3_) {
        Direction direction2;
        Direction direction = (Direction)p_242652_1_.func_180495_p(p_242652_2_).func_177229_b((Property)field_185512_D);
        Direction direction1 = direction.func_176746_e();
        Direction direction3 = direction2 = direction1.func_243532_a(p_242652_3_) ? direction1.func_176734_d() : direction1;
        if (BD_BedBlock.func_242657_b((IBlockReader)p_242652_1_, p_242652_2_)) {
            return BD_BedBlock.getWakeupDisplacement(p_242652_0_, p_242652_1_, p_242652_2_, direction, direction2);
        }
        int[][] aint = BD_BedBlock.func_242656_a(direction, direction2);
        Optional<Vector3d> optional = BD_BedBlock.func_242654_a(p_242652_0_, p_242652_1_, p_242652_2_, aint, true);
        return optional.isPresent() ? optional : BD_BedBlock.func_242654_a(p_242652_0_, p_242652_1_, p_242652_2_, aint, false);
    }

    private static Optional<Vector3d> getWakeupDisplacement(EntityType<?> p_242653_0_, ICollisionReader p_242653_1_, BlockPos p_242653_2_, Direction p_242653_3_, Direction p_242653_4_) {
        int[][] aint = BD_BedBlock.func_242658_b(p_242653_3_, p_242653_4_);
        Optional<Vector3d> optional = BD_BedBlock.func_242654_a(p_242653_0_, p_242653_1_, p_242653_2_, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockpos = p_242653_2_.func_177977_b();
        Optional<Vector3d> optional1 = BD_BedBlock.func_242654_a(p_242653_0_, p_242653_1_, blockpos, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = BD_BedBlock.func_242655_a(p_242653_3_);
        Optional<Vector3d> optional2 = BD_BedBlock.func_242654_a(p_242653_0_, p_242653_1_, p_242653_2_, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vector3d> optional3 = BD_BedBlock.func_242654_a(p_242653_0_, p_242653_1_, p_242653_2_, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vector3d> optional4 = BD_BedBlock.func_242654_a(p_242653_0_, p_242653_1_, blockpos, aint, false);
        return optional4.isPresent() ? optional4 : BD_BedBlock.func_242654_a(p_242653_0_, p_242653_1_, p_242653_2_, aint1, false);
    }

    private static Optional<Vector3d> func_242654_a(EntityType<?> p_242654_0_, ICollisionReader p_242654_1_, BlockPos p_242654_2_, int[][] p_242654_3_, boolean p_242654_4_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int[] aint : p_242654_3_) {
            blockpos$mutable.func_181079_c(p_242654_2_.func_177958_n() + aint[0], p_242654_2_.func_177956_o(), p_242654_2_.func_177952_p() + aint[1]);
            Vector3d vector3d = TransportationHelper.func_242379_a(p_242654_0_, (ICollisionReader)p_242654_1_, (BlockPos)blockpos$mutable, (boolean)p_242654_4_);
            if (vector3d == null) continue;
            return Optional.of(vector3d);
        }
        return Optional.empty();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, PART, OCCUPIED});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BD_BedTileEntity(this.color);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D));
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ExtraColor getColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((Direction)state.func_177229_b((Property)field_185512_D), state.func_177229_b(PART) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private static int[][] func_242656_a(Direction p_242656_0_, Direction p_242656_1_) {
        return (int[][])ArrayUtils.addAll((Object[])BD_BedBlock.func_242658_b(p_242656_0_, p_242656_1_), (Object[])BD_BedBlock.func_242655_a(p_242656_0_));
    }

    private static int[][] func_242658_b(Direction p_242658_0_, Direction p_242658_1_) {
        return new int[][]{{p_242658_1_.func_82601_c(), p_242658_1_.func_82599_e()}, {p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c(), p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e()}, {p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c() * 2, p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e() * 2}, {-p_242658_0_.func_82601_c() * 2, -p_242658_0_.func_82599_e() * 2}, {-p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c() * 2, -p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e() * 2}, {-p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c(), -p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e()}, {-p_242658_1_.func_82601_c(), -p_242658_1_.func_82599_e()}, {-p_242658_1_.func_82601_c() + p_242658_0_.func_82601_c(), -p_242658_1_.func_82599_e() + p_242658_0_.func_82599_e()}, {p_242658_0_.func_82601_c(), p_242658_0_.func_82599_e()}, {p_242658_1_.func_82601_c() + p_242658_0_.func_82601_c(), p_242658_1_.func_82599_e() + p_242658_0_.func_82599_e()}};
    }

    private static int[][] func_242655_a(Direction p_242655_0_) {
        return new int[][]{{0, 0}, {-p_242655_0_.func_82601_c(), -p_242655_0_.func_82599_e()}};
    }

    private static boolean func_242657_b(IBlockReader p_242657_0_, BlockPos p_242657_1_) {
        return p_242657_0_.func_180495_p(p_242657_1_.func_177977_b()).func_177230_c() instanceof BedBlock;
    }
}

