/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks.shulker;

import com.imwindow.buildersplus.blocks.shulker.BD_ShulkerBoxTileEntity;
import com.imwindow.buildersplus.init.BD_Blocks;
import com.imwindow.buildersplus.util.BD_DyeColor;
import com.imwindow.buildersplus.util.ExtraColor;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BD_ShulkerBoxBlock
extends ShulkerBoxBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.field_176387_N;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    @Nullable
    private final ExtraColor modColor;
    @Nullable
    private final DyeColor color;

    public BD_ShulkerBoxBlock(@Nullable DyeColor color, @Nullable ExtraColor modColor, AbstractBlock.Properties properties) {
        super(color, properties);
        this.modColor = modColor;
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(FACING, (Comparable)Direction.UP));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BD_ShulkerBoxTileEntity(this.modColor);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BD_ShulkerBoxTileEntity) {
            boolean flag;
            BD_ShulkerBoxTileEntity shulkerboxtileentity = (BD_ShulkerBoxTileEntity)tileentity;
            if (shulkerboxtileentity.getAnimationStatus() == BD_ShulkerBoxTileEntity.AnimationStatus.CLOSED) {
                Direction direction = (Direction)state.func_177229_b(FACING);
                flag = worldIn.func_226664_a_(ShulkerAABBHelper.func_233539_a_((BlockPos)pos, (Direction)direction));
            } else {
                flag = true;
            }
            if (flag) {
                player.func_213829_a((INamedContainerProvider)shulkerboxtileentity);
                player.func_195066_a(Stats.field_191272_ae);
                PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_196000_l());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BD_ShulkerBoxTileEntity) {
            BD_ShulkerBoxTileEntity shulkerboxtileentity = (BD_ShulkerBoxTileEntity)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !shulkerboxtileentity.func_191420_l()) {
                ItemStack itemstack = BD_ShulkerBoxBlock.getColoredItemStack(this.getModColor());
                CompoundNBT compoundnbt = shulkerboxtileentity.saveToNbt(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                if (shulkerboxtileentity.func_145818_k_()) {
                    itemstack.func_200302_a(shulkerboxtileentity.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                shulkerboxtileentity.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof BD_ShulkerBoxTileEntity) {
            BD_ShulkerBoxTileEntity shulkerboxtileentity = (BD_ShulkerBoxTileEntity)tileentity;
            builder = builder.func_216017_a(CONTENTS, (p_220168_1_, p_220168_2_) -> {
                for (int i = 0; i < shulkerboxtileentity.func_70302_i_(); ++i) {
                    p_220168_2_.accept(shulkerboxtileentity.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof BD_ShulkerBoxTileEntity) {
            ((BD_ShulkerBoxTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof BD_ShulkerBoxTileEntity) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof BD_ShulkerBoxTileEntity ? VoxelShapes.func_197881_a((AxisAlignedBB)((BD_ShulkerBoxTileEntity)tileentity).getBoundingBox(state)) : VoxelShapes.func_197868_b();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = new ItemStack((IItemProvider)this);
        BD_ShulkerBoxTileEntity shulkerboxtileentity = (BD_ShulkerBoxTileEntity)worldIn.func_175625_s(pos);
        assert (shulkerboxtileentity != null);
        CompoundNBT compoundnbt = shulkerboxtileentity.saveToNbt(new CompoundNBT());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ExtraColor getColor(Block blockIn) {
        return blockIn instanceof BD_ShulkerBoxBlock ? ((BD_ShulkerBoxBlock)blockIn).getModColor() : null;
    }

    public static Block getBlockByColor(@Nullable ExtraColor colorIn) {
        switch (Objects.requireNonNull(colorIn)) {
            case CORAL: {
                return (Block)BD_Blocks.CORAL_SHULKER.get();
            }
            case SALMON: {
                return (Block)BD_Blocks.SALMON_SHULKER.get();
            }
            case APRICOT: {
                return (Block)BD_Blocks.APRICOT_SHULKER.get();
            }
            case AMBER: {
                return (Block)BD_Blocks.AMBER_SHULKER.get();
            }
            case SIENNA: {
                return (Block)BD_Blocks.SIENNA_SHULKER.get();
            }
            case PEAR: {
                return (Block)BD_Blocks.PEAR_SHULKER.get();
            }
            case EMERALD_GREEN: {
                return (Block)BD_Blocks.EMERALD_SHULKER.get();
            }
            case FOREST_GREEN: {
                return (Block)BD_Blocks.FOREST_GREEN_SHULKER.get();
            }
            case JADE: {
                return (Block)BD_Blocks.JADE_SHULKER.get();
            }
            case TEAL: {
                return (Block)BD_Blocks.TEAL_SHULKER.get();
            }
            case TURQUOISE: {
                return (Block)BD_Blocks.TURQUOISE_SHULKER.get();
            }
            case BURGUNDY: {
                return (Block)BD_Blocks.BURGUNDY_SHULKER.get();
            }
            case PLUM: {
                return (Block)BD_Blocks.PLUM_SHULKER.get();
            }
            case LAVENDER: {
                return (Block)BD_Blocks.LAVENDER_SHULKER.get();
            }
            case CRIMSON: {
                return (Block)BD_Blocks.CRIMSON_SHULKER.get();
            }
        }
        return (Block)BD_Blocks.MAROON_SHULKER.get();
    }

    public static Block getBlockByColor2(@Nullable BD_DyeColor colorIn) {
        switch (Objects.requireNonNull(colorIn)) {
            case CORAL: {
                return (Block)BD_Blocks.CORAL_SHULKER.get();
            }
            case SALMON: {
                return (Block)BD_Blocks.SALMON_SHULKER.get();
            }
            case APRICOT: {
                return (Block)BD_Blocks.APRICOT_SHULKER.get();
            }
            case AMBER: {
                return (Block)BD_Blocks.AMBER_SHULKER.get();
            }
            case SIENNA: {
                return (Block)BD_Blocks.SIENNA_SHULKER.get();
            }
            case PEAR: {
                return (Block)BD_Blocks.PEAR_SHULKER.get();
            }
            case EMERALD_GREEN: {
                return (Block)BD_Blocks.EMERALD_SHULKER.get();
            }
            case FOREST_GREEN: {
                return (Block)BD_Blocks.FOREST_GREEN_SHULKER.get();
            }
            case JADE: {
                return (Block)BD_Blocks.JADE_SHULKER.get();
            }
            case TEAL: {
                return (Block)BD_Blocks.TEAL_SHULKER.get();
            }
            case TURQUOISE: {
                return (Block)BD_Blocks.TURQUOISE_SHULKER.get();
            }
            case BURGUNDY: {
                return (Block)BD_Blocks.BURGUNDY_SHULKER.get();
            }
            case PLUM: {
                return (Block)BD_Blocks.PLUM_SHULKER.get();
            }
            case LAVENDER: {
                return (Block)BD_Blocks.LAVENDER_SHULKER.get();
            }
            case CRIMSON: {
                return (Block)BD_Blocks.CRIMSON_SHULKER.get();
            }
        }
        return (Block)BD_Blocks.MAROON_SHULKER.get();
    }

    @Nullable
    public ExtraColor getModColor() {
        return this.modColor;
    }

    @Nullable
    public DyeColor func_190956_e() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable ExtraColor colorIn) {
        return new ItemStack((IItemProvider)BD_ShulkerBoxBlock.getBlockByColor(colorIn));
    }

    public static ItemStack getColoredItemStack2(@Nullable BD_DyeColor colorIn) {
        return new ItemStack((IItemProvider)BD_ShulkerBoxBlock.getBlockByColor2(colorIn));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a(FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b(FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b(FACING)));
    }
}

