/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.entity;

import com.google.common.collect.Maps;
import com.imwindow.buildersplus.entity.BD_LootTables;
import com.imwindow.buildersplus.init.BD_Blocks;
import com.imwindow.buildersplus.init.BD_EntityType;
import com.imwindow.buildersplus.util.BD_DyeColor;
import com.imwindow.buildersplus.util.BD_DyeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class BD_SheepEntity
extends AnimalEntity
implements IShearable,
IForgeShearable {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(BD_SheepEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Map<BD_DyeColor, IItemProvider> WOOL_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(BD_DyeColor.class), p_203402_0_ -> {
        p_203402_0_.put(BD_DyeColor.WHITE, Blocks.field_196556_aL);
        p_203402_0_.put(BD_DyeColor.ORANGE, Blocks.field_196557_aM);
        p_203402_0_.put(BD_DyeColor.MAGENTA, Blocks.field_196558_aN);
        p_203402_0_.put(BD_DyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        p_203402_0_.put(BD_DyeColor.YELLOW, Blocks.field_196560_aP);
        p_203402_0_.put(BD_DyeColor.LIME, Blocks.field_196561_aQ);
        p_203402_0_.put(BD_DyeColor.PINK, Blocks.field_196562_aR);
        p_203402_0_.put(BD_DyeColor.GRAY, Blocks.field_196563_aS);
        p_203402_0_.put(BD_DyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        p_203402_0_.put(BD_DyeColor.CYAN, Blocks.field_196565_aU);
        p_203402_0_.put(BD_DyeColor.PURPLE, Blocks.field_196566_aV);
        p_203402_0_.put(BD_DyeColor.BLUE, Blocks.field_196567_aW);
        p_203402_0_.put(BD_DyeColor.BROWN, Blocks.field_196568_aX);
        p_203402_0_.put(BD_DyeColor.GREEN, Blocks.field_196569_aY);
        p_203402_0_.put(BD_DyeColor.RED, Blocks.field_196570_aZ);
        p_203402_0_.put(BD_DyeColor.BLACK, Blocks.field_196602_ba);
        p_203402_0_.put(BD_DyeColor.MAROON, BD_Blocks.MAROON_WOOL.get());
        p_203402_0_.put(BD_DyeColor.CORAL, BD_Blocks.CORAL_WOOL.get());
        p_203402_0_.put(BD_DyeColor.SALMON, BD_Blocks.SALMON_WOOL.get());
        p_203402_0_.put(BD_DyeColor.APRICOT, BD_Blocks.APRICOT_WOOL.get());
        p_203402_0_.put(BD_DyeColor.AMBER, BD_Blocks.AMBER_WOOL.get());
        p_203402_0_.put(BD_DyeColor.SIENNA, BD_Blocks.SIENNA_WOOL.get());
        p_203402_0_.put(BD_DyeColor.PEAR, BD_Blocks.PEAR_WOOL.get());
        p_203402_0_.put(BD_DyeColor.EMERALD_GREEN, BD_Blocks.EMERALD_WOOL.get());
        p_203402_0_.put(BD_DyeColor.FOREST_GREEN, BD_Blocks.FOREST_GREEN_WOOL.get());
        p_203402_0_.put(BD_DyeColor.JADE, BD_Blocks.JADE_WOOL.get());
        p_203402_0_.put(BD_DyeColor.TEAL, BD_Blocks.TEAL_WOOL.get());
        p_203402_0_.put(BD_DyeColor.TURQUOISE, BD_Blocks.TURQUOISE_WOOL.get());
        p_203402_0_.put(BD_DyeColor.BURGUNDY, BD_Blocks.BURGUNDY_WOOL.get());
        p_203402_0_.put(BD_DyeColor.PLUM, BD_Blocks.PLUM_WOOL.get());
        p_203402_0_.put(BD_DyeColor.LAVENDER, BD_Blocks.LAVENDER_WOOL.get());
        p_203402_0_.put(BD_DyeColor.CRIMSON, BD_Blocks.CRIMSON_WOOL.get());
    });
    private static final Map<BD_DyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(Arrays.stream(BD_DyeColor.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, BD_SheepEntity::createSheepColor)));
    private int sheepTimer;
    private EatGrassGoal eatGrassGoal;

    private static float[] createSheepColor(BD_DyeColor dyeColorIn) {
        if (dyeColorIn == BD_DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = dyeColorIn.getColorComponentValues();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_196133_cQ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float[] getDyeRgb(BD_DyeColor dyeColor) {
        return DYE_TO_RGB.get((Object)dyeColor);
    }

    public BD_SheepEntity(EntityType<? extends BD_SheepEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, SheepEntity.class));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.eatGrassGoal.func_151499_f();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    public ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.getFleeceColor()) {
            default: {
                return LootTables.field_186404_L;
            }
            case ORANGE: {
                return LootTables.field_186405_M;
            }
            case MAGENTA: {
                return LootTables.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTables.field_186407_O;
            }
            case YELLOW: {
                return LootTables.field_186408_P;
            }
            case LIME: {
                return LootTables.field_186409_Q;
            }
            case PINK: {
                return LootTables.field_186410_R;
            }
            case GRAY: {
                return LootTables.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTables.field_197738_Y;
            }
            case CYAN: {
                return LootTables.field_186413_U;
            }
            case PURPLE: {
                return LootTables.field_186414_V;
            }
            case BLUE: {
                return LootTables.field_186415_W;
            }
            case BROWN: {
                return LootTables.field_186416_X;
            }
            case GREEN: {
                return LootTables.field_186417_Y;
            }
            case RED: {
                return LootTables.field_186418_Z;
            }
            case BLACK: {
                return LootTables.field_186376_aa;
            }
            case MAROON: {
                return BD_LootTables.ENTITIES_SHEEP_MAROON;
            }
            case CORAL: {
                return BD_LootTables.ENTITIES_SHEEP_CORAL;
            }
            case SALMON: {
                return BD_LootTables.ENTITIES_SHEEP_SALMON;
            }
            case APRICOT: {
                return BD_LootTables.ENTITIES_SHEEP_APRICOT;
            }
            case AMBER: {
                return BD_LootTables.ENTITIES_SHEEP_AMBER;
            }
            case SIENNA: {
                return BD_LootTables.ENTITIES_SHEEP_SIENNA;
            }
            case PEAR: {
                return BD_LootTables.ENTITIES_SHEEP_PEAR;
            }
            case EMERALD_GREEN: {
                return BD_LootTables.ENTITIES_SHEEP_EMERALD;
            }
            case FOREST_GREEN: {
                return BD_LootTables.ENTITIES_SHEEP_FOREST_GREEN;
            }
            case JADE: {
                return BD_LootTables.ENTITIES_SHEEP_JADE;
            }
            case TEAL: {
                return BD_LootTables.ENTITIES_SHEEP_TEAL;
            }
            case TURQUOISE: {
                return BD_LootTables.ENTITIES_SHEEP_TURQUOISE;
            }
            case BURGUNDY: {
                return BD_LootTables.ENTITIES_SHEEP_BURGUNDY;
            }
            case PLUM: {
                return BD_LootTables.ENTITIES_SHEEP_PLUM;
            }
            case LAVENDER: {
                return BD_LootTables.ENTITIES_SHEEP_LAVENDER;
            }
            case CRIMSON: 
        }
        return BD_LootTables.ENTITIES_SHEEP_CRIMSON;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() instanceof DyeItem) {
            SheepEntity sheep = new SheepEntity(EntityType.field_200737_ac, this.field_70170_p);
            if (this.func_70089_S() && !this.getSheared()) {
                if (this.func_70631_g_()) {
                    sheep.func_82227_f(true);
                }
                sheep.field_70125_A = this.field_70125_A;
                sheep.field_70177_z = this.field_70177_z;
                sheep.field_70759_as = this.field_70759_as;
                sheep.func_213317_d(this.func_213322_ci());
                sheep.func_82149_j((Entity)this);
                sheep.func_175512_b(((DyeItem)itemstack.func_77973_b()).func_195962_g());
                this.field_70170_p.func_217376_c((Entity)sheep);
                this.func_70106_y();
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        if (itemstack.func_77973_b() == Items.field_196133_cQ) {
            BD_SheepEntity modSheep = new BD_SheepEntity((EntityType<? extends BD_SheepEntity>)((EntityType)BD_EntityType.SHEEP.get()), this.field_70170_p);
            modSheep.func_82149_j((Entity)this);
            modSheep.func_82227_f(true);
            modSheep.setFleeceColor(this.getFleeceColor());
            this.field_70170_p.func_217376_c((Entity)modSheep);
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.func_199702_a(WOOL_BY_COLOR.get((Object)this.getFleeceColor()), 1);
            if (itementity == null) continue;
            itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
        }
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.getSheared() && !this.func_70631_g_();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        compound.func_74774_a("Color", (byte)this.getFleeceColor().getId());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setFleeceColor(BD_DyeColor.byId(compound.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f);
    }

    public BD_DyeColor getFleeceColor() {
        return BD_DyeColor.byId((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x1F);
    }

    public void setFleeceColor(BD_DyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.getId() & 0x1F)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x20) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x20)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFDF)));
        }
    }

    public static BD_DyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        int j = random.nextInt(1000);
        if (i < 5) {
            return BD_DyeColor.BLACK;
        }
        if (i < 10) {
            return BD_DyeColor.GRAY;
        }
        if (i < 15) {
            return BD_DyeColor.LIGHT_GRAY;
        }
        if (i < 18) {
            return BD_DyeColor.BROWN;
        }
        if (j == 1) {
            return BD_DyeColor.LAVENDER;
        }
        return random.nextInt(500) == 0 ? BD_DyeColor.PINK : BD_DyeColor.WHITE;
    }

    public BD_SheepEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        BD_SheepEntity sheepentity = (BD_SheepEntity)ageableEntity;
        BD_SheepEntity sheepentity1 = (BD_SheepEntity)((EntityType)BD_EntityType.SHEEP.get()).func_200721_a((World)serverWorld);
        assert (sheepentity1 != null);
        sheepentity1.setFleeceColor(this.getDyeColorMixFromParents(this, sheepentity));
        return sheepentity1;
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setFleeceColor(BD_SheepEntity.getRandomSheepColor(worldIn.func_201674_k()));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private BD_DyeColor getDyeColorMixFromParents(AnimalEntity father, AnimalEntity mother) {
        BD_DyeColor dyecolor = ((BD_SheepEntity)father).getFleeceColor();
        BD_DyeColor dyecolor1 = ((BD_SheepEntity)mother).getFleeceColor();
        CraftingInventory craftinginventory = BD_SheepEntity.createDyeColorCraftingInventory(dyecolor, dyecolor1);
        return this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftinginventory, this.field_70170_p).map(p_213614_1_ -> p_213614_1_.func_77572_b((IInventory)craftinginventory)).map(ItemStack::func_77973_b).filter(BD_DyeItem.class::isInstance).map(BD_DyeItem.class::cast).map(BD_DyeItem::getModDyeColor).orElseGet(() -> this.field_70170_p.field_73012_v.nextBoolean() ? dyecolor : dyecolor1);
    }

    private static CraftingInventory createDyeColorCraftingInventory(BD_DyeColor color, BD_DyeColor color1) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 2, 1);
        craftinginventory.func_70299_a(0, new ItemStack((IItemProvider)BD_DyeItem.getModItem(color)));
        craftinginventory.func_70299_a(1, new ItemStack((IItemProvider)BD_DyeItem.getModItem(color1)));
        return craftinginventory;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.95f * sizeIn.field_220316_b;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            this.setSheared(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack(WOOL_BY_COLOR.get((Object)this.getFleeceColor())));
            }
            return items;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void lambda$func_230254_b_$2(Hand hand, PlayerEntity p_213613_1_) {
        p_213613_1_.func_213334_d(hand);
    }
}

