/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.util;

import com.imwindow.buildersplus.util.BD_DyeItem;
import com.imwindow.buildersplus.util.BD_MaterialColor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;

public enum BD_DyeColor {
    WHITE(0, "white", 0xF9FFFE, BD_MaterialColor.SNOW, 0xF0F0F0, 0xFFFFFF),
    ORANGE(1, "orange", 16351261, BD_MaterialColor.ADOBE, 15435844, 16738335),
    MAGENTA(2, "magenta", 13061821, BD_MaterialColor.MAGENTA, 12801229, 0xFF00FF),
    LIGHT_BLUE(3, "light_blue", 3847130, BD_MaterialColor.LIGHT_BLUE, 6719955, 10141901),
    YELLOW(4, "yellow", 16701501, BD_MaterialColor.YELLOW, 14602026, 0xFFFF00),
    LIME(5, "lime", 8439583, BD_MaterialColor.LIME, 4312372, 0xBFFF00),
    PINK(6, "pink", 15961002, BD_MaterialColor.PINK, 14188952, 16738740),
    GRAY(7, "gray", 4673362, BD_MaterialColor.GRAY, 0x434343, 0x808080),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, BD_MaterialColor.LIGHT_GRAY, 0xABABAB, 0xD3D3D3),
    CYAN(9, "cyan", 1481884, BD_MaterialColor.CYAN, 2651799, 65535),
    PURPLE(10, "purple", 8991416, BD_MaterialColor.PURPLE, 8073150, 10494192),
    BLUE(11, "blue", 3949738, BD_MaterialColor.BLUE, 2437522, 255),
    BROWN(12, "brown", 8606770, BD_MaterialColor.BROWN, 5320730, 9127187),
    GREEN(13, "green", 6192150, BD_MaterialColor.GREEN, 3887386, 65280),
    RED(14, "red", 11546150, BD_MaterialColor.RED, 11743532, 0xFF0000),
    BLACK(15, "black", 0x1D1D21, BD_MaterialColor.BLACK, 0x1E1B1B, 0),
    MAROON(16, "maroon", 0x7A0000, BD_MaterialColor.MAROON, 0x7A0000, 0x7A0000),
    CORAL(17, "coral", 0xFF7171, BD_MaterialColor.CORAL, 0xFF7171, 0xFF7171),
    SALMON(18, "salmon", 16748901, BD_MaterialColor.SALMON, 16748901, 16748901),
    APRICOT(19, "apricot", 16757865, BD_MaterialColor.APRICOT, 16757865, 16757865),
    AMBER(20, "amber", 16701042, BD_MaterialColor.AMBER, 16701042, 16701042),
    SIENNA(21, "sienna", 9054976, BD_MaterialColor.SIENNA, 9054976, 9054976),
    PEAR(22, "pear", 15859611, BD_MaterialColor.PEAR, 15859611, 15859611),
    EMERALD_GREEN(23, "emerald_green", 1030520, BD_MaterialColor.EMERALD_GREEN, 1030520, 1030520),
    FOREST_GREEN(24, "forest_green", 26112, BD_MaterialColor.FOREST_GREEN, 26112, 26112),
    JADE(25, "jade", 37484, BD_MaterialColor.JADE, 37484, 37484),
    TEAL(26, "teal", 32896, BD_MaterialColor.TEAL, 32896, 32896),
    TURQUOISE(27, "turquoise", 581332, BD_MaterialColor.TURQUOISE, 581332, 581332),
    BURGUNDY(28, "burgundy", 6624041, BD_MaterialColor.BURGUNDY, 6624041, 6624041),
    PLUM(29, "plum", 8257608, BD_MaterialColor.PLUM, 8257608, 8257608),
    LAVENDER(30, "lavender", 13216767, BD_MaterialColor.LAVENDER, 13216767, 13216767),
    CRIMSON(31, "crimson", 11796557, BD_MaterialColor.CRIMSON, 11796557, 11796557);

    private static final BD_DyeColor[] VALUES;
    private static final Int2ObjectOpenHashMap<BD_DyeColor> BY_FIREWORK_COLOR;
    private final int id;
    private final String translationKey;
    private final BD_MaterialColor mapColor;
    private final int colorValue;
    private final int swappedColorValue;
    private final float[] colorComponentValues;
    private final int fireworkColor;
    private final ITag<Item> tag;
    private final int textColor;

    private BD_DyeColor(int idIn, String translationKeyIn, int colorValueIn, BD_MaterialColor mapColorIn, int fireworkColorIn, int textColorIn) {
        this.id = idIn;
        this.translationKey = translationKeyIn;
        this.colorValue = colorValueIn;
        this.mapColor = mapColorIn;
        this.textColor = textColorIn;
        int i = (colorValueIn & 0xFF0000) >> 16;
        int j = (colorValueIn & 0xFF00) >> 8;
        int k = colorValueIn & 0xFF;
        this.swappedColorValue = k << 16 | j << 8 | i;
        this.tag = ItemTags.func_199901_a((String)("minecraft:dyes/" + translationKeyIn));
        this.colorComponentValues = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        this.fireworkColor = fireworkColorIn;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public float[] getColorComponentValues() {
        return this.colorComponentValues;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public static BD_DyeColor byId(int colorId) {
        if (colorId < 0 || colorId >= VALUES.length) {
            colorId = 0;
        }
        return VALUES[colorId];
    }

    @Nullable
    public static BD_DyeColor byFireworkColor(int fireworkColorIn) {
        return (BD_DyeColor)((Object)BY_FIREWORK_COLOR.get(fireworkColorIn));
    }

    public String toString() {
        return this.translationKey;
    }

    public ITag<Item> getTag() {
        return this.tag;
    }

    @Nullable
    public static BD_DyeColor getColor(ItemStack stack) {
        if (stack.func_77973_b() instanceof BD_DyeItem) {
            return ((BD_DyeItem)stack.func_77973_b()).getModDyeColor();
        }
        for (BD_DyeColor color : VALUES) {
            if (!stack.func_77973_b().func_206844_a(color.getTag())) continue;
            return color;
        }
        return null;
    }

    static {
        VALUES = (BD_DyeColor[])Arrays.stream(BD_DyeColor.values()).sorted(Comparator.comparingInt(BD_DyeColor::getId)).toArray(BD_DyeColor[]::new);
        BY_FIREWORK_COLOR = new Int2ObjectOpenHashMap(Arrays.stream(BD_DyeColor.values()).collect(Collectors.toMap(p_199793_0_ -> p_199793_0_.fireworkColor, p_199794_0_ -> p_199794_0_)));
    }
}

