/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.util;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BD_MaterialColor {
    public static final BD_MaterialColor[] COLORS = new BD_MaterialColor[64];
    public static final BD_MaterialColor MAROON = new BD_MaterialColor(0, 0x7A0000);
    public static final BD_MaterialColor CORAL = new BD_MaterialColor(1, 0xFF7171);
    public static final BD_MaterialColor SALMON = new BD_MaterialColor(2, 16748901);
    public static final BD_MaterialColor APRICOT = new BD_MaterialColor(3, 16757865);
    public static final BD_MaterialColor AMBER = new BD_MaterialColor(4, 16701042);
    public static final BD_MaterialColor SIENNA = new BD_MaterialColor(5, 9054976);
    public static final BD_MaterialColor PEAR = new BD_MaterialColor(6, 15859611);
    public static final BD_MaterialColor EMERALD_GREEN = new BD_MaterialColor(7, 1030520);
    public static final BD_MaterialColor FOREST_GREEN = new BD_MaterialColor(8, 26112);
    public static final BD_MaterialColor JADE = new BD_MaterialColor(9, 37484);
    public static final BD_MaterialColor TEAL = new BD_MaterialColor(10, 32896);
    public static final BD_MaterialColor TURQUOISE = new BD_MaterialColor(11, 581332);
    public static final BD_MaterialColor BURGUNDY = new BD_MaterialColor(12, 6624041);
    public static final BD_MaterialColor PLUM = new BD_MaterialColor(13, 8257608);
    public static final BD_MaterialColor LAVENDER = new BD_MaterialColor(14, 13216767);
    public static final BD_MaterialColor CRIMSON = new BD_MaterialColor(15, 11796557);
    public static final BD_MaterialColor SNOW = new BD_MaterialColor(16, 0xFFFFFF);
    public static final BD_MaterialColor ADOBE = new BD_MaterialColor(17, 14188339);
    public static final BD_MaterialColor MAGENTA = new BD_MaterialColor(18, 11685080);
    public static final BD_MaterialColor LIGHT_BLUE = new BD_MaterialColor(19, 6724056);
    public static final BD_MaterialColor YELLOW = new BD_MaterialColor(20, 0xE5E533);
    public static final BD_MaterialColor LIME = new BD_MaterialColor(21, 8375321);
    public static final BD_MaterialColor PINK = new BD_MaterialColor(22, 15892389);
    public static final BD_MaterialColor GRAY = new BD_MaterialColor(23, 0x4C4C4C);
    public static final BD_MaterialColor LIGHT_GRAY = new BD_MaterialColor(24, 0x999999);
    public static final BD_MaterialColor CYAN = new BD_MaterialColor(25, 5013401);
    public static final BD_MaterialColor PURPLE = new BD_MaterialColor(26, 8339378);
    public static final BD_MaterialColor BLUE = new BD_MaterialColor(27, 3361970);
    public static final BD_MaterialColor BROWN = new BD_MaterialColor(28, 6704179);
    public static final BD_MaterialColor GREEN = new BD_MaterialColor(29, 6717235);
    public static final BD_MaterialColor RED = new BD_MaterialColor(30, 0x993333);
    public static final BD_MaterialColor BLACK = new BD_MaterialColor(31, 0x191919);
    public final int colorValue;
    public final int colorIndex;

    private BD_MaterialColor(int index, int color) {
        if (index < 0 || index > 63) {
            throw new IndexOutOfBoundsException("Map colour ID must be between 0 and 63 (inclusive)");
        }
        this.colorIndex = index;
        this.colorValue = color;
        BD_MaterialColor.COLORS[index] = this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMapColor(int index) {
        int i = 220;
        if (index == 3) {
            i = 135;
        }
        if (index == 2) {
            i = 255;
        }
        if (index == 0) {
            i = 180;
        }
        int j = (this.colorValue >> 16 & 0xFF) * i / 255;
        int k = (this.colorValue >> 8 & 0xFF) * i / 255;
        int l = (this.colorValue & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }
}

