/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic;

import com.google.gson.Gson;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.client.ClientEvents;
import wayoftime.bloodmagic.client.hud.Elements;
import wayoftime.bloodmagic.client.key.BloodMagicKeyHandler;
import wayoftime.bloodmagic.client.key.KeyBindings;
import wayoftime.bloodmagic.client.model.MimicModelLoader;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.data.GeneratorBaseRecipes;
import wayoftime.bloodmagic.common.data.GeneratorBlockStates;
import wayoftime.bloodmagic.common.data.GeneratorBlockTags;
import wayoftime.bloodmagic.common.data.GeneratorFluidTags;
import wayoftime.bloodmagic.common.data.GeneratorItemModels;
import wayoftime.bloodmagic.common.data.GeneratorItemTags;
import wayoftime.bloodmagic.common.data.GeneratorLanguage;
import wayoftime.bloodmagic.common.data.GeneratorLootTable;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeProvider;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.loot.BloodMagicLootFunctionManager;
import wayoftime.bloodmagic.common.loot.BloodMagicLootTypeManager;
import wayoftime.bloodmagic.common.recipe.serializer.TestSpecialRecipe;
import wayoftime.bloodmagic.common.registries.BloodMagicEntityTypes;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.compat.CuriosCompat;
import wayoftime.bloodmagic.compat.patchouli.RegisterPatchouliMultiblocks;
import wayoftime.bloodmagic.core.AnointmentRegistrar;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.recipe.IngredientBloodOrb;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRegistry;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.impl.BloodMagicCorePlugin;
import wayoftime.bloodmagic.loot.GlobalLootModifier;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.ModRituals;
import wayoftime.bloodmagic.ritual.RitualManager;
import wayoftime.bloodmagic.structures.ModDungeons;
import wayoftime.bloodmagic.tile.TileAlchemicalReactionChamber;
import wayoftime.bloodmagic.tile.TileAlchemyArray;
import wayoftime.bloodmagic.tile.TileAlchemyTable;
import wayoftime.bloodmagic.tile.TileAltar;
import wayoftime.bloodmagic.tile.TileDeforesterCharge;
import wayoftime.bloodmagic.tile.TileDemonCrucible;
import wayoftime.bloodmagic.tile.TileDemonCrystal;
import wayoftime.bloodmagic.tile.TileDemonCrystallizer;
import wayoftime.bloodmagic.tile.TileDungeonController;
import wayoftime.bloodmagic.tile.TileDungeonSeal;
import wayoftime.bloodmagic.tile.TileFungalCharge;
import wayoftime.bloodmagic.tile.TileIncenseAltar;
import wayoftime.bloodmagic.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.tile.TileMimic;
import wayoftime.bloodmagic.tile.TileShapedExplosive;
import wayoftime.bloodmagic.tile.TileSoulForge;
import wayoftime.bloodmagic.tile.TileVeinMineCharge;
import wayoftime.bloodmagic.tile.routing.TileInputRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileMasterRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileOutputRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileRoutingNode;
import wayoftime.bloodmagic.util.handler.event.GenericHandler;
import wayoftime.bloodmagic.util.handler.event.WillHandler;

@Mod(value="bloodmagic")
public class BloodMagic {
    public static final String MODID = "bloodmagic";
    public static final Logger LOGGER = LogManager.getLogger();
    private static Gson GSON = null;
    public static final BloodMagicPacketHandler packetHandler = new BloodMagicPacketHandler();
    public static final RitualManager RITUAL_MANAGER = new RitualManager();
    public static Boolean curiosLoaded;
    public static final CuriosCompat curiosCompat;
    public static final ItemGroup TAB;
    public static final String NAME = "Blood Magic: Alchemical Wizardry";

    public BloodMagic() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::onLoadComplete);
        BloodMagicBlocks.BLOCKS.register(modBus);
        BloodMagicItems.ITEMS.register(modBus);
        BloodMagicItems.BLOOD_ORBS.createAndRegister(modBus, "bloodorbs");
        LivingArmorRegistrar.UPGRADES.createAndRegister(modBus, "upgrades");
        AnointmentRegistrar.ANOINTMENTS.createAndRegister(modBus, "anointments");
        BloodMagicItems.BASICITEMS.register(modBus);
        BloodMagicBlocks.BASICBLOCKS.register(modBus);
        BloodMagicBlocks.DUNGEONBLOCKS.register(modBus);
        BloodMagicBlocks.FLUIDS.register(modBus);
        BloodMagicBlocks.CONTAINERS.register(modBus);
        BloodMagicEntityTypes.ENTITY_TYPES.register(modBus);
        GlobalLootModifier.GLM.register(modBus);
        BloodMagicRecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        modBus.addListener(this::setup);
        modBus.addListener(this::enqueueIMC);
        modBus.addListener(this::processIMC);
        modBus.addListener(this::doClientStuff);
        modBus.addListener(this::loadModels);
        modBus.addListener(this::gatherData);
        modBus.addGenericListener(Fluid.class, this::registerFluids);
        modBus.addGenericListener(TileEntityType.class, this::registerTileEntityTypes);
        modBus.addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        modBus.addGenericListener(Effect.class, BloodMagicPotions::registerPotions);
        modBus.addListener(ConfigManager::onCommonReload);
        MinecraftForge.EVENT_BUS.register((Object)new GenericHandler());
        modBus.addListener(this::registerColors);
        MinecraftForge.EVENT_BUS.register((Object)new WillHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, ConfigManager.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, ConfigManager.COMMON_SPEC);
        BloodMagicLootFunctionManager.register();
        BloodMagicLootTypeManager.register();
        ModDungeons.init();
    }

    private void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)IngredientBloodOrb.NAME, IngredientBloodOrb.Serializer.INSTANCE);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new SpecialRecipeSerializer(TestSpecialRecipe::new).setRegistryName("test")});
    }

    public static ResourceLocation rl(String name) {
        return new ResourceLocation(MODID, name);
    }

    public void registerFluids(RegistryEvent.Register<Fluid> event) {
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_WEAK.get())).getTier(), (Object)new ItemStack((IItemProvider)BloodMagicItems.WEAK_BLOOD_ORB.get()));
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_APPRENTICE.get())).getTier(), (Object)new ItemStack((IItemProvider)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()));
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_MAGICIAN.get())).getTier(), (Object)new ItemStack((IItemProvider)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()));
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_MASTER.get())).getTier(), (Object)new ItemStack((IItemProvider)BloodMagicItems.MASTER_BLOOD_ORB.get()));
        BloodMagicCorePlugin.INSTANCE.register(BloodMagicAPI.INSTANCE);
        RITUAL_MANAGER.discover();
        ModRituals.initHarvestHandlers();
        LivingArmorRegistrar.register();
        AnointmentRegistrar.register();
        AlchemyArrayRegistry.registerBaseArrays();
        BloodMagic.handleConfigValues(BloodMagicAPI.INSTANCE);
        if (curiosLoaded.booleanValue()) {
            curiosCompat.registerInventory();
        }
        if (ModList.get().isLoaded("patchouli")) {
            new RegisterPatchouliMultiblocks();
        }
    }

    public static void handleConfigValues(BloodMagicAPI api) {
        for (String value : (List)ConfigManager.COMMON.sacrificialValues.get()) {
            String[] split = value.split(";");
            if (split.length != 2) continue;
            api.getValueManager().setSacrificialValue(new ResourceLocation(split[0]), Integer.parseInt(split[1]));
        }
        for (String value : (List)ConfigManager.COMMON.wellOfSuffering.get()) {
            api.getBlacklist().addWellOfSuffering(new ResourceLocation(value));
        }
    }

    public void registerTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        LOGGER.info("Attempting to register Tile Entities");
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileAltar::new, (Block[])new Block[]{(Block)BloodMagicBlocks.BLOOD_ALTAR.get()}).func_206865_a(null).setRegistryName("altar")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileAlchemyArray::new, (Block[])new Block[]{(Block)BloodMagicBlocks.ALCHEMY_ARRAY.get()}).func_206865_a(null).setRegistryName("alchemyarray")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileSoulForge::new, (Block[])new Block[]{(Block)BloodMagicBlocks.SOUL_FORGE.get()}).func_206865_a(null).setRegistryName("soulforge")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileMasterRitualStone::new, (Block[])new Block[]{(Block)BloodMagicBlocks.MASTER_RITUAL_STONE.get()}).func_206865_a(null).setRegistryName("masterritualstone")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileAlchemicalReactionChamber::new, (Block[])new Block[]{(Block)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()}).func_206865_a(null).setRegistryName("alchemicalreactionchamber")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileAlchemyTable::new, (Block[])new Block[]{(Block)BloodMagicBlocks.ALCHEMY_TABLE.get()}).func_206865_a(null).setRegistryName("alchemytable")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileDemonCrystal::new, (Block[])new Block[]{(Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get(), (Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get(), (Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get(), (Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get()}).func_206865_a(null).setRegistryName("demoncrystal")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileDemonCrucible::new, (Block[])new Block[]{(Block)BloodMagicBlocks.DEMON_CRUCIBLE.get()}).func_206865_a(null).setRegistryName("demoncrucible")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileDemonCrystallizer::new, (Block[])new Block[]{(Block)BloodMagicBlocks.DEMON_CRYSTALLIZER.get()}).func_206865_a(null).setRegistryName("demoncrystallizer")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileIncenseAltar::new, (Block[])new Block[]{(Block)BloodMagicBlocks.INCENSE_ALTAR.get()}).func_206865_a(null).setRegistryName("incensealtar")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileMimic::new, (Block[])new Block[]{(Block)BloodMagicBlocks.MIMIC.get(), (Block)BloodMagicBlocks.ETHEREAL_MIMIC.get()}).func_206865_a(null).setRegistryName("mimic")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileShapedExplosive::new, (Block[])new Block[]{(Block)BloodMagicBlocks.SHAPED_CHARGE.get()}).func_206865_a(null).setRegistryName("shaped_explosive")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileDeforesterCharge::new, (Block[])new Block[]{(Block)BloodMagicBlocks.DEFORESTER_CHARGE.get()}).func_206865_a(null).setRegistryName("deforester_charge")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileVeinMineCharge::new, (Block[])new Block[]{(Block)BloodMagicBlocks.VEINMINE_CHARGE.get()}).func_206865_a(null).setRegistryName("veinmine_charge")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFungalCharge::new, (Block[])new Block[]{(Block)BloodMagicBlocks.FUNGAL_CHARGE.get()}).func_206865_a(null).setRegistryName("fungal_charge")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileRoutingNode::new, (Block[])new Block[]{(Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get()}).func_206865_a(null).setRegistryName("itemroutingnode")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileInputRoutingNode::new, (Block[])new Block[]{(Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get()}).func_206865_a(null).setRegistryName("inputroutingnode")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileOutputRoutingNode::new, (Block[])new Block[]{(Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get()}).func_206865_a(null).setRegistryName("outputroutingnode")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileMasterRoutingNode::new, (Block[])new Block[]{(Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get()}).func_206865_a(null).setRegistryName("masterroutingnode")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileDungeonController::new, (Block[])new Block[]{(Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get()}).func_206865_a(null).setRegistryName("dungeon_controller")));
        event.getRegistry().register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileDungeonSeal::new, (Block[])new Block[]{(Block)BloodMagicBlocks.DUNGEON_SEAL.get()}).func_206865_a(null).setRegistryName("dungeon_seal")));
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        GeneratorItemModels itemModels = new GeneratorItemModels(gen, event.getExistingFileHelper());
        gen.func_200390_a((IDataProvider)itemModels);
        gen.func_200390_a((IDataProvider)new GeneratorBlockStates(gen, itemModels.existingFileHelper));
        gen.func_200390_a((IDataProvider)new GeneratorLanguage(gen));
        gen.func_200390_a((IDataProvider)new BloodMagicRecipeProvider(gen));
        gen.func_200390_a((IDataProvider)new GeneratorBaseRecipes(gen));
        gen.func_200390_a((IDataProvider)new GeneratorLootTable(gen));
        GeneratorBlockTags bmBlockTags = new GeneratorBlockTags(gen, event.getExistingFileHelper());
        gen.func_200390_a((IDataProvider)bmBlockTags);
        gen.func_200390_a((IDataProvider)new GeneratorItemTags(gen, bmBlockTags, event.getExistingFileHelper()));
        gen.func_200390_a((IDataProvider)new GeneratorFluidTags(gen, event.getExistingFileHelper()));
    }

    private void loadModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)BloodMagic.rl("mimicloader"), (IModelLoader)new MimicModelLoader(BloodMagic.rl("block/solidopaquemimic")));
        ModelLoaderRegistry.registerLoader((ResourceLocation)BloodMagic.rl("mimicloader_ethereal"), (IModelLoader)new MimicModelLoader(BloodMagic.rl("block/etherealopaquemimic")));
    }

    private void setup(FMLCommonSetupEvent event) {
        packetHandler.initialize();
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientEvents.initClientEvents(event);
        Elements.registerElements();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        KeyBindings.initializeKeys();
        new BloodMagicKeyHandler();
    }

    private void registerColors(ColorHandlerEvent event) {
        if (event instanceof ColorHandlerEvent.Item) {
            ClientEvents.colorHandlerEvent((ColorHandlerEvent.Item)event);
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (curiosLoaded.booleanValue()) {
            curiosCompat.setupSlots(event);
        }
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    static {
        curiosCompat = new CuriosCompat();
        TAB = new ItemGroup("bloodmagictab"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)BloodMagicBlocks.BLOOD_ALTAR.get());
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

