/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.anointment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentData;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class AnointmentHolder {
    private final Map<Anointment, AnointmentData> anointments;

    public AnointmentHolder(Map<Anointment, AnointmentData> anointments) {
        this.anointments = anointments;
    }

    public AnointmentHolder() {
        this(Maps.newHashMap());
    }

    public boolean isEmpty() {
        return this.anointments.isEmpty();
    }

    public boolean applyAnointment(ItemStack stack, Anointment anointment, AnointmentData data) {
        if (this.canApplyAnointment(stack, anointment, data)) {
            this.anointments.put(anointment, data);
            anointment.applyAnointment(this, stack, data.getLevel());
            return true;
        }
        return false;
    }

    public boolean canApplyAnointment(ItemStack stack, Anointment anointment, AnointmentData data) {
        ResourceLocation key = anointment.getKey();
        for (Anointment containedAnoint : this.anointments.keySet()) {
            ResourceLocation containedKey = containedAnoint.getKey();
            if (anointment.isCompatible(containedKey) && containedAnoint.isCompatible(key)) continue;
            return false;
        }
        if (this.anointments.containsKey((Object)anointment)) {
            AnointmentData prevData = this.anointments.get((Object)anointment);
            int level = prevData.getLevel();
            int remainingDur = prevData.getMaxDamage() - prevData.getDamage();
            return level < data.getLevel() || level == data.getLevel() && remainingDur < data.getMaxDamage() - data.getDamage();
        }
        return true;
    }

    public int getAnointmentLevel(Anointment anointment) {
        if (this.anointments.containsKey((Object)anointment)) {
            return this.anointments.get((Object)anointment).getLevel();
        }
        return 0;
    }

    public boolean consumeAnointmentDurabilityOnHit(ItemStack weaponStack, EquipmentSlotType type) {
        boolean didConsume = false;
        ArrayList<Anointment> removedAnointments = new ArrayList<Anointment>();
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment annointment = entry.getKey();
            if (!annointment.consumeOnAttack()) continue;
            AnointmentData data = entry.getValue();
            data.damage(1);
            didConsume = true;
            if (!data.isMaxDamage()) continue;
            removedAnointments.add(annointment);
        }
        for (Anointment anointment : removedAnointments) {
            this.removeAnointment(weaponStack, type, anointment);
        }
        return didConsume;
    }

    public boolean consumeAnointmentDurabilityOnUseFinish(ItemStack weaponStack, EquipmentSlotType type) {
        boolean didConsume = false;
        ArrayList<Anointment> removedAnointments = new ArrayList<Anointment>();
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment annointment = entry.getKey();
            if (!annointment.consumeOnUseFinish()) continue;
            AnointmentData data = entry.getValue();
            data.damage(1);
            didConsume = true;
            if (!data.isMaxDamage()) continue;
            removedAnointments.add(annointment);
        }
        for (Anointment anointment : removedAnointments) {
            this.removeAnointment(weaponStack, type, anointment);
        }
        return didConsume;
    }

    public boolean consumeAnointmentDurabilityOnHarvest(ItemStack weaponStack, EquipmentSlotType type) {
        boolean didConsume = false;
        ArrayList<Anointment> removedAnointments = new ArrayList<Anointment>();
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment annointment = entry.getKey();
            if (!annointment.consumeOnHarvest()) continue;
            AnointmentData data = entry.getValue();
            data.damage(1);
            didConsume = true;
            if (!data.isMaxDamage()) continue;
            removedAnointments.add(annointment);
        }
        for (Anointment anointment : removedAnointments) {
            this.removeAnointment(weaponStack, type, anointment);
        }
        return didConsume;
    }

    public boolean removeAnointment(ItemStack weaponStack, EquipmentSlotType type, Anointment anointment) {
        this.anointments.remove((Object)anointment);
        anointment.removeAnointment(this, weaponStack, type);
        return true;
    }

    public Map<Anointment, AnointmentData> getAnointments() {
        return ImmutableMap.copyOf(this.anointments);
    }

    public double getAdditionalDamage(PlayerEntity player, ItemStack weapon, double damage, LivingEntity attacked) {
        double additionalDamage = 0.0;
        for (Map.Entry<Anointment, AnointmentData> entry : this.anointments.entrySet()) {
            Anointment.IDamageProvider prov = entry.getKey().getDamageProvider();
            if (prov == null) continue;
            additionalDamage += prov.getAdditionalDamage(player, weapon, damage, this, attacked, entry.getKey(), entry.getValue().getLevel());
        }
        return additionalDamage;
    }

    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT statList = new ListNBT();
        this.anointments.forEach((k, v) -> {
            CompoundNBT anoint = new CompoundNBT();
            anoint.func_74778_a("key", k.getKey().toString());
            anoint.func_74768_a("level", v.getLevel());
            anoint.func_74768_a("damage", v.getDamage());
            anoint.func_74768_a("max_damage", v.getMaxDamage());
            statList.add((Object)anoint);
        });
        compound.func_218657_a("anointments", (INBT)statList);
        return compound;
    }

    public void deserialize(CompoundNBT nbt) {
        ListNBT statList = nbt.func_150295_c("anointments", 10);
        statList.forEach(tag -> {
            if (!(tag instanceof CompoundNBT)) {
                return;
            }
            Anointment anoint = AnointmentRegistrar.ANOINTMENT_MAP.getOrDefault(new ResourceLocation(((CompoundNBT)tag).func_74779_i("key")), Anointment.DUMMY);
            if (anoint == Anointment.DUMMY) {
                return;
            }
            AnointmentData data = new AnointmentData(((CompoundNBT)tag).func_74762_e("level"), ((CompoundNBT)tag).func_74762_e("damage"), ((CompoundNBT)tag).func_74762_e("max_damage"));
            this.anointments.put(anoint, data);
        });
    }

    public static AnointmentHolder fromNBT(CompoundNBT holderTag) {
        AnointmentHolder holder = new AnointmentHolder();
        holder.deserialize(holderTag);
        return holder;
    }

    public static AnointmentHolder fromItemStack(ItemStack stack) {
        CompoundNBT nbtTag = stack.func_77978_p();
        if (nbtTag == null) {
            return null;
        }
        CompoundNBT holderTag = nbtTag.func_74775_l("anointment_holder");
        if (holderTag != null) {
            return AnointmentHolder.fromNBT(holderTag);
        }
        return null;
    }

    public void toItemStack(ItemStack stack) {
        CompoundNBT nbtTag = stack.func_196082_o();
        CompoundNBT childTag = this.serialize();
        nbtTag.func_218657_a("anointment_holder", (INBT)childTag);
    }

    public static AnointmentHolder fromPlayer(PlayerEntity player, Hand hand) {
        return AnointmentHolder.fromPlayer(player, hand, false);
    }

    public static AnointmentHolder fromPlayer(PlayerEntity player, Hand hand, boolean createNew) {
        ItemStack heldItem = player.func_184586_b(hand);
        AnointmentHolder holder = AnointmentHolder.fromItemStack(heldItem);
        return holder == null && createNew ? new AnointmentHolder() : holder;
    }

    public static void toPlayer(PlayerEntity player, Hand hand, AnointmentHolder holder) {
        ItemStack heldItem = player.func_184586_b(hand);
        holder.toItemStack(heldItem);
    }

    public static void appendAnointmentTooltip(AnointmentHolder holder, List<ITextComponent> tooltip) {
        if (holder != null) {
            holder.getAnointments().forEach((k, v) -> {
                boolean sneaking = Screen.func_231173_s_();
                if (!sneaking) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent(k.getTranslationKey()), new TranslationTextComponent("enchantment.level." + v.getLevel())}));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent(k.getTranslationKey()), ": (" + v.getDamageString() + ")"}));
                }
            });
        }
    }
}

