/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.util.helper.RitualHelper;

public class BlockMasterRitualStone
extends Block {
    public final boolean isInverted;

    public BlockMasterRitualStone(boolean isInverted) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2));
        this.isInverted = isInverted;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone && heldItem.func_77973_b() instanceof ItemActivationCrystal) {
            if (((IBindable)heldItem.func_77973_b()).getBinding(heldItem) == null) {
                return ActionResultType.FAIL;
            }
            String key = RitualHelper.getValidRitual(world, pos);
            if (!key.isEmpty()) {
                Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(key);
                if (ritual != null) {
                    Direction direction = RitualHelper.getDirectionOfRitual(world, pos, ritual);
                    if (direction != null && RitualHelper.checkValidRitual(world, pos, ritual, direction)) {
                        if (((TileMasterRitualStone)tile).activateRitual(heldItem, player, BloodMagic.RITUAL_MANAGER.getRitual(key))) {
                            ((TileMasterRitualStone)tile).setDirection(direction);
                            if (this.isInverted) {
                                ((TileMasterRitualStone)tile).setInverted(true);
                            }
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.notvalid"), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.notvalid"), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.notvalid"), true);
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        TileMasterRitualStone tile = (TileMasterRitualStone)world.func_175625_s(blockPos);
        if (tile != null) {
            tile.stopRitual(Ritual.BreakType.BREAK_MRS);
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileMasterRitualStone) {
                ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.BREAK_MRS);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.EXPLOSION);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileMasterRitualStone();
    }
}

