/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.loot.BMTableLootEntry;
import wayoftime.bloodmagic.common.loot.SetLivingUpgrade;
import wayoftime.bloodmagic.common.loot.SetWillFraction;
import wayoftime.bloodmagic.common.loot.SetWillRange;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingUpgrade;

public class GeneratorLootTable
extends LootTableProvider {
    public GeneratorLootTable(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BMBlocks(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new BMLootTables(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class BMLootTables
    extends ChestLootTables {
        private BMLootTables() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> acceptor) {
            this.generateSimpleDungeonLoot(acceptor);
        }

        private void generateSimpleDungeonLoot(BiConsumer<ResourceLocation, LootTable.Builder> acceptor) {
            LootPool.Builder vanillaDungeon = LootPool.func_216096_a().name("vanilla_dungeon").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)BMTableLootEntry.builder(LootTables.field_186422_d).func_216086_a(1));
            LootPool.Builder key_pool = LootPool.func_216096_a().name("vanilla_dungeon").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.DUNGEON_SIMPLE_KEY.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/entrance_chest"), LootTable.func_216119_b().func_216040_a(key_pool).func_216040_a(vanillaDungeon));
            Item[] baseAnointments = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), (Item)BloodMagicItems.FORTUNE_ANOINTMENT.get(), (Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), (Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT.get()};
            Item[] weaponAnointments = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT.get(), (Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT.get()};
            LootPool.Builder stronghold_library_pool = LootPool.func_216096_a().name("vanilla_library").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)BMTableLootEntry.builder(LootTables.field_186426_h).func_216086_a(1));
            LootPool.Builder extraLibraryItems = LootPool.func_216096_a().name("extra").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)3.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.WEAK_TAU_ITEM.get())).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))));
            extraLibraryItems.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.MONSTER_SOUL_RAW.get())).func_216086_a(10).func_212841_b_(SetWillRange.withRange(RandomValueRange.func_215837_a((float)15.0f, (float)30.0f))));
            extraLibraryItems.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.LIVING_TOME.get())).func_216086_a(5).func_212841_b_(SetLivingUpgrade.withRange(RandomValueRange.func_215837_a((float)200.0f, (float)400.0f), ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get())).getKey())));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/library"), LootTable.func_216119_b().func_216040_a(stronghold_library_pool).func_216040_a(extraLibraryItems));
            LootPool.Builder potionChest = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)7.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_216086_a(40).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151065_br).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)7.0f, (float)10.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151065_br).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151068_bn).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), nbt -> nbt.func_74778_a("Potion", "minecraft:water")))))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151123_aH).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)15.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151064_bs).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)6.0f, (float)10.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151016_H).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)6.0f, (float)10.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)20.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151114_aO).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)20.0f, (float)30.0f))));
            potionChest = this.addMultipleItemsWithSameParams(potionChest, baseAnointments, 1, (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f), new ILootFunction.IBuilder[0]);
            LootPool.Builder armory_pool = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)7.0f));
            armory_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(25).func_216085_b(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)7.0f, (float)15.0f))));
            armory_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_216086_a(20).func_216085_b(-4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)30.0f, (float)50.0f))));
            armory_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151045_i).func_216086_a(4).func_216085_b(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))));
            armory_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_216086_a(18).func_216085_b(-4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)20.0f))));
            armory_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_216086_a(8).func_216085_b(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.field_151021_T, Items.field_151027_R, Items.field_151024_Q, Items.field_151026_S}, 4, -3, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)15.0f, (float)25.0f)).func_216059_e(), SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f))});
            this.addMultipleItemsWithSameParams(armory_pool, new Item[]{Items.field_151021_T, Items.field_151027_R, Items.field_151024_Q, Items.field_151026_S}, 7, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.8f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(armory_pool, new Item[]{Items.field_151167_ab, Items.field_151030_Z, Items.field_151028_Y, Items.field_151165_aa}, 6, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.2f, (float)0.5f))});
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.field_151167_ab, Items.field_151030_Z, Items.field_151165_aa, Items.field_151028_Y}, 4, -2, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)20.0f)).func_216059_e(), SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.9f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(armory_pool, new Item[]{Items.field_151175_af, Items.field_151163_ad, Items.field_151161_ac, Items.field_151173_ae}, 2, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.1f, (float)0.2f))});
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.field_151175_af, Items.field_151163_ad, Items.field_151161_ac, Items.field_151173_ae}, 1, 2, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)20.0f, (float)25.0f)).func_216059_e(), SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.4f, (float)1.0f))});
            LootPool.Builder vanilla_blacksmith_pool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(BMTableLootEntry.builder(LootTables.field_215814_e));
            LootPool.Builder blacksmith_pool = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f));
            blacksmith_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.WEAK_TAU_ITEM.get())).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(blacksmith_pool, weaponAnointments, 3, (IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f), new ILootFunction.IBuilder[0]);
            blacksmith_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(25).func_216085_b(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)7.0f, (float)15.0f))));
            blacksmith_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_216086_a(20).func_216085_b(-4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)20.0f, (float)40.0f))));
            blacksmith_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151045_i).func_216086_a(4).func_216085_b(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))));
            blacksmith_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_216086_a(18).func_216085_b(-4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)20.0f))));
            blacksmith_pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_216086_a(8).func_216085_b(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(blacksmith_pool, new Item[]{Items.field_151035_b, Items.field_151036_c, Items.field_151040_l, Items.field_151037_a, Items.field_151019_K}, 6, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.4f, (float)7.0f))});
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.field_151035_b, Items.field_151036_c, Items.field_151040_l, Items.field_151037_a, Items.field_151019_K}, 4, -2, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)20.0f)).func_216059_e(), SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.9f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(blacksmith_pool, new Item[]{Items.field_151046_w, Items.field_151056_x, Items.field_151048_u, Items.field_151047_v, Items.field_151012_L}, 2, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.1f, (float)0.2f))});
            this.addMultipleItemsWithQualitySameParams(blacksmith_pool, new Item[]{Items.field_151046_w, Items.field_151056_x, Items.field_151048_u, Items.field_151047_v, Items.field_151012_L}, 1, 2, (IRandomRange)ConstantRange.func_215835_a((int)1), new ILootFunction.IBuilder[]{EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)20.0f, (float)25.0f)).func_216059_e(), SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.4f, (float)0.8f))});
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/potion_ingredients"), LootTable.func_216119_b().func_216040_a(potionChest).func_216040_a(this.addMultipleItemsWithSameParams(LootPool.func_216096_a(), baseAnointments, 1, (IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f), new ILootFunction.IBuilder[0])));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/simple_armoury"), LootTable.func_216119_b().func_216040_a(armory_pool));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/simple_blacksmith"), LootTable.func_216119_b().func_216040_a(blacksmith_pool).func_216040_a(vanilla_blacksmith_pool));
            LootPool.Builder tartaricGemPool = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.PETTY_GEM.get())).func_216086_a(5).func_212841_b_(SetWillFraction.withRange(RandomValueRange.func_215837_a((float)0.5f, (float)0.7f))));
            LootPool.Builder tartaricSoulPool = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.MONSTER_SOUL_RAW.get())).func_216086_a(5).func_212841_b_(SetWillRange.withRange(RandomValueRange.func_215837_a((float)20.0f, (float)50.0f))));
            LootPool.Builder upgradePool = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)BloodMagicItems.LIVING_TOME.get())).func_216086_a(3).func_212841_b_(SetLivingUpgrade.withRange(RandomValueRange.func_215837_a((float)300.0f, (float)600.0f), ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_HEALTH.get())).getKey())));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/test_gems"), LootTable.func_216119_b().func_216040_a(tartaricGemPool).func_216040_a(tartaricSoulPool).func_216040_a(upgradePool));
        }

        private LootPool.Builder addMultipleItemsWithSameParams(LootPool.Builder pool, Item[] items, int basicWeight, IRandomRange basicRange, ILootFunction.IBuilder ... functions) {
            return this.addMultipleItemsWithQualitySameParams(pool, items, basicWeight, 0, basicRange, functions);
        }

        private LootPool.Builder addMultipleItemsWithQualitySameParams(LootPool.Builder pool, Item[] items, int basicWeight, int quality, IRandomRange basicRange, ILootFunction.IBuilder ... functions) {
            if (basicWeight > 0) {
                for (Item item : items) {
                    StandaloneLootEntry.Builder entryBuilder = ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(basicWeight).func_216085_b(quality).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)basicRange));
                    for (ILootFunction.IBuilder function : functions) {
                        entryBuilder = entryBuilder.func_212841_b_(function);
                    }
                    pool = pool.func_216045_a((LootEntry.Builder)entryBuilder);
                }
            }
            return pool;
        }
    }

    private static class BMBlocks
    extends BlockLootTables {
        private BMBlocks() {
        }

        protected void addTables() {
            for (RegistryObject block : BloodMagicBlocks.BASICBLOCKS.getEntries()) {
                this.func_218492_c((Block)block.get());
            }
            for (RegistryObject block : BloodMagicBlocks.DUNGEONBLOCKS.getEntries()) {
                this.func_218492_c((Block)block.get());
            }
            this.func_218492_c((Block)BloodMagicBlocks.BLOOD_ALTAR.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.ALCHEMY_ARRAY.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.BLOOD_LIGHT.get());
            this.func_218492_c((Block)BloodMagicBlocks.SOUL_FORGE.get());
            this.func_218492_c((Block)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218493_a((Block)BloodMagicBlocks.AIR_RITUAL_STONE.get(), (IItemProvider)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218493_a((Block)BloodMagicBlocks.WATER_RITUAL_STONE.get(), (IItemProvider)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218493_a((Block)BloodMagicBlocks.FIRE_RITUAL_STONE.get(), (IItemProvider)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218493_a((Block)BloodMagicBlocks.EARTH_RITUAL_STONE.get(), (IItemProvider)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218493_a((Block)BloodMagicBlocks.DUSK_RITUAL_STONE.get(), (IItemProvider)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218493_a((Block)BloodMagicBlocks.DAWN_RITUAL_STONE.get(), (IItemProvider)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.func_218492_c((Block)BloodMagicBlocks.ALCHEMY_TABLE.get());
            this.func_218492_c((Block)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get());
            this.func_218492_c((Block)BloodMagicBlocks.DEMON_CRUCIBLE.get());
            this.func_218492_c((Block)BloodMagicBlocks.DEMON_CRYSTALLIZER.get());
            this.func_218492_c((Block)BloodMagicBlocks.INCENSE_ALTAR.get());
            this.func_218493_a((Block)BloodMagicBlocks.NETHER_SOIL.get(), (IItemProvider)Blocks.field_150424_aL);
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.CORROSIVE_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get());
            this.func_218492_c((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get());
            this.func_218492_c((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get());
            this.func_218492_c((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get());
            this.func_218492_c((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_STONE.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_POLISHED_STAIRS.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_PILLAR_CENTER.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_PILLAR_SPECIAL.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_PILLAR_CAP.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_BRICK_WALL.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_POLISHED_WALL.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_BRICK_GATE.get());
            this.func_218492_c((Block)BloodMagicBlocks.DUNGEON_POLISHED_GATE.get());
            this.func_218522_a((Block)BloodMagicBlocks.DUNGEON_BRICK_SLAB.get(), x$0 -> BlockLootTables.func_218513_d((Block)x$0));
            this.func_218522_a((Block)BloodMagicBlocks.DUNGEON_TILE_SLAB.get(), x$0 -> BlockLootTables.func_218513_d((Block)x$0));
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DUNGEON_SEAL.get());
            this.func_218492_c((Block)BloodMagicBlocks.MIMIC.get());
            this.func_218492_c((Block)BloodMagicBlocks.ETHEREAL_MIMIC.get());
            this.registerCropDropLootTable((Block)BloodMagicBlocks.GROWING_DOUBT.get(), (Item)BloodMagicItems.GROWING_DOUBT_ITEM.get());
            this.registerCropDropLootTable((Block)BloodMagicBlocks.WEAK_TAU.get(), (Item)BloodMagicItems.WEAK_TAU_ITEM.get());
            this.registerCropDropLootTableWithImmatureSeed((Block)BloodMagicBlocks.STRONG_TAU.get(), (Item)BloodMagicItems.WEAK_TAU_ITEM.get(), (Item)BloodMagicItems.STRONG_TAU_ITEM.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.SHAPED_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DEFORESTER_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.VEINMINE_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.FUNGAL_CHARGE.get());
            this.func_218492_c((Block)BloodMagicBlocks.INVERSION_PILLAR.get());
        }

        private void registerNoDropLootTable(Block block) {
            LootPool.Builder builder = LootPool.func_216096_a().name(block.getRegistryName().toString());
            this.func_218507_a(block, LootTable.func_216119_b().func_216040_a(builder));
        }

        private void registerCropDropLootTable(Block block, Item item) {
            LootTable.Builder builder = LootTable.func_216119_b();
            BlockStateProperty.Builder ageLootCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)CropsBlock.field_176488_a, 7));
            builder = builder.func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)ageLootCondition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3))));
            this.func_218507_a(block, builder);
        }

        private void registerCropDropLootTableWithImmatureSeed(Block block, Item seed, Item fruit) {
            LootTable.Builder builder = LootTable.func_216119_b();
            BlockStateProperty.Builder ageLootCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)CropsBlock.field_176488_a, 7));
            builder = builder.func_216040_a(LootPool.func_216096_a().func_212840_b_(ageLootCondition.func_216298_a()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seed))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)ageLootCondition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)fruit))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)ageLootCondition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)fruit).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3))));
            this.func_218507_a(block, builder);
        }

        private void registerDropCrystalsLootTable(Block block, Item item) {
            LootTable.Builder builder = LootTable.func_216119_b();
            for (int i = 0; i < 7; ++i) {
                BlockStateProperty.Builder harvestAge = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)BlockDemonCrystal.AGE, i));
                builder = builder.func_216040_a(LootPool.func_216096_a().func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)(i + 1)))).func_212840_b_((ILootCondition.IBuilder)harvestAge)));
            }
            this.func_218507_a(block, builder);
        }

        protected static <T extends Comparable<T> & IStringSerializable> LootTable.Builder droppingWhen(Block block, Property<T> property, T value) {
            return LootTable.func_216119_b().func_216040_a((LootPool.Builder)BMBlocks.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(property, value))))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("bloodmagic")).collect(Collectors.toList());
        }
    }
}

