/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemExperienceBook
extends Item {
    public ItemExperienceBook() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.experienceTome").func_240699_a_(TextFormatting.GRAY));
        if (!stack.func_77942_o()) {
            return;
        }
        double storedExp = ItemExperienceBook.getStoredExperience(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.experienceTome.exp", new Object[]{(int)storedExp}).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.experienceTome.expLevel", new Object[]{ItemExperienceBook.getLevelForExperience(storedExp)}).func_240699_a_(TextFormatting.GRAY));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.absorbOneLevelExpFromPlayer(stack, player);
            } else {
                this.giveOneLevelExpToPlayer(stack, player);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void giveOneLevelExpToPlayer(ItemStack stack, PlayerEntity player) {
        float progress = player.field_71106_cc;
        int expToNext = ItemExperienceBook.getExperienceForNextLevel(player.field_71068_ca);
        int neededExp = (int)Math.ceil((1.0f - progress) * (float)expToNext);
        float containedExp = (float)ItemExperienceBook.getStoredExperience(stack);
        BMLog.DEBUG.info("Needed: " + neededExp + ", contained: " + containedExp + ", exp to next: " + expToNext, new Object[0]);
        if (containedExp >= (float)neededExp) {
            ItemExperienceBook.setStoredExperience(stack, containedExp - (float)neededExp);
            ItemExperienceBook.addPlayerXP(player, neededExp);
            if (player.field_71068_ca % 5 == 0) {
                float f = player.field_71068_ca > 30 ? 1.0f : (float)player.field_71068_ca / 30.0f;
                player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187802_ec, player.func_184176_by(), f * 0.75f, 1.0f);
            }
        } else {
            ItemExperienceBook.setStoredExperience(stack, 0.0);
            ItemExperienceBook.addPlayerXP(player, (int)containedExp);
        }
    }

    public void absorbOneLevelExpFromPlayer(ItemStack stack, PlayerEntity player) {
        float progress = player.field_71106_cc;
        if (progress > 0.0f) {
            int expDeduction = (int)ItemExperienceBook.getExperienceAcquiredToNext(player);
            if (expDeduction > 0) {
                ItemExperienceBook.addPlayerXP(player, -expDeduction);
                ItemExperienceBook.addExperience(stack, expDeduction);
            }
        } else if (progress == 0.0f && player.field_71068_ca > 0) {
            int expDeduction = ItemExperienceBook.getExperienceForNextLevel(player.field_71068_ca - 1);
            ItemExperienceBook.addPlayerXP(player, -expDeduction);
            ItemExperienceBook.addExperience(stack, expDeduction);
        }
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)ItemExperienceBook.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, ItemExperienceBook.getPlayerXP(player) + amount);
        player.field_71068_ca = ItemExperienceBook.getLevelForExperience(experience);
        int expForLevel = ItemExperienceBook.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static void setStoredExperience(ItemStack stack, double exp) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("experience", exp);
    }

    public static double getStoredExperience(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("experience");
    }

    public static void addExperience(ItemStack stack, double exp) {
        ItemExperienceBook.setStoredExperience(stack, ItemExperienceBook.getStoredExperience(stack) + exp);
    }

    public static int getExperienceForNextLevel(int currentLevel) {
        if (currentLevel < 16) {
            return 2 * currentLevel + 7;
        }
        if (currentLevel < 31) {
            return 5 * currentLevel - 38;
        }
        return 9 * currentLevel - 158;
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        if (level == 0) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < level; ++i) {
            res += ItemExperienceBook.getExperienceForNextLevel(i);
        }
        return res;
    }

    public static double getExperienceAcquiredToNext(PlayerEntity player) {
        return player.field_71106_cc * (float)player.func_71050_bK();
    }

    public static int getLevelForExperience(double exp) {
        if (exp <= 352.0) {
            return (int)Math.floor(ItemExperienceBook.solveParabola(1.0, 6.0, -exp));
        }
        if (exp <= 1507.0) {
            return (int)Math.floor(ItemExperienceBook.solveParabola(2.5, -40.5, 360.0 - exp));
        }
        return (int)Math.floor(ItemExperienceBook.solveParabola(4.5, -162.5, 2220.0 - exp));
    }

    public static double solveParabola(double a, double b, double c) {
        return (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
    }
}

