/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemInventory
implements IInventory {
    protected int[] syncedSlots = new int[0];
    protected ItemStack masterStack;
    private NonNullList<ItemStack> inventory;
    private int size;
    private String name;

    public ItemInventory(ItemStack masterStack, int size, String name) {
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.size = size;
        this.name = name;
        this.masterStack = masterStack;
        if (!masterStack.func_190926_b()) {
            this.readFromStack(masterStack);
        }
    }

    public void initializeInventory(ItemStack masterStack) {
        this.masterStack = masterStack;
        this.func_174888_l();
        this.readFromStack(masterStack);
    }

    private boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tagCompound, this.inventory);
    }

    public void writeToNBT(CompoundNBT tagCompound) {
        ItemStackHelper.func_191282_a((CompoundNBT)tagCompound, this.inventory);
    }

    public void readFromStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            CompoundNBT tag = masterStack.func_77978_p();
            this.readFromNBT(tag.func_74775_l("itemInventory" + this.name));
        }
    }

    public void writeToStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            CompoundNBT tag = masterStack.func_77978_p();
            CompoundNBT invTag = new CompoundNBT();
            this.writeToNBT(invTag);
            tag.func_218657_a("itemInventory" + this.name, (INBT)invTag);
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(index)).func_190916_E() <= count) {
                ItemStack itemStack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = ((ItemStack)this.inventory.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventory.get(index)).func_190926_b()) {
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            ItemStack itemStack = (ItemStack)this.inventory.get(slot);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public void func_70296_d() {
        if (this.masterStack != null) {
            this.writeToStack(this.masterStack);
        }
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean canInventoryBeManipulated() {
        return this.masterStack != null;
    }
}

