/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.routing;

import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.Utils;

public class BlacklistItemFilter
implements IItemFilter {
    protected List<IFilterKey> requestList;
    protected TileEntity accessedTile;
    protected IItemHandler itemHandler;

    @Override
    public void initializeFilter(List<IFilterKey> filteredList, TileEntity tile, IItemHandler itemHandler, boolean isFilterOutput) {
        this.accessedTile = tile;
        this.itemHandler = itemHandler;
        if (isFilterOutput) {
            this.requestList = filteredList;
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack checkedStack = itemHandler.getStackInSlot(slot);
                if (checkedStack.func_190926_b()) continue;
                int stackSize = checkedStack.func_190916_E();
                for (IFilterKey filterStack : this.requestList) {
                    if (filterStack.getCount() == 0 || !this.doStacksMatch(filterStack, checkedStack)) continue;
                    filterStack.setCount(Math.max(filterStack.getCount() - stackSize, 0));
                }
            }
        } else {
            this.requestList = filteredList;
            for (IFilterKey filterStack : this.requestList) {
                filterStack.setCount(filterStack.getCount() * -1);
            }
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack checkedStack = itemHandler.getStackInSlot(slot);
                if (checkedStack.func_190926_b()) continue;
                int stackSize = checkedStack.func_190916_E();
                for (IFilterKey filterStack : filteredList) {
                    if (!this.doStacksMatch(filterStack, checkedStack)) continue;
                    filterStack.grow(stackSize);
                }
            }
        }
    }

    @Override
    public ItemStack transferStackThroughOutputFilter(ItemStack inputStack) {
        int allowedAmount = inputStack.func_190916_E();
        for (IFilterKey filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, inputStack)) continue;
            return inputStack;
        }
        if (allowedAmount <= 0) {
            return inputStack;
        }
        ItemStack testStack = inputStack.func_77946_l();
        testStack.func_190920_e(allowedAmount);
        ItemStack remainderStack = Utils.insertStackIntoTile(testStack, this.itemHandler);
        int changeAmount = allowedAmount - (remainderStack.func_190926_b() ? 0 : remainderStack.func_190916_E());
        testStack = inputStack.func_77946_l();
        testStack.func_190918_g(changeAmount);
        Iterator<IFilterKey> itr = this.requestList.iterator();
        while (itr.hasNext()) {
            IFilterKey filterStack = itr.next();
            if (this.doStacksMatch(filterStack, inputStack)) continue;
            filterStack.shrink(changeAmount);
            if (!filterStack.isEmpty()) continue;
            itr.remove();
        }
        World world = this.accessedTile.func_145831_w();
        BlockPos pos = this.accessedTile.func_174877_v();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        return testStack;
    }

    @Override
    public int transferThroughInputFilter(IItemFilter outputFilter, int maxTransfer) {
        int totalChange = 0;
        block0: for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            ItemStack inputStack = this.itemHandler.getStackInSlot(slot);
            if (inputStack.func_190926_b() || this.itemHandler.extractItem(slot, inputStack.func_190916_E(), true).func_190926_b()) continue;
            int allowedAmount = Math.min(inputStack.func_190916_E(), maxTransfer);
            for (IFilterKey filterStack : this.requestList) {
                if (!this.doStacksMatch(filterStack, inputStack)) continue;
                continue block0;
            }
            if (allowedAmount <= 0) continue;
            ItemStack testStack = inputStack.func_77946_l();
            testStack.func_190920_e(allowedAmount);
            ItemStack remainderStack = outputFilter.transferStackThroughOutputFilter(testStack);
            int changeAmount = allowedAmount - (remainderStack.func_190926_b() ? 0 : remainderStack.func_190916_E());
            if (!remainderStack.func_190926_b() && remainderStack.func_190916_E() == allowedAmount) continue;
            this.itemHandler.extractItem(slot, changeAmount, false);
            for (IFilterKey filterStack : this.requestList) {
                if (this.doStacksMatch(filterStack, inputStack)) continue;
                filterStack.shrink(changeAmount);
            }
            World world = this.accessedTile.func_145831_w();
            BlockPos pos = this.accessedTile.func_174877_v();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            totalChange += changeAmount;
            if ((maxTransfer -= changeAmount) > 0) continue;
            return totalChange;
        }
        return totalChange;
    }

    @Override
    public boolean doesStackMatchFilter(ItemStack testStack) {
        for (IFilterKey filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, testStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doStacksMatch(IFilterKey filterStack, ItemStack testStack) {
        return filterStack.doesStackMatch(testStack);
    }
}

