/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.registration.impl.LivingUpgradeDeferredRegister;
import wayoftime.bloodmagic.common.registration.impl.LivingUpgradeRegistryObject;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.gson.Serializers;

public class LivingArmorRegistrar {
    public static final LivingUpgradeDeferredRegister UPGRADES = new LivingUpgradeDeferredRegister("bloodmagic");
    public static final Map<ResourceLocation, LivingUpgrade> UPGRADE_MAP = new HashMap<ResourceLocation, LivingUpgrade>();
    private static final Map<String, ResourceLocation> DEFINITIONS = ((Supplier<Map>)() -> {
        HashMap<String, ResourceLocation> def = new HashMap<String, ResourceLocation>();
        def.put("arrow_protect", BloodMagic.rl("arrow_protect"));
        def.put("arrow_shot", BloodMagic.rl("arrow_shot"));
        def.put("critical_strike", BloodMagic.rl("critical_strike"));
        def.put("digging", BloodMagic.rl("digging"));
        def.put("experienced", BloodMagic.rl("experienced"));
        def.put("fall_protect", BloodMagic.rl("fall_protect"));
        def.put("fire_resist", BloodMagic.rl("fire_resist"));
        def.put("grave_digger", BloodMagic.rl("grave_digger"));
        def.put("health", BloodMagic.rl("health"));
        def.put("jump", BloodMagic.rl("jump"));
        def.put("knockback_resist", BloodMagic.rl("knockback_resist"));
        def.put("melee_damage", BloodMagic.rl("melee_damage"));
        def.put("physical_protect", BloodMagic.rl("physical_protect"));
        def.put("poison_resist", BloodMagic.rl("poison_resist"));
        def.put("sprint_attack", BloodMagic.rl("sprint_attack"));
        def.put("speed", BloodMagic.rl("speed"));
        def.put("self_sacrifice", BloodMagic.rl("self_sacrifice"));
        def.put("downgrade/quenched", BloodMagic.rl("downgrade/quenched"));
        return def;
    }).get();
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_ARROW_PROTECT = UPGRADES.register("arrow_protect", () -> LivingArmorRegistrar.parseDefinition("arrow_protect").withArmorProvider((player, stats, source, upgrade, level) -> {
        if (source.func_76352_a()) {
            return upgrade.getBonusValue("protection", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_FALL_PROTECT = UPGRADES.register("fall_protect", () -> LivingArmorRegistrar.parseDefinition("fall_protect").withArmorProvider((player, stats, source, upgrade, level) -> {
        if (source == DamageSource.field_76379_h) {
            return upgrade.getBonusValue("protection", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_PHYSICAL_PROTECT = UPGRADES.register("physical_protect", () -> LivingArmorRegistrar.parseDefinition("physical_protect").withArmorProvider((player, stats, source, upgrade, level) -> {
        if (!source.func_76352_a()) {
            return upgrade.getBonusValue("protection", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_JUMP = UPGRADES.register("jump", () -> LivingArmorRegistrar.parseDefinition("jump"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_HEALTH = UPGRADES.register("health", () -> LivingArmorRegistrar.parseDefinition("health").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(uuid, "Health Modifier", (double)upgrade.getBonusValue("hp", level).intValue(), AttributeModifier.Operation.ADDITION))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_EXPERIENCE = UPGRADES.register("experienced", () -> LivingArmorRegistrar.parseDefinition("experienced"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_SPRINT_ATTACK = UPGRADES.register("sprint_attack", () -> LivingArmorRegistrar.parseDefinition("sprint_attack").withDamageProvider((player, weapon, damage, stats, attackedEntity, upgrade, level) -> {
        if (player.func_70051_ag()) {
            return damage * upgrade.getBonusValue("damage_boost", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_SELF_SACRIFICE = UPGRADES.register("self_sacrifice", () -> LivingArmorRegistrar.parseDefinition("self_sacrifice"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_SPEED = UPGRADES.register("speed", () -> LivingArmorRegistrar.parseDefinition("speed").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(uuid, "Movement Modifier 2", upgrade.getBonusValue("speed_modifier", level).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_POISON_RESIST = UPGRADES.register("poison_resist", () -> LivingArmorRegistrar.parseDefinition("poison_resist"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_FIRE_RESIST = UPGRADES.register("fire_resist", () -> LivingArmorRegistrar.parseDefinition("fire_resist"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_DIGGING = UPGRADES.register("digging", () -> LivingArmorRegistrar.parseDefinition("digging"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_KNOCKBACK_RESIST = UPGRADES.register("knockback_resist", () -> LivingArmorRegistrar.parseDefinition("knockback_resist").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> {
        attributeMap.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "KB Modifier", upgrade.getBonusValue("kb", level).doubleValue(), AttributeModifier.Operation.ADDITION));
        attributeMap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(uuid, "Health Modifier 2", (double)upgrade.getBonusValue("hp", level).intValue(), AttributeModifier.Operation.ADDITION));
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_QUENCHED = UPGRADES.register("downgrade/quenched", () -> LivingArmorRegistrar.parseDefinition("downgrade/quenched").asDowngrade());

    public static void register() {
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_ARROW_PROTECT.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_HEALTH.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_EXPERIENCE.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_SPRINT_ATTACK.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_SELF_SACRIFICE.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_SPEED.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_POISON_RESIST.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_DIGGING.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_FALL_PROTECT.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_PHYSICAL_PROTECT.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_JUMP.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_KNOCKBACK_RESIST.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)UPGRADE_FIRE_RESIST.get()));
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)((Object)DOWNGRADE_QUENCHED.get()));
    }

    public static void registerUpgrade(LivingUpgrade upgrade) {
        UPGRADE_MAP.put(upgrade.getKey(), upgrade);
    }

    public static LivingUpgrade parseDefinition(String fileName) {
        ResourceLocation path = DEFINITIONS.get(fileName);
        if (path == null) {
            return LivingUpgrade.DUMMY;
        }
        try {
            URL schematicURL = LivingUpgrade.class.getResource(LivingArmorRegistrar.resLocToResourcePath(path));
            System.out.println("Attempting to load Living Armour Upgrade: " + schematicURL + ", path: " + LivingArmorRegistrar.resLocToResourcePath(path));
            return (LivingUpgrade)((Object)Serializers.GSON.fromJson(Resources.toString((URL)schematicURL, (Charset)Charsets.UTF_8), LivingUpgrade.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return LivingUpgrade.DUMMY;
        }
    }

    public static String resLocToResourcePath(ResourceLocation resourceLocation) {
        return "/data/" + resourceLocation.func_110624_b() + "/living_armor/" + resourceLocation.func_110623_a() + ".json";
    }
}

