/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.storage.WorldSavedData;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class BMWorldSavedData
extends WorldSavedData {
    public static final String ID = "BloodMagic-SoulNetworks";
    private Map<UUID, SoulNetwork> soulNetworks = new HashMap<UUID, SoulNetwork>();

    public BMWorldSavedData(String id) {
        super(id);
    }

    public BMWorldSavedData() {
        this(ID);
    }

    public SoulNetwork getNetwork(PlayerEntity player) {
        return this.getNetwork(PlayerHelper.getUUIDFromPlayer(player));
    }

    public SoulNetwork getNetwork(UUID playerId) {
        if (!this.soulNetworks.containsKey(playerId)) {
            this.soulNetworks.put(playerId, SoulNetwork.newEmpty(playerId).setParent(this));
        }
        return this.soulNetworks.get(playerId);
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        ListNBT networkData = tagCompound.func_150295_c("networkData", 10);
        for (int i = 0; i < networkData.size(); ++i) {
            CompoundNBT data = networkData.func_150305_b(i);
            SoulNetwork network = SoulNetwork.fromNBT(data);
            network.setParent(this);
            this.soulNetworks.put(network.getPlayerId(), network);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT networkData = new ListNBT();
        for (SoulNetwork soulNetwork : this.soulNetworks.values()) {
            networkData.add((Object)soulNetwork.serializeNBT());
        }
        tagCompound.func_218657_a("networkData", (INBT)networkData);
        return tagCompound;
    }
}

