/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.core.living.LivingStats;

public interface ILivingContainer {
    default public LivingStats getLivingStats(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("livingStats")) {
            return null;
        }
        return LivingStats.fromNBT(stack.func_77978_p().func_74775_l("livingStats"));
    }

    default public void updateLivingStats(ItemStack stack, LivingStats stats) {
        if (stats == null) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o("livingStats");
            }
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_218657_a("livingStats", (INBT)stats.serialize());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void appendLivingTooltip(LivingStats stats, List<ITextComponent> tooltip, boolean trainable) {
        if (stats != null) {
            if (trainable) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.livingarmour.upgrade.points", new Object[]{stats.getUsedPoints(), stats.getMaxPoints()}).func_240699_a_(TextFormatting.GOLD));
            }
            stats.getUpgrades().forEach((k, v) -> {
                if (k.getLevel(v.intValue()) <= 0) {
                    return;
                }
                boolean sneaking = Screen.func_231173_s_();
                if (!sneaking || k.getNextRequirement(v.intValue()) == 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent(k.getTranslationKey()), new TranslationTextComponent("enchantment.level." + k.getLevel(v.intValue()))}).func_240699_a_(TextFormatting.GRAY));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent(k.getTranslationKey()), ": " + v.intValue() + "/" + k.getNextRequirement(v.intValue())}).func_240699_a_(TextFormatting.GRAY));
                }
            });
        }
    }
}

