/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.util.PlayerUtil;
import wayoftime.bloodmagic.event.LivingEquipmentEvent;

public class LivingUtil {
    public static Pair<LivingStats, Boolean> applyNewExperience(PlayerEntity player, LivingUpgrade upgrade, double experience) {
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return Pair.of(null, (Object)false);
        }
        if (!LivingUtil.canTrain(player, upgrade, upgrade.getLevel((int)experience))) {
            return Pair.of((Object)stats, (Object)false);
        }
        LivingEquipmentEvent.GainExperience event = new LivingEquipmentEvent.GainExperience(player, stats, upgrade, experience);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return Pair.of((Object)stats, (Object)false);
        }
        experience = event.getExperience();
        double currentExperience = stats.getUpgrades().getOrDefault((Object)upgrade, 0.0);
        double requiredForLevel = (double)upgrade.getNextRequirement((int)currentExperience) - currentExperience;
        if (requiredForLevel <= experience) {
            int currentPoints = stats.getUsedPoints();
            if (currentPoints >= stats.getMaxPoints()) {
                return Pair.of((Object)stats, (Object)false);
            }
            int currentPointCost = upgrade.getLevelCost(upgrade.getLevel((int)currentExperience));
            int nextPointCost = upgrade.getLevelCost(upgrade.getLevel((int)(currentExperience + experience)));
            if (nextPointCost == -1) {
                return Pair.of((Object)stats, (Object)false);
            }
            int pointDif = nextPointCost - currentPointCost;
            if (pointDif < 0 && !upgrade.isNegative()) {
                return Pair.of((Object)stats, (Object)false);
            }
            if (currentPoints + pointDif > stats.getMaxPoints()) {
                return Pair.of((Object)stats, (Object)false);
            }
        }
        int newLevel = upgrade.getLevel((int)(currentExperience + experience));
        boolean didUpgrade = false;
        if (upgrade.getLevel((int)currentExperience) != newLevel) {
            LivingEquipmentEvent.LevelUp levelUpEvent = new LivingEquipmentEvent.LevelUp(player, stats, upgrade);
            MinecraftForge.EVENT_BUS.post((Event)levelUpEvent);
            didUpgrade = true;
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.living_upgrade_level_increase", new Object[]{new TranslationTextComponent(upgrade.getTranslationKey()), newLevel}), true);
        }
        stats.addExperience(upgrade.getKey(), experience);
        LivingStats.toPlayer(player, stats);
        return Pair.of((Object)stats, (Object)didUpgrade);
    }

    public static Pair<LivingStats, Double> applyExperienceToUpgradeCap(PlayerEntity player, LivingUpgrade upgrade, double experience) {
        int potentialLevel;
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return Pair.of(null, (Object)0.0);
        }
        if (!LivingUtil.canTrain(player, upgrade, upgrade.getLevel((int)experience))) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        LivingEquipmentEvent.GainExperience event = new LivingEquipmentEvent.GainExperience(player, stats, upgrade, experience);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        double multiplicationFactor = event.getExperience() / experience;
        experience = event.getExperience();
        if (experience <= 0.0) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        double currentExperience = stats.getUpgrades().getOrDefault((Object)upgrade, 0.0);
        int currentLevel = upgrade.getLevel((int)currentExperience);
        double requiredForLevel = (double)upgrade.getNextRequirement((int)currentExperience) - currentExperience;
        if (requiredForLevel <= experience) {
            int currentPoints = stats.getUsedPoints();
            if (currentPoints >= stats.getMaxPoints()) {
                return Pair.of((Object)stats, (Object)0.0);
            }
            int currentPointCost = upgrade.getLevelCost(currentLevel);
            for (potentialLevel = upgrade.getLevel((int)(currentExperience + experience)); potentialLevel > currentLevel; --potentialLevel) {
                int nextPointCost = upgrade.getLevelCost(potentialLevel);
                if (nextPointCost == -1) {
                    return Pair.of((Object)stats, (Object)0.0);
                }
                int pointDif = nextPointCost - currentPointCost;
                if (pointDif < 0 && !upgrade.isNegative()) {
                    return Pair.of((Object)stats, (Object)0.0);
                }
                if (currentPoints + pointDif <= stats.getMaxPoints()) break;
                experience = (double)upgrade.getLevelExp(potentialLevel) - currentExperience - 1.0;
                if (!(experience <= 0.0)) continue;
                return Pair.of((Object)stats, (Object)0.0);
            }
            if (experience < 0.0) {
                return Pair.of((Object)stats, (Object)0.0);
            }
        }
        if (potentialLevel == 0) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        int newLevel = upgrade.getLevel((int)(currentExperience + experience));
        boolean didUpgrade = false;
        if (upgrade.getLevel((int)currentExperience) != newLevel) {
            LivingEquipmentEvent.LevelUp levelUpEvent = new LivingEquipmentEvent.LevelUp(player, stats, upgrade);
            MinecraftForge.EVENT_BUS.post((Event)levelUpEvent);
            didUpgrade = true;
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.living_upgrade_level_increase", new Object[]{new TranslationTextComponent(upgrade.getTranslationKey()), newLevel}), true);
        }
        stats.addExperience(upgrade.getKey(), experience);
        LivingStats.toPlayer(player, stats);
        return Pair.of((Object)stats, (Object)(experience / multiplicationFactor));
    }

    public static double getDamageReceivedForArmour(PlayerEntity player, DamageSource source, double damage) {
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return damage;
        }
        Map<LivingUpgrade, Double> upgrades = stats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> entry : upgrades.entrySet()) {
            LivingUpgrade upgrade = entry.getKey();
            if (upgrade.getArmorProvider() == null) continue;
            int level = upgrade.getLevel(entry.getValue().intValue());
            damage *= 1.0 - upgrade.getArmorProvider().getProtection(player, stats, source, upgrade, level);
        }
        return damage;
    }

    public static double getAdditionalDamage(PlayerEntity player, ItemStack weapon, LivingEntity attackedEntity, double damage) {
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return 0.0;
        }
        double additionalDamage = 0.0;
        Map<LivingUpgrade, Double> upgrades = stats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> entry : upgrades.entrySet()) {
            LivingUpgrade upgrade = entry.getKey();
            if (upgrade.getArmorProvider() == null) continue;
            int level = upgrade.getLevel(entry.getValue().intValue());
            if (upgrade.getDamageProvider() == null) continue;
            additionalDamage += upgrade.getDamageProvider().getAdditionalDamage(player, weapon, damage, stats, attackedEntity, upgrade, level);
        }
        return additionalDamage;
    }

    public static boolean canTrain(PlayerEntity player, LivingUpgrade upgrade, int currentLevel) {
        ItemStack trainer = PlayerUtil.findItem(player, stack -> stack.func_77973_b() instanceof ItemLivingTrainer && stack.func_77942_o() && stack.func_77978_p().func_74764_b("livingStats"));
        if (trainer.func_190926_b()) {
            return true;
        }
        String mode = trainer.func_77978_p().func_74779_i("livingLock");
        LivingStats stats = ((ILivingContainer)trainer.func_77973_b()).getLivingStats(trainer);
        int levelLimit = stats.getLevel(upgrade.getKey());
        if (mode.equalsIgnoreCase("whitelist")) {
            return levelLimit != 0 && levelLimit > currentLevel;
        }
        if (mode.equalsIgnoreCase("blacklist")) {
            return levelLimit == 0;
        }
        return true;
    }

    public static boolean hasFullSet(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ILivingContainer) continue;
            return false;
        }
        return true;
    }

    public static void applyAttributes(Multimap<Attribute, AttributeModifier> attributes, ItemStack stack, PlayerEntity player, EquipmentSlotType slot) {
        if (player == null || !LivingUtil.hasFullSet(player)) {
            return;
        }
        Multimap newAttributes = ((ArmorItem)stack.func_77973_b()).getAttributeModifiers(slot, stack);
        attributes.putAll(newAttributes);
    }
}

