/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.gson.SerializerBase;

public class Serializers {
    public static final IDataSerializer<EnumDemonWillType> WILL_TYPE_SERIALIZER = new IDataSerializer<EnumDemonWillType>(){

        public void write(PacketBuffer buf, EnumDemonWillType value) {
            buf.func_179249_a((Enum)value);
        }

        public EnumDemonWillType read(PacketBuffer buf) {
            return (EnumDemonWillType)buf.func_179257_a(EnumDemonWillType.class);
        }

        public DataParameter<EnumDemonWillType> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public EnumDemonWillType copyValue(EnumDemonWillType value) {
            return EnumDemonWillType.valueOf(value.name());
        }
    };
    public static final SerializerBase<Direction> FACING_SERIALIZER = new SerializerBase<Direction>(){

        @Override
        public Class<Direction> getType() {
            return Direction.class;
        }

        @Override
        public Direction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Direction.func_176739_a((String)json.getAsString());
        }
    };
    public static final SerializerBase<ResourceLocation> RESOURCELOCATION_SERIALIZER = new SerializerBase<ResourceLocation>(){

        @Override
        public Class<ResourceLocation> getType() {
            return ResourceLocation.class;
        }

        @Override
        public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String domain = json.getAsJsonObject().get("domain").getAsString();
            String path = json.getAsJsonObject().get("path").getAsString();
            return new ResourceLocation(domain, path);
        }

        @Override
        public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("domain", src.func_110624_b());
            object.addProperty("path", src.func_110623_a());
            return object;
        }
    };
    public static final SerializerBase<ItemStack> ITEMMETA_SERIALIZER = new SerializerBase<ItemStack>(){

        @Override
        public Class<ItemStack> getType() {
            return ItemStack.class;
        }

        @Override
        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation registryName = (ResourceLocation)context.deserialize((JsonElement)json.getAsJsonObject().get("registryName").getAsJsonObject(), ResourceLocation.class);
            int meta = json.getAsJsonObject().get("meta").getAsInt();
            return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(registryName), 1);
        }

        @Override
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("registryName", context.serialize((Object)src.func_77973_b().getRegistryName()));
            jsonObject.addProperty("meta", (Number)src.func_77952_i());
            return jsonObject;
        }
    };
    public static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(FACING_SERIALIZER.getType(), FACING_SERIALIZER).registerTypeAdapter(RESOURCELOCATION_SERIALIZER.getType(), RESOURCELOCATION_SERIALIZER).registerTypeAdapter(ITEMMETA_SERIALIZER.getType(), ITEMMETA_SERIALIZER).create();

    static {
        DataSerializers.func_187189_a(WILL_TYPE_SERIALIZER);
    }
}

