/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;

@RitualRegister(value="simple_dungeon")
public class RitualSimpleDungeon
extends Ritual {
    public RitualSimpleDungeon() {
        super("ritualSimpleDungeon", 0, 80000, "ritual.bloodmagic.simpleDungeonRitual");
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, PlayerEntity player, UUID owner) {
        if (((Boolean)ConfigManager.COMMON.makeDungeonRitualCreativeOnly.get()).booleanValue()) {
            ItemStack heldStack = player.func_184607_cu();
            if (heldStack.func_77973_b() instanceof ItemActivationCrystal) {
                int crystalLevel = ((ItemActivationCrystal)heldStack.func_77973_b()).getCrystalLevel(heldStack);
                return crystalLevel == Integer.MAX_VALUE;
            }
            return false;
        }
        return true;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        if (!world.field_72995_K && world instanceof ServerWorld) {
            DungeonSynthesizer dungeon = new DungeonSynthesizer();
            ResourceLocation initialType = new ResourceLocation("bloodmagic:room_pools/entrances/mini_dungeon_entrances");
            BlockPos safePlayerPosition = dungeon.generateInitialRoom(initialType, world.field_73012_v, (ServerWorld)world, masterPos);
            AxisAlignedBB bb = new AxisAlignedBB(masterPos).func_72321_a(5.0, 5.0, 5.0);
            List players = world.func_217357_a(PlayerEntity.class, bb);
            for (PlayerEntity player : players) {
                player.func_70634_a((double)safePlayerPosition.func_177958_n(), (double)safePlayerPosition.func_177956_o(), (double)safePlayerPosition.func_177952_p());
            }
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        for (int i = -1; i <= 1; ++i) {
            this.addRune(components, i, 0, 3, EnumRuneType.WATER);
            this.addRune(components, i, 0, -3, EnumRuneType.WATER);
            this.addRune(components, 3, 0, i, EnumRuneType.FIRE);
            this.addRune(components, -3, 0, i, EnumRuneType.FIRE);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSimpleDungeon();
    }
}

