/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.ArrayUtils;
import wayoftime.bloodmagic.api.event.BloodMagicCraftedEvent;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IAlchemyItem;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.tile.container.ContainerAlchemyTable;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class TileAlchemyTable
extends TileInventory
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    @ObjectHolder(value="bloodmagic:alchemytable")
    public static TileEntityType<TileAlchemyTable> TYPE;
    public static final int orbSlot = 6;
    public static final int outputSlot = 7;
    public Direction direction = Direction.NORTH;
    public boolean isSlave = false;
    public int burnTime = 0;
    public int ticksRequired = 1;
    public BlockPos connectedPos = BlockPos.field_177992_a;
    public boolean[] blockedSlots = new boolean[]{false, false, false, false, false, false};
    public boolean[] allowedDirectionsSlot0 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot1 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot2 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot3 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot4 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot5 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsOrb = new boolean[]{false, true, false, false, false, false};
    public boolean[] allowedDirectionsOutput = new boolean[]{true, false, false, false, false, false};
    public int activeSlot = -1;

    public TileAlchemyTable(TileEntityType<?> type) {
        super(type, 8, "alchemytable");
    }

    public TileAlchemyTable() {
        this(TYPE);
    }

    public void setInitialTableParameters(Direction direction, boolean isSlave, BlockPos connectedPos) {
        this.isSlave = isSlave;
        this.connectedPos = connectedPos;
        if (!isSlave) {
            this.direction = direction;
        }
    }

    public boolean isInvisible() {
        return this.isSlave();
    }

    public boolean isInputSlotAccessible(int slot) {
        return slot >= 6 || slot < 0 || !this.blockedSlots[slot];
    }

    public void toggleInputSlotAccessible(int slot) {
        if (slot < 6 && slot >= 0) {
            this.blockedSlots[slot] = !this.blockedSlots[slot];
        }
    }

    public boolean isSlotEnabled(int slot, Direction dir) {
        switch (slot) {
            case 0: {
                return this.allowedDirectionsSlot0[dir.ordinal()];
            }
            case 1: {
                return this.allowedDirectionsSlot1[dir.ordinal()];
            }
            case 2: {
                return this.allowedDirectionsSlot2[dir.ordinal()];
            }
            case 3: {
                return this.allowedDirectionsSlot3[dir.ordinal()];
            }
            case 4: {
                return this.allowedDirectionsSlot4[dir.ordinal()];
            }
            case 5: {
                return this.allowedDirectionsSlot5[dir.ordinal()];
            }
            case 6: {
                return this.allowedDirectionsOrb[dir.ordinal()];
            }
            case 7: {
                return this.allowedDirectionsOutput[dir.ordinal()];
            }
        }
        return false;
    }

    public void setSlotEnabled(boolean enabled, int slot, Direction dir) {
        switch (slot) {
            case 0: {
                this.allowedDirectionsSlot0[dir.ordinal()] = enabled;
                break;
            }
            case 1: {
                this.allowedDirectionsSlot1[dir.ordinal()] = enabled;
                break;
            }
            case 2: {
                this.allowedDirectionsSlot2[dir.ordinal()] = enabled;
                break;
            }
            case 3: {
                this.allowedDirectionsSlot3[dir.ordinal()] = enabled;
                break;
            }
            case 4: {
                this.allowedDirectionsSlot4[dir.ordinal()] = enabled;
                break;
            }
            case 5: {
                this.allowedDirectionsSlot5[dir.ordinal()] = enabled;
                break;
            }
            case 6: {
                this.allowedDirectionsOrb[dir.ordinal()] = enabled;
                break;
            }
            case 7: {
                this.allowedDirectionsOutput[dir.ordinal()] = enabled;
            }
        }
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        int i;
        super.deserialize(tag);
        this.isSlave = tag.func_74767_n("isSlave");
        this.direction = Direction.func_82600_a((int)tag.func_74762_e("direction"));
        this.connectedPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
        this.burnTime = tag.func_74762_e("burnTime");
        this.ticksRequired = tag.func_74762_e("ticksRequired");
        byte[] array = tag.func_74770_j("blockedSlots");
        for (i = 0; i < array.length; ++i) {
            this.blockedSlots[i] = array[i] != 0;
        }
        for (i = 0; i <= 7; ++i) {
            byte[] allowedSlotArray = tag.func_74770_j("allowedDirections" + i);
            for (int j = 0; j < Math.min(allowedSlotArray.length, Direction.values().length); ++j) {
                this.setSlotEnabled(allowedSlotArray[j] == 1, i, Direction.values()[j]);
            }
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        int i;
        super.serialize(tag);
        tag.func_74757_a("isSlave", this.isSlave);
        tag.func_74768_a("direction", this.direction.func_176745_a());
        tag.func_74768_a("xCoord", this.connectedPos.func_177958_n());
        tag.func_74768_a("yCoord", this.connectedPos.func_177956_o());
        tag.func_74768_a("zCoord", this.connectedPos.func_177952_p());
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74768_a("ticksRequired", this.ticksRequired);
        byte[] blockedSlotArray = new byte[this.blockedSlots.length];
        for (i = 0; i < this.blockedSlots.length; ++i) {
            blockedSlotArray[i] = (byte)(this.blockedSlots[i] ? 1 : 0);
        }
        tag.func_74773_a("blockedSlots", blockedSlotArray);
        for (i = 0; i <= 7; ++i) {
            byte[] allowedSlotArray = new byte[Direction.values().length];
            for (int j = 0; j < Direction.values().length; ++j) {
                allowedSlotArray[j] = (byte)(this.isSlotEnabled(i, Direction.values()[j]) ? 1 : 0);
            }
            tag.func_74773_a("allowedDirections" + i, allowedSlotArray);
        }
        return tag;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isSlave()) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.connectedPos);
                if (tile instanceof TileAlchemyTable && !((TileAlchemyTable)tile).isSlave) {
                    return tile.getCapability(capability, facing);
                }
            } else {
                return super.getCapability(capability, facing);
            }
        }
        return super.getCapability(capability, facing);
    }

    public int[] func_180463_a(Direction side) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (int i = 0; i <= 7; ++i) {
            if (!this.isSlotEnabled(i, side)) continue;
            integerList.add(i);
        }
        int[] intArray = new int[integerList.size()];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = (Integer)integerList.get(i);
        }
        return intArray;
    }

    public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
        switch (index) {
            case 7: {
                return false;
            }
            case 6: {
                return !stack.func_190926_b() && stack.func_77973_b() instanceof IBloodOrb;
            }
        }
        return this.isSlotEnabled(index, direction);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        switch (direction) {
            default: 
        }
        return this.isSlotEnabled(index, direction);
    }

    public List<Integer> getAccessibleInputSlots(Direction direction) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            if (!this.isInputSlotAccessible(i)) continue;
            list.add(i);
        }
        return list;
    }

    public void func_73660_a() {
        if (this.isSlave()) {
            return;
        }
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            inputList.add(this.func_70301_a(i));
        }
        int tier = this.getTierOfOrb();
        RecipeAlchemyTable recipeAlchemyTable = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyTable(this.field_145850_b, inputList);
        if (recipeAlchemyTable != null && (this.burnTime > 0 || !this.func_145831_w().field_72995_K && tier >= recipeAlchemyTable.getMinimumTier() && this.getContainedLp() >= recipeAlchemyTable.getSyphon())) {
            if (this.burnTime == 1) {
                this.notifyUpdate();
            }
            if (this.canCraft(recipeAlchemyTable.getOutput(inputList))) {
                this.ticksRequired = recipeAlchemyTable.getTicks();
                ++this.burnTime;
                if (this.burnTime >= this.ticksRequired && !this.func_145831_w().field_72995_K) {
                    if (recipeAlchemyTable.getSyphon() > 0 && this.consumeLp(recipeAlchemyTable.getSyphon()) < recipeAlchemyTable.getSyphon()) {
                        this.burnTime = 0;
                        this.notifyUpdate();
                        return;
                    }
                    Object[] inputs = new ItemStack[]{};
                    for (ItemStack stack : inputList) {
                        ArrayUtils.add((Object[])inputs, (Object)stack.func_77946_l());
                    }
                    BloodMagicCraftedEvent.AlchemyTable event = new BloodMagicCraftedEvent.AlchemyTable(recipeAlchemyTable.getOutput(inputList).func_77946_l(), (ItemStack[])inputs);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    ItemStack outputSlotStack = this.func_70301_a(7);
                    if (outputSlotStack.func_190926_b()) {
                        this.func_70299_a(7, event.getOutput());
                    } else {
                        outputSlotStack.func_190917_f(event.getOutput().func_190916_E());
                    }
                    this.consumeInventory(recipeAlchemyTable);
                    this.burnTime = 0;
                    this.notifyUpdate();
                }
            }
        } else {
            this.burnTime = 0;
        }
    }

    public double getProgressForGui() {
        return (double)this.burnTime / (double)this.ticksRequired;
    }

    private boolean canCraft(ItemStack output) {
        ItemStack currentOutputStack = this.func_70301_a(7);
        if (output.func_190926_b()) {
            return false;
        }
        if (currentOutputStack.func_190926_b()) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)currentOutputStack)) {
            return false;
        }
        int result = currentOutputStack.func_190916_E() + output.func_190916_E();
        return result <= this.func_70297_j_() && result <= currentOutputStack.func_77976_d();
    }

    public int getTierOfOrb() {
        ItemStack orbStack = this.func_70301_a(6);
        if (!orbStack.func_190926_b() && orbStack.func_77973_b() instanceof IBloodOrb) {
            BloodOrb orb = ((IBloodOrb)orbStack.func_77973_b()).getOrb(orbStack);
            return orb == null ? 0 : orb.getTier();
        }
        return 0;
    }

    public int getContainedLp() {
        ItemStack orbStack = this.func_70301_a(6);
        if (!orbStack.func_190926_b() && orbStack.func_77973_b() instanceof IBloodOrb) {
            Binding binding = ((IBindable)orbStack.func_77973_b()).getBinding(orbStack);
            if (binding == null) {
                return 0;
            }
            SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
            return network.getCurrentEssence();
        }
        return 0;
    }

    public void craftItem(List<ItemStack> inputList, RecipeAlchemyTable recipe) {
        ItemStack outputStack = recipe.getOutput(inputList);
        if (this.canCraft(outputStack)) {
            ItemStack currentOutputStack = this.func_70301_a(7);
            Object[] inputs = new ItemStack[]{};
            for (ItemStack stack : inputList) {
                ArrayUtils.add((Object[])inputs, (Object)stack.func_77946_l());
            }
            BloodMagicCraftedEvent.AlchemyTable event = new BloodMagicCraftedEvent.AlchemyTable(outputStack.func_77946_l(), (ItemStack[])inputs);
            MinecraftForge.EVENT_BUS.post((Event)event);
            outputStack = event.getOutput();
            if (currentOutputStack.func_190926_b()) {
                this.func_70299_a(7, outputStack);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)currentOutputStack)) {
                currentOutputStack.func_190917_f(outputStack.func_190916_E());
            }
            this.consumeInventory(recipe);
        }
    }

    public int consumeLp(int requested) {
        ItemStack orbStack = this.func_70301_a(6);
        if (!orbStack.func_190926_b() && orbStack.func_77973_b() instanceof IBloodOrb && NetworkHelper.syphonFromContainer(orbStack, SoulTicket.item(orbStack, this.field_145850_b, this.field_174879_c, requested))) {
            return requested;
        }
        return 0;
    }

    public void consumeInventory(RecipeAlchemyTable recipe) {
        for (int i = 0; i < 6; ++i) {
            ItemStack inputStack = this.func_70301_a(i);
            if (inputStack.func_190926_b()) continue;
            if (inputStack.func_77973_b() instanceof IAlchemyItem) {
                if (!((IAlchemyItem)inputStack.func_77973_b()).isStackChangedOnUse(inputStack)) continue;
                this.func_70299_a(i, ((IAlchemyItem)inputStack.func_77973_b()).onConsumeInput(inputStack));
                continue;
            }
            if (inputStack.func_77973_b().hasContainerItem(inputStack)) {
                this.func_70299_a(i, inputStack.func_77973_b().getContainerItem(inputStack));
                continue;
            }
            if (inputStack.func_77958_k() > 0) {
                if (!inputStack.func_77984_f() || !inputStack.func_96631_a(1, this.field_145850_b.field_73012_v, null)) continue;
                this.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            inputStack.func_190918_g(1);
            if (!inputStack.func_190926_b()) continue;
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public BlockPos getConnectedPos() {
        return this.connectedPos;
    }

    public boolean[] getBlockedSlots() {
        return this.blockedSlots;
    }

    public static int getOrbSlot() {
        return 6;
    }

    public static int getOutputSlot() {
        return 7;
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        assert (this.field_145850_b != null);
        return new ContainerAlchemyTable(this, p_createMenu_1_, p_createMenu_2_);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Alchemy Table");
    }
}

