/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.core.data.BMWorldSavedData;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.event.SoulNetworkEvent;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class NetworkHelper {
    @Nullable
    private static BMWorldSavedData dataHandler;

    public static SoulNetwork getSoulNetwork(String uuid) {
        if (dataHandler == null) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return null;
            }
            DimensionSavedDataManager savedData = ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x();
            dataHandler = (BMWorldSavedData)savedData.func_215752_a(() -> new BMWorldSavedData(), "BloodMagic-SoulNetworks");
        }
        return dataHandler.getNetwork(UUID.fromString(uuid));
    }

    public static SoulNetwork getSoulNetwork(UUID uuid) {
        return NetworkHelper.getSoulNetwork(uuid.toString());
    }

    public static SoulNetwork getSoulNetwork(PlayerEntity player) {
        return NetworkHelper.getSoulNetwork(PlayerHelper.getUUIDFromPlayer(player));
    }

    public static SoulNetwork getSoulNetwork(Binding binding) {
        return NetworkHelper.getSoulNetwork(binding.getOwnerId());
    }

    public static int getCurrentMaxOrb(SoulNetwork soulNetwork) {
        return soulNetwork.getOrbTier();
    }

    public static int getMaximumForTier(int tier) {
        int ret = 0;
        if (tier > OrbRegistry.getTierMap().size() || tier < 0) {
            return ret;
        }
        for (ItemStack orbStack : OrbRegistry.getOrbsForTier(tier)) {
            BloodOrb orb = ((IBloodOrb)orbStack.func_77973_b()).getOrb(orbStack);
            if (orb.getCapacity() <= ret) continue;
            ret = orb.getCapacity();
        }
        return ret;
    }

    @Deprecated
    public static boolean syphonAndDamage(SoulNetwork soulNetwork, PlayerEntity user, int toSyphon) {
        return soulNetwork.syphonAndDamage(user, toSyphon);
    }

    public static boolean syphonFromContainer(ItemStack stack, SoulTicket ticket) {
        if (!(stack.func_77973_b() instanceof IBindable)) {
            return false;
        }
        Binding binding = ((IBindable)stack.func_77973_b()).getBinding(stack);
        if (binding == null) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
        SoulNetworkEvent.Syphon.Item event = new SoulNetworkEvent.Syphon.Item(network, ticket, stack);
        return !MinecraftForge.EVENT_BUS.post((Event)event) && network.syphon(event.getTicket(), true) >= ticket.getAmount();
    }

    public static boolean canSyphonFromContainer(ItemStack stack, int toSyphon) {
        if (!(stack.func_77973_b() instanceof IBindable)) {
            return false;
        }
        Binding binding = ((IBindable)stack.func_77973_b()).getBinding(stack);
        if (binding == null) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
        if (network == null) {
            return false;
        }
        return network.getCurrentEssence() >= toSyphon;
    }

    public static void setMaxOrb(SoulNetwork soulNetwork, int maxOrb) {
        soulNetwork.setOrbTier(Math.max(maxOrb, soulNetwork.getOrbTier()));
    }
}

