/*
 * Decompiled with CFR 0.152.
 */
package com.zander.campfire_overhaul.event;

import com.zander.campfire_overhaul.config.CampfireOverhaulConfig;
import com.zander.campfire_overhaul.util.CampfireHelper;
import com.zander.campfire_overhaul.util.ICampfireExtra;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AlternativeFireMethods {
    @SubscribeEvent
    public void fireStarterFlint(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        BlockPos blockPos = event.getPos();
        BlockState blockState = event.getWorld().func_180495_p(event.getPos());
        if (event.getHand() == Hand.MAIN_HAND) {
            if (player.func_184614_ca().func_77973_b() == Items.field_151145_ak && player.func_184592_cb().func_77973_b() == Items.field_151145_ak) {
                if (!((Boolean)CampfireOverhaulConfig.DOUBLE_FLINT_IGNITION.get()).booleanValue()) {
                    return;
                }
                if (!CampfireBlock.func_241470_h_((BlockState)blockState)) {
                    return;
                }
                Random rand = event.getWorld().field_73012_v;
                player.func_184609_a(Hand.MAIN_HAND);
                if ((double)rand.nextFloat() < (Double)CampfireOverhaulConfig.FLINT_IGNITE_CHANCE.get() && !world.field_72995_K) {
                    world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 3);
                }
                world.func_184133_a(null, blockPos, SoundEvents.field_187902_gb, SoundCategory.BLOCKS, 1.0f, 2.0f + rand.nextFloat() * 0.4f);
                if (world.field_72995_K) {
                    for (int i = 0; i < 5; ++i) {
                        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, player.func_226277_ct_() + player.func_70040_Z().func_82615_a() + (double)rand.nextFloat() * 0.25, player.func_226278_cu_() + 0.5 + (double)rand.nextFloat() * 0.25, player.func_226281_cx_() + player.func_70040_Z().func_82616_c() + (double)rand.nextFloat() * 0.25, 0.0, 0.01, 0.0);
                    }
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_() + player.func_70040_Z().func_82615_a() + (double)rand.nextFloat() * 0.25, player.func_226278_cu_() + 0.5 + (double)rand.nextFloat() * 0.25, player.func_226281_cx_() + player.func_70040_Z().func_82616_c() + (double)rand.nextFloat() * 0.25, 0.0, 0.01, 0.0);
                }
            } else if (player.func_184614_ca().func_77973_b() == Items.field_185157_bK) {
                if (!((Boolean)CampfireOverhaulConfig.DRAGON_BREATH_MAGIC.get()).booleanValue()) {
                    return;
                }
                if (!world.field_72995_K) {
                    world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 3);
                    ((ICampfireExtra)world.func_175625_s(blockPos)).setLifeTime(-1337);
                }
                world.func_184133_a(null, blockPos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void checkCampfireLifeTime(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        BlockState blockState = world.func_180495_p(pos);
        if (!(blockState.func_177230_c() instanceof CampfireBlock) || !player.func_184614_ca().func_190926_b()) {
            return;
        }
        if (event.getHand() == Hand.MAIN_HAND) {
            ICampfireExtra info = (ICampfireExtra)world.func_175625_s(pos);
            if (!world.field_72995_K) {
                if (info.getLifeTime() != -1337) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("This campfire have " + info.getLifeTime() / 20 + " seconds of burn time left."), player.func_110124_au());
                } else {
                    player.func_145747_a((ITextComponent)new StringTextComponent("This campfire will burn forever!"), player.func_110124_au());
                }
            }
        }
    }

    @SubscribeEvent
    public void campfireSet(BlockEvent.EntityPlaceEvent event) {
        BlockState placed = event.getPlacedBlock();
        BlockPos pos = event.getPos();
        if (!(event.getWorld().func_175625_s(pos) instanceof CampfireTileEntity)) {
            return;
        }
        CampfireTileEntity tileEntity = (CampfireTileEntity)event.getWorld().func_175625_s(pos);
        ICampfireExtra lifeTime = (ICampfireExtra)tileEntity;
        if (CampfireHelper.isSoul(placed)) {
            if (((Boolean)CampfireOverhaulConfig.SOUL_CAMPFIRE_INFINITE_LIFE_TIME.get()).booleanValue()) {
                lifeTime.setLifeTime(-1337);
            } else {
                lifeTime.setLifeTime((Integer)CampfireOverhaulConfig.SOUL_CAMPFIRE_DEFAULT_LIFE_TIME.get());
            }
        } else if (((Boolean)CampfireOverhaulConfig.CAMPFIRE_INFINITE_LIFE_TIME.get()).booleanValue()) {
            lifeTime.setLifeTime(-1337);
        } else {
            lifeTime.setLifeTime((Integer)CampfireOverhaulConfig.CAMPFIRE_DEFAULT_LIFE_TIME.get());
        }
    }
}

