/*
 * Decompiled with CFR 0.152.
 */
package com.zander.campfire_overhaul.mixin;

import com.zander.campfire_overhaul.config.CampfireOverhaulConfig;
import com.zander.campfire_overhaul.util.CampfireHelper;
import com.zander.campfire_overhaul.util.ICampfireExtra;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireTileEntity.class})
public abstract class CampfireTileEntityMixin
extends TileEntity
implements ICampfireExtra {
    private int lifeTime = -1337;

    @Shadow
    public abstract void func_213986_d();

    @Override
    public int getLifeTime() {
        return this.lifeTime;
    }

    @Override
    public void addLifeTime(int add) {
        this.lifeTime += add;
    }

    @Override
    public void setLifeTime(int set) {
        this.lifeTime = set;
    }

    public CampfireTileEntityMixin(TileEntityType<?> tileEntityTypeIn) {
        super(TileEntityType.field_222488_F);
    }

    private void extinguishCampfire() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void breakCampfire() {
        this.func_213986_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"tick()V"})
    private void tick(CallbackInfo ci) {
        if (this.field_145850_b != null && this.lifeTime != -1337 && CampfireBlock.func_226915_i_((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()))) {
            if (this.lifeTime > 0) {
                --this.lifeTime;
            } else {
                this.lifeTime = 0;
                if (CampfireHelper.isSoul(this.func_195044_w())) {
                    if (((Boolean)CampfireOverhaulConfig.SOUL_CAMPFIRE_DESTROYED_ON_BURNOUT.get()).booleanValue()) {
                        this.breakCampfire();
                    } else {
                        this.extinguishCampfire();
                    }
                } else if (((Boolean)CampfireOverhaulConfig.CAMPFIRE_DESTROYED_ON_BURNOUT.get()).booleanValue()) {
                    this.breakCampfire();
                } else {
                    this.extinguishCampfire();
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"read(Lnet/minecraft/block/BlockState;Lnet/minecraft/nbt/CompoundNBT;)V"})
    private void readAdditional(BlockState state, CompoundNBT nbt, CallbackInfo ci) {
        if (nbt.func_150297_b("LifeTime", 3)) {
            this.setLifeTime(nbt.func_74762_e("LifeTime"));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"write(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;"}, cancellable=true)
    private void writeAdditional(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        CompoundNBT nbt = (CompoundNBT)cir.getReturnValue();
        nbt.func_74768_a("LifeTime", this.lifeTime);
        cir.setReturnValue((Object)nbt);
    }
}

