/*
 * Decompiled with CFR 0.152.
 */
package com.zander.campfire_overhaul.mixin;

import com.zander.campfire_overhaul.config.CampfireOverhaulConfig;
import com.zander.campfire_overhaul.util.ICampfireExtra;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlock.class})
public abstract class CampfireBlockMixin
extends ContainerBlock {
    @Shadow
    @Final
    public static BooleanProperty field_220101_b;

    @Shadow
    public static boolean func_226915_i_(BlockState state) {
        return false;
    }

    protected CampfireBlockMixin(AbstractBlock.Properties builder) {
        super(builder);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(ZILnet/minecraft/block/AbstractBlock$Properties;)V"})
    protected void init(boolean smokey, int fireDamage, AbstractBlock.Properties properties, CallbackInfo callbackInfo) {
        if (((Boolean)CampfireOverhaulConfig.CAMPFIRE_CREATED_UNLIT.get()).booleanValue()) {
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getStateForPlacement(Lnet/minecraft/item/BlockItemUseContext;)Lnet/minecraft/block/BlockState;"}, cancellable=true)
    protected void getStateForPlacement(BlockItemUseContext context, CallbackInfoReturnable<BlockState> callbackInfo) {
        if (((Boolean)CampfireOverhaulConfig.CAMPFIRE_CREATED_UNLIT.get()).booleanValue()) {
            callbackInfo.setReturnValue(((BlockState)callbackInfo.getReturnValue()).func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEntityCollision(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V"}, cancellable=true)
    protected void onEntityCollision(BlockState state, World worldIn, BlockPos pos, Entity entityIn, CallbackInfo callbackInfo) {
        if (entityIn instanceof ItemEntity) {
            Random rand = worldIn.field_73012_v;
            int rawBurnTime = ForgeHooks.getBurnTime((ItemStack)((ItemEntity)entityIn).func_92059_d());
            if (worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)field_220101_b)).booleanValue() && rawBurnTime > 0) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, entityIn.func_226277_ct_(), entityIn.func_226278_cu_() + 0.25, entityIn.func_226281_cx_(), 0.0, 0.05, 0.0);
            }
            if (rawBurnTime > 0) {
                if (!worldIn.field_72995_K && ((ItemEntity)entityIn).func_200214_m() != null) {
                    int burnTime = rawBurnTime * (Integer)CampfireOverhaulConfig.CAMPFIRE_FUEL_MULTIPLIER.get() * ((ItemEntity)entityIn).func_92059_d().func_190916_E();
                    CampfireTileEntity tileEntity = (CampfireTileEntity)worldIn.func_175625_s(pos);
                    ((ICampfireExtra)tileEntity).addLifeTime(burnTime);
                    entityIn.func_70106_y();
                }
                if (worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)field_220101_b)).booleanValue() && ((ItemEntity)entityIn).func_200214_m() != null) {
                    for (int i = 0; i < 4; ++i) {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), (double)(rand.nextFloat() / 3.0f), (double)rand.nextFloat() * 0.25, (double)(rand.nextFloat() / 3.0f));
                    }
                }
            }
        }
    }
}

