/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.blocks;

import mod.casinocraft.blocks.BlockBlock;
import mod.casinocraft.tileentities.TileEntityMachine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class MachinaBasic
extends BlockBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public MachinaBasic(Block block) {
        super(block);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        TileEntityMachine tileEntity = (TileEntityMachine)worldIn.func_175625_s(pos);
        float f = state.func_185887_b(worldIn, pos);
        if (tileEntity.settingIndestructableBlock) {
            f *= 1000.0f;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)worldIn, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileEntityMachine tileEntity = (TileEntityMachine)world.func_175625_s(pos);
        return this.getBlock().func_149638_a() * (float)(tileEntity.settingIndestructableBlock ? 1000 : 1);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() == Blocks.field_150350_a) {
            this.spawnInventory(worldIn, pos, (TileEntityMachine)worldIn.func_175625_s(pos));
            worldIn.func_175655_b(pos, true);
            worldIn.func_175713_t(pos);
        }
    }
}

