/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.container;

import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.tileentities.TileEntityMachine;
import mod.casinocraft.util.LogicData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ContainerBase
extends Container {
    public IInventory inventory;
    protected World world;
    protected IIntArray casinoData;
    protected LogicData logicData;
    protected BlockPos pos = new BlockPos(0, 0, 0);
    public DyeColor color;
    public int tableID;
    protected LogicBase LOGIC;

    public ContainerBase(ContainerType<?> type, int windowID, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(type, windowID, playerInventory, BlockPos.func_218283_e((long)packetBuffer.readLong()));
    }

    public ContainerBase(ContainerType<?> type, int windowID, PlayerInventory playerInventory, BlockPos pos) {
        this(type, windowID, playerInventory, (TileEntityMachine)playerInventory.field_70458_d.func_130014_f_().func_175625_s(pos));
        this.pos = pos;
    }

    public ContainerBase(ContainerType<?> type, int windowID, PlayerInventory playerInventory, TileEntityMachine board) {
        super(type, windowID);
        this.inventory = board;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.casinoData = board.casinoData;
        this.logicData = board.logicData;
        this.color = board.color;
        this.tableID = board.tableID;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    protected void addPlayerSlots(PlayerInventory playerInventory) {
        this.addPlayerSlots(playerInventory, 8, 56);
    }

    protected void addPlayerSlots(PlayerInventory playerInventory, int inX, int inY) {
        int row;
        for (row = 0; row < 9; ++row) {
            int x = inX + row * 18;
            int y = inY + 86;
            this.func_75146_a(new Slot((IInventory)playerInventory, row, x, y));
        }
        for (row = 1; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = inX + col * 18;
                int y = row * 18 + (inY + 10);
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9, x, y));
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public int getStorageToken() {
        return this.casinoData.func_221476_a(0);
    }

    public int getStoragePrize() {
        return this.casinoData.func_221476_a(1);
    }

    public int getBettingLow() {
        return this.casinoData.func_221476_a(2);
    }

    public int getBettingHigh() {
        return this.casinoData.func_221476_a(3);
    }

    public int getPrizeScore1() {
        return this.casinoData.func_221476_a(4);
    }

    public int getPrizeScore2() {
        return this.casinoData.func_221476_a(5);
    }

    public int getPrizeScore3() {
        return this.casinoData.func_221476_a(6);
    }

    public int getPrizeCount1() {
        return this.casinoData.func_221476_a(7);
    }

    public int getPrizeCount2() {
        return this.casinoData.func_221476_a(8);
    }

    public int getPrizeCount3() {
        return this.casinoData.func_221476_a(9);
    }

    public boolean getPrizeMode1() {
        return this.casinoData.func_221476_a(10) == 1;
    }

    public boolean getPrizeMode2() {
        return this.casinoData.func_221476_a(11) == 1;
    }

    public boolean getPrizeMode3() {
        return this.casinoData.func_221476_a(12) == 1;
    }

    public boolean getTransferTokenIN() {
        return this.casinoData.func_221476_a(13) == 1;
    }

    public boolean getTransferTokenOUT() {
        return this.casinoData.func_221476_a(14) == 1;
    }

    public boolean getTransferPrizeIN() {
        return this.casinoData.func_221476_a(15) == 1;
    }

    public boolean getTransferPrizeOUT() {
        return this.casinoData.func_221476_a(16) == 1;
    }

    public boolean getSettingInfiniteToken() {
        return this.casinoData.func_221476_a(17) == 1;
    }

    public boolean getSettingInfinitePrize() {
        return this.casinoData.func_221476_a(18) == 1;
    }

    public boolean getSettingDropOnBreak() {
        return this.casinoData.func_221476_a(19) == 1;
    }

    public boolean getSettingIndestructable() {
        return this.casinoData.func_221476_a(20) == 1;
    }

    public int getSettingAlternateColor() {
        return this.casinoData.func_221476_a(21);
    }

    public ItemStack getItemToken() {
        return this.inventory.func_70301_a(3);
    }

    public ItemStack getItemPrize() {
        return this.inventory.func_70301_a(4);
    }

    public void setStorageToken(int value) {
        this.casinoData.func_221477_a(0, value);
    }

    public void setStoragePrize(int value) {
        this.casinoData.func_221477_a(1, value);
    }

    public void setBettingLow(int value) {
        this.casinoData.func_221477_a(2, value);
    }

    public void setBettingHigh(int value) {
        this.casinoData.func_221477_a(3, value);
    }

    public void setPrizeScore1(int value) {
        this.casinoData.func_221477_a(4, value);
    }

    public void setPrizeScore2(int value) {
        this.casinoData.func_221477_a(5, value);
    }

    public void setPrizeScore3(int value) {
        this.casinoData.func_221477_a(6, value);
    }

    public void setPrizeCount1(int value) {
        this.casinoData.func_221477_a(7, value);
    }

    public void setPrizeCount2(int value) {
        this.casinoData.func_221477_a(8, value);
    }

    public void setPrizeCount3(int value) {
        this.casinoData.func_221477_a(9, value);
    }

    public void setPrizeMode1(boolean value) {
        this.casinoData.func_221477_a(10, value ? 1 : 0);
    }

    public void setPrizeMode2(boolean value) {
        this.casinoData.func_221477_a(11, value ? 1 : 0);
    }

    public void setPrizeMode3(boolean value) {
        this.casinoData.func_221477_a(12, value ? 1 : 0);
    }

    public void setTransferTokenIN(boolean value) {
        this.casinoData.func_221477_a(13, value ? 1 : 0);
    }

    public void setTransferTokenOUT(boolean value) {
        this.casinoData.func_221477_a(14, value ? 1 : 0);
    }

    public void setTransferPrizeIN(boolean value) {
        this.casinoData.func_221477_a(15, value ? 1 : 0);
    }

    public void setTransferPrizeOUT(boolean value) {
        this.casinoData.func_221477_a(16, value ? 1 : 0);
    }

    public void setSettingInfiniteToken(boolean value) {
        this.casinoData.func_221477_a(17, value ? 1 : 0);
    }

    public void setSettingInfinitePrize(boolean value) {
        this.casinoData.func_221477_a(18, value ? 1 : 0);
    }

    public void setSettingDropOnBreak(boolean value) {
        this.casinoData.func_221477_a(19, value ? 1 : 0);
    }

    public void setSettingIndestructable(boolean value) {
        this.casinoData.func_221477_a(20, value ? 1 : 0);
    }

    public void setSettingAlternateColor(int value) {
        this.casinoData.func_221477_a(21, value);
    }

    public void setItemToken(ItemStack itemStack) {
        this.inventory.func_70299_a(3, itemStack);
    }

    public void setItemPrize(ItemStack itemStack) {
        this.inventory.func_70299_a(4, itemStack);
    }

    public boolean hasKey() {
        return !this.inventory.func_70301_a(0).func_190926_b();
    }

    public boolean hasModule() {
        return !this.inventory.func_70301_a(1).func_190926_b();
    }

    public boolean hasToken() {
        return this.casinoData.func_221476_a(0) > 0;
    }

    public boolean hasReward() {
        return this.casinoData.func_221476_a(1) > 0;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public World world() {
        return this.world;
    }

    public LogicBase logic() {
        return this.logicData.get();
    }

    public int turnstate() {
        return this.logicData.get().turnstate;
    }

    public abstract int getID();

    public String getCurrentPlayer(int index) {
        TileEntityMachine te = (TileEntityMachine)this.world.func_175625_s(this.pos);
        return this.logic().currentPlayer[index];
    }
}

