/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.Dice;
import mod.casinocraft.util.Ship;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public abstract class LogicBase {
    public final Random RANDOM = new Random();
    public int scorePoint = -1;
    public int scoreLevel = -1;
    public int scoreLives = -1;
    public String hand = "NULL";
    public String[] currentPlayer = new String[]{"void", "void", "void", "void", "void", "void"};
    public int[] reward = new int[]{0, 0, 0, 0, 0, 0};
    public int[][] grid = new int[1][1];
    public Vector2 selector = new Vector2(0, 0);
    public int turnstate;
    public final int tableID;
    public int[] scoreHigh = new int[20];
    public String[] scoreName = new String[20];
    public int scoreLast = 18;
    public boolean pause = false;
    public int frame = 0;
    public int activePlayer = 0;
    public int timeout = 0;
    public int jingle = 0;

    public LogicBase(int table) {
        this(table, 1, 1);
    }

    public LogicBase(int tableID, int gridX, int gridY) {
        this.tableID = tableID;
        if (this.hasHighscore()) {
            this.setupHighscore();
        }
        this.grid = new int[gridX][gridY];
    }

    public void start(int seed) {
        this.RANDOM.setSeed(seed);
        this.pause = false;
        this.turnstate = this.turnstate == 0 ? 2 : 0;
        this.scorePoint = 0;
        this.scoreLevel = 0;
        this.scoreLives = 0;
        this.hand = "empty";
        this.reward = new int[]{0, 0, 0, 0, 0, 0};
        this.selector.set(0, 0);
        this.activePlayer = 0;
        this.timeout = 0;
        this.resetGrid();
        this.start2();
    }

    public void update() {
        if (!this.pause) {
            this.frame = (this.frame + 1) % 48;
            this.updateMotion();
            this.updateLogic();
        }
    }

    public void load(CompoundNBT compound) {
        int[] baseValues = compound.func_74759_k("basevalues");
        this.turnstate = baseValues[0];
        this.scorePoint = baseValues[1];
        this.scoreLevel = baseValues[2];
        this.scoreLives = baseValues[3];
        this.selector.set(baseValues[4], baseValues[5]);
        this.activePlayer = baseValues[6];
        this.hand = compound.func_74779_i("hand");
        this.pause = compound.func_74767_n("pause");
        this.currentPlayer[0] = compound.func_74779_i("currentplayer0");
        this.currentPlayer[1] = compound.func_74779_i("currentplayer1");
        this.currentPlayer[2] = compound.func_74779_i("currentplayer2");
        this.currentPlayer[3] = compound.func_74779_i("currentplayer3");
        this.currentPlayer[4] = compound.func_74779_i("currentplayer4");
        this.currentPlayer[5] = compound.func_74779_i("currentplayer5");
        int[] array = compound.func_74759_k("grid");
        for (int y = 0; y < this.grid[0].length; ++y) {
            for (int x = 0; x < this.grid.length; ++x) {
                this.grid[x][y] = array[y * this.grid.length + x];
            }
        }
        if (this.hasHighscore()) {
            for (int i = 0; i < 20; ++i) {
                this.scoreHigh[i] = compound.func_74762_e("points" + i);
                this.scoreName[i] = compound.func_74779_i("name" + i);
            }
        }
        if (this.turnstate >= 2 && this.turnstate <= 5) {
            this.load2(compound);
        }
    }

    public CompoundNBT save(CompoundNBT compound) {
        compound.func_74783_a("basevalues", new int[]{this.turnstate, this.scorePoint, this.scoreLevel, this.scoreLives, this.selector.X, this.selector.Y, this.activePlayer});
        compound.func_74778_a("hand", this.hand);
        compound.func_74757_a("pause", this.pause);
        compound.func_74778_a("currentplayer0", this.currentPlayer[0]);
        compound.func_74778_a("currentplayer1", this.currentPlayer[1]);
        compound.func_74778_a("currentplayer2", this.currentPlayer[2]);
        compound.func_74778_a("currentplayer3", this.currentPlayer[3]);
        compound.func_74778_a("currentplayer4", this.currentPlayer[4]);
        compound.func_74778_a("currentplayer5", this.currentPlayer[5]);
        int[] array = new int[this.grid.length * this.grid[0].length];
        for (int y = 0; y < this.grid[0].length; ++y) {
            for (int x = 0; x < this.grid.length; ++x) {
                array[y * this.grid.length + x] = this.grid[x][y];
            }
        }
        compound.func_74783_a("grid", array);
        if (this.hasHighscore()) {
            for (int i = 0; i < 20; ++i) {
                compound.func_74768_a("points" + i, this.scoreHigh[i]);
                compound.func_74778_a("name" + i, this.scoreName[i]);
            }
        }
        if (this.turnstate >= 2 && this.turnstate <= 5) {
            this.save2(compound);
        }
        return compound;
    }

    protected Card[] loadCardArray(CompoundNBT compound, int index) {
        int[] array = compound.func_74759_k("cardstack" + index);
        Card[] cards = new Card[array.length / 3];
        for (int i = 0; i < array.length; i += 3) {
            cards[i / 3] = new Card(array[i], array[i + 1], array[i + 2] == 1);
        }
        return cards;
    }

    protected List<Card> loadCardList(CompoundNBT compound, int index) {
        int[] array = compound.func_74759_k("cardstack" + index);
        ArrayList<Card> cards = new ArrayList<Card>();
        for (int i = 0; i < array.length; i += 3) {
            cards.add(new Card(array[i], array[i + 1], array[i + 2] == 1));
        }
        return cards;
    }

    protected Dice[] loadDice(CompoundNBT compound) {
        int[] array = compound.func_74759_k("diceset");
        Dice[] dice = new Dice[array.length / 2];
        for (int i = 0; i < array.length; i += 2) {
            dice[i / 2] = new Dice(array[i], array[i + 1]);
        }
        return dice;
    }

    protected Ship loadEntity(CompoundNBT compound, int index) {
        int[] array = compound.func_74759_k("entity" + index);
        return new Ship(array[0], new Vector2(array[1], array[2]), new Vector2(array[3], array[4]), new Vector2(array[5], array[6]));
    }

    protected List<Ship> loadEntityList(CompoundNBT compound, int index) {
        int[] array = compound.func_74759_k("entitylist" + index);
        ArrayList<Ship> list = new ArrayList<Ship>();
        for (int i = 0; i < array.length; i += 7) {
            list.add(new Ship(array[i], new Vector2(array[i + 1], array[i + 2]), new Vector2(array[i + 3], array[i + 4]), new Vector2(array[i + 5], array[i + 6])));
        }
        return list;
    }

    protected CompoundNBT saveCardArray(CompoundNBT compound, int index, Card[] cards) {
        int[] array = new int[cards.length * 3];
        for (int pos = 0; pos < cards.length; ++pos) {
            array[pos * 3] = cards[pos].number;
            array[pos * 3 + 1] = cards[pos].suit;
            array[pos * 3 + 2] = cards[pos].hidden ? 1 : 0;
        }
        compound.func_74783_a("cardstack" + index, array);
        return compound;
    }

    protected CompoundNBT saveCardList(CompoundNBT compound, int index, List<Card> cards) {
        int[] array = new int[cards.size() * 3];
        for (int pos = 0; pos < cards.size(); ++pos) {
            array[pos * 3] = cards.get((int)pos).number;
            array[pos * 3 + 1] = cards.get((int)pos).suit;
            array[pos * 3 + 2] = cards.get((int)pos).hidden ? 1 : 0;
        }
        compound.func_74783_a("cardstack" + index, array);
        return compound;
    }

    protected CompoundNBT saveDice(CompoundNBT compound, Dice[] dice) {
        int[] array = new int[dice.length * 2];
        for (int pos = 0; pos < dice.length; ++pos) {
            array[pos * 2] = dice[pos].number;
            array[pos * 2 + 1] = dice[pos].color;
        }
        compound.func_74783_a("diceset", array);
        return compound;
    }

    protected CompoundNBT saveEntity(CompoundNBT compound, int index, Ship ent) {
        compound.func_74783_a("entity" + index, new int[]{ent.ai, ent.getPos().X, ent.getPos().Y, ent.getNext().X, ent.getNext().Y, ent.getVel().X, ent.getVel().Y});
        return compound;
    }

    protected CompoundNBT saveEntityList(CompoundNBT compound, int index, List<Ship> list) {
        int[] array = new int[list.size() * 7];
        for (int pos = 0; pos < list.size(); ++pos) {
            array[pos * 7] = list.get((int)pos).ai;
            array[pos * 7 + 1] = list.get((int)pos).getPos().X;
            array[pos * 7 + 2] = list.get((int)pos).getPos().Y;
            array[pos * 7 + 3] = list.get((int)pos).getNext().X;
            array[pos * 7 + 4] = list.get((int)pos).getNext().Y;
            array[pos * 7 + 5] = list.get((int)pos).getVel().X;
            array[pos * 7 + 6] = list.get((int)pos).getVel().Y;
        }
        compound.func_74783_a("entitylist" + index, array);
        return compound;
    }

    public void addScore(String name, int points) {
        int i;
        int pos = 20;
        for (i = 19; i >= 0; --i) {
            if (points <= this.scoreHigh[i]) continue;
            pos = i;
        }
        if (pos == 19) {
            this.scoreHigh[19] = points;
            this.scoreName[19] = name;
            this.scoreLast = 19;
        }
        if (pos < 19) {
            for (i = 18; i >= pos; --i) {
                this.scoreHigh[i + 1] = this.scoreHigh[i];
                this.scoreName[i + 1] = this.scoreName[i];
            }
            this.scoreHigh[pos] = points;
            this.scoreName[pos] = name;
        }
        this.scoreLast = pos;
    }

    private void setupHighscore() {
        this.scoreLast = 20;
        for (int i = 19; i >= 0; --i) {
            this.scoreHigh[i] = 0;
            this.scoreName[i] = "--------";
        }
    }

    protected void resetGrid() {
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                this.grid[i][j] = 0;
            }
        }
    }

    public void addPlayer(String newPlayer) {
        for (int i = 0; i < 6; ++i) {
            if (!this.currentPlayer[i].matches("void")) continue;
            this.currentPlayer[i] = newPlayer;
            break;
        }
    }

    public boolean hasFreePlayerSlots() {
        if (this.isMultiplayer()) {
            for (int i = 0; i < (this.tableID == 1 ? 4 : 6); ++i) {
                if (!this.currentPlayer[i].matches("void")) continue;
                return true;
            }
        } else {
            return this.currentPlayer[0].matches("void");
        }
        return false;
    }

    public int getFirstFreePlayerSlot() {
        if (this.isMultiplayer()) {
            for (int i = 0; i < (this.tableID == 1 ? 4 : 6); ++i) {
                if (!this.currentPlayer[i].matches("void")) continue;
                return i;
            }
        } else {
            return 0;
        }
        return 6;
    }

    public void removePlayer(String oldPlayer) {
        for (int i = 0; i < 6; ++i) {
            if (!this.currentPlayer[i].matches(oldPlayer)) continue;
            this.currentPlayer[i] = "void";
            break;
        }
    }

    public void resetPlayers() {
        for (int i = 0; i < 6; ++i) {
            this.currentPlayer[i] = "void";
        }
    }

    protected void setJingle(int i) {
        this.jingle = i;
    }

    public abstract void command(int var1);

    public abstract void updateMotion();

    public abstract void updateLogic();

    public abstract void start2();

    public abstract void load2(CompoundNBT var1);

    public abstract CompoundNBT save2(CompoundNBT var1);

    public abstract boolean hasHighscore();

    public abstract boolean isMultiplayer();

    public abstract int getID();
}

