/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundNBT;

public class LogicCardBlack
extends LogicBase {
    public List<Card> cards_player1 = new ArrayList<Card>();
    public List<Card> cards_player2 = new ArrayList<Card>();
    public List<Card> cards_dealer = new ArrayList<Card>();
    public int value_player1 = 0;
    public int value_player2 = 0;
    public int value_dealer = 0;
    public int split = 0;

    public LogicCardBlack(int table) {
        super(table);
    }

    @Override
    public void start2() {
        this.cards_player1.clear();
        this.cards_player2.clear();
        this.cards_dealer.clear();
        this.split = 0;
        this.cards_player1.add(new Card(this.RANDOM, -32, 0, 8, false));
        this.cards_player1.add(new Card(this.RANDOM, -48, 0, 32, false));
        this.cards_dealer.add(new Card(this.RANDOM, 0, -48, 8, false));
        this.cards_dealer.add(new Card(this.RANDOM, 0, -48, 32, true));
        this.setJingle(2);
        this.value_player1 = this.Add_Card(this.cards_player1, 0, 0, true);
        this.value_player2 = 0;
        this.value_dealer = this.Add_Card(this.cards_dealer, 0, 0, true);
        if (this.value_player1 == 21) {
            this.result();
            this.cards_dealer.get((int)1).hidden = false;
        }
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            if (this.split < 2) {
                this.value_player1 = this.Add_Card(this.cards_player1, -48, 0, false);
                if (this.value_player1 > 21) {
                    if (this.split == 0) {
                        this.result();
                    } else {
                        this.split = 2;
                    }
                }
            } else {
                this.value_player2 = this.Add_Card(this.cards_player2, -48, 0, false);
                if (this.value_player2 > 21) {
                    if (this.value_player1 > 21) {
                        this.result();
                    } else {
                        this.turnstate = 3;
                        this.cards_dealer.get((int)1).hidden = false;
                    }
                }
            }
        }
        if (action == 1) {
            if (this.split == 1) {
                this.split = 2;
            } else {
                this.turnstate = 3;
                this.cards_dealer.get((int)1).hidden = false;
            }
        }
        if (action == 2) {
            this.split = 1;
            int cardX = this.cards_player1.get((int)1).number;
            int cardY = this.cards_player1.get((int)1).suit;
            this.cards_player1.remove(1);
            this.cards_player1.add(new Card(this.RANDOM.nextInt(13), this.RANDOM.nextInt(4), -48, 0, 0, false));
            this.cards_player2.add(new Card(cardX, cardY, -32, 0, 8, false));
            this.cards_player2.add(new Card(this.RANDOM.nextInt(13), this.RANDOM.nextInt(4), -48, 0, 0, false));
            this.value_player1 = this.Add_Card(this.cards_player1, 0, 0, true);
            this.value_player2 = this.Add_Card(this.cards_player2, 0, 0, true);
            this.setJingle(2);
        }
        if (action == 3) {
            if (this.split < 2) {
                this.value_player1 = this.Add_Card(this.cards_player1, -48, 0, false);
                if (this.split == 1) {
                    this.split = 2;
                } else {
                    this.turnstate = 3;
                    this.cards_dealer.get((int)1).hidden = false;
                }
            } else {
                this.value_player2 = this.Add_Card(this.cards_player2, -48, 0, true);
                if (this.value_player1 > 21) {
                    this.result();
                } else {
                    this.turnstate = 3;
                    this.cards_dealer.get((int)1).hidden = false;
                }
            }
        }
    }

    @Override
    public void updateLogic() {
        if (this.turnstate == 3 && this.cards_player1.get((int)(this.cards_player1.size() - 1)).shiftY >= -16) {
            if (this.value_dealer > 16 || this.value_dealer > this.value_player1 && this.value_dealer > this.value_player2) {
                this.result();
            } else {
                this.value_dealer = this.Add_Card(this.cards_dealer, 0, -48, false);
            }
        }
    }

    @Override
    public void updateMotion() {
        if (this.cards_player1.size() > 0) {
            for (Card card : this.cards_player1) {
                card.update();
            }
        }
        if (this.cards_player2.size() > 0) {
            for (Card card : this.cards_player2) {
                card.update();
            }
        }
        if (this.cards_dealer.size() > 0) {
            for (Card card : this.cards_dealer) {
                card.update();
            }
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.cards_player1 = this.loadCardList(compound, 0);
        this.cards_player2 = this.loadCardList(compound, 1);
        this.cards_dealer = this.loadCardList(compound, 2);
        this.value_player1 = compound.func_74762_e("valueplayer1");
        this.value_player2 = compound.func_74762_e("valueplayer2");
        this.value_dealer = compound.func_74762_e("valuedealer");
        this.split = compound.func_74762_e("split");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveCardList(compound, 0, this.cards_player1);
        this.saveCardList(compound, 1, this.cards_player2);
        this.saveCardList(compound, 2, this.cards_dealer);
        compound.func_74768_a("valueplayer1", this.value_player1);
        compound.func_74768_a("valueplayer2", this.value_player2);
        compound.func_74768_a("valuedealer", this.value_dealer);
        compound.func_74768_a("split", this.split);
        return compound;
    }

    private void result() {
        this.turnstate = 4;
        if (this.value_dealer > 21) {
            this.hand = "The House gone bust!";
            this.reward[0] = 2;
        } else if (this.value_player1 > 21) {
            this.hand = "The Player gone bust!";
            this.reward[0] = 0;
        } else if (this.value_player1 == this.value_dealer && this.cards_player1.size() > this.cards_dealer.size()) {
            this.hand = "The House wins!";
            this.reward[0] = 0;
        } else if (this.value_player1 == this.value_dealer && this.cards_player1.size() == this.cards_dealer.size()) {
            this.hand = "DRAW";
            this.reward[0] = 1;
        } else if (this.value_player1 == 21 && this.cards_player1.size() == 2) {
            this.hand = "BLACK JACK";
            this.reward[0] = 3;
        } else if (this.value_player1 == this.value_dealer && this.cards_player1.size() < this.cards_dealer.size()) {
            this.hand = "The Player wins!";
            this.reward[0] = 2;
        } else if (this.value_player1 > this.value_dealer) {
            this.hand = "The Player wins!";
            this.reward[0] = 2;
        } else {
            this.hand = "The House wins!";
            this.reward[0] = 0;
        }
        if (this.split > 0) {
            if (this.value_dealer > 21) {
                this.hand = this.hand + " / The House gone bust!";
                this.reward[0] = this.reward[0] + 2;
            } else if (this.value_player2 > 21) {
                this.hand = this.hand + " / The Player gone bust!";
                this.reward[0] = this.reward[0] + 0;
            } else if (this.value_player2 == this.value_dealer && this.cards_player2.size() > this.cards_dealer.size()) {
                this.hand = this.hand + " / The House wins!";
                this.reward[0] = this.reward[0] + 0;
            } else if (this.value_player2 == this.value_dealer && this.cards_player2.size() == this.cards_dealer.size()) {
                this.hand = this.hand + " / DRAW";
                this.reward[0] = this.reward[0] + 1;
            } else if (this.value_player2 == 21 && this.cards_player2.size() == 2) {
                this.hand = this.hand + " / BLACK JACK";
                this.reward[0] = this.reward[0] + 3;
            } else if (this.value_player2 == this.value_dealer && this.cards_player2.size() < this.cards_dealer.size()) {
                this.hand = this.hand + " / The Player wins!";
                this.reward[0] = this.reward[0] + 2;
            } else if (this.value_player2 > this.value_dealer) {
                this.hand = this.hand + " / The Player wins!";
                this.reward[0] = this.reward[0] + 2;
            } else {
                this.hand = this.hand + " / The House wins!";
                this.reward[0] = this.reward[0] + 0;
            }
        }
        if (this.reward[0] >= 2) {
            this.jingle = 10;
        }
    }

    private int Add_Card(List<Card> cards, int shiftX, int shiftY, boolean noCard) {
        int value = 0;
        if (!noCard) {
            cards.add(new Card(this.RANDOM.nextInt(13), this.RANDOM.nextInt(4), shiftX, shiftY));
        }
        int ace = 0;
        for (Card card : cards) {
            if (card.number == 0) {
                ++ace;
                continue;
            }
            if (card.number <= 9) {
                value += card.number + 1;
                continue;
            }
            value += 10;
        }
        if (ace > 0) {
            while (ace > 0) {
                value = value <= 10 ? (value += 11) : ++value;
                --ace;
            }
        }
        this.jingle = 2;
        return value;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 0;
    }
}

