/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicCardBlue
extends LogicBase {
    public List<Card>[] cards_field = new ArrayList[8];
    public List<Card>[] cards_finish = new ArrayList[4];
    public Card[] cards_freecell = new Card[4];
    public int compress = 1;
    public int timer = 0;

    public LogicCardBlue(int table) {
        super(table);
    }

    @Override
    public void start2() {
        this.cards_field[0] = new ArrayList<Card>();
        this.cards_field[1] = new ArrayList<Card>();
        this.cards_field[2] = new ArrayList<Card>();
        this.cards_field[3] = new ArrayList<Card>();
        this.cards_field[4] = new ArrayList<Card>();
        this.cards_field[5] = new ArrayList<Card>();
        this.cards_field[6] = new ArrayList<Card>();
        this.cards_field[7] = new ArrayList<Card>();
        this.cards_finish[0] = new ArrayList<Card>();
        this.cards_finish[1] = new ArrayList<Card>();
        this.cards_finish[2] = new ArrayList<Card>();
        this.cards_finish[3] = new ArrayList<Card>();
        List<Card> deck = this.shuffleDeck();
        this.transferCards(this.cards_field[0], deck, 0, 7);
        this.transferCards(this.cards_field[1], deck, 1, 7);
        this.transferCards(this.cards_field[2], deck, 2, 7);
        this.transferCards(this.cards_field[3], deck, 3, 7);
        this.transferCards(this.cards_field[4], deck, 4, 6);
        this.transferCards(this.cards_field[5], deck, 5, 6);
        this.transferCards(this.cards_field[6], deck, 6, 6);
        this.transferCards(this.cards_field[7], deck, 7, 6);
        this.cards_freecell[0] = new Card(-1, -1);
        this.cards_freecell[1] = new Card(-1, -1);
        this.cards_freecell[2] = new Card(-1, -1);
        this.cards_freecell[3] = new Card(-1, -1);
        for (int x = 0; x < 8; ++x) {
            int y = 0;
            for (Card c : this.cards_field[x]) {
                c.setShift(0, -20 * y, 60 - 10 * y + x * 4);
                ++y;
            }
        }
        this.selector = new Vector2(-1, -1);
        this.compress = 2;
        this.timer = -1;
        this.setJingle(2);
    }

    @Override
    public void command(int action) {
        if (this.timer == -1) {
            if (action == -1) {
                this.freeCell(0);
            }
            if (action == -2) {
                this.freeCell(1);
            }
            if (action == -3) {
                this.freeCell(2);
            }
            if (action == -4) {
                this.freeCell(3);
            }
            if (action == -5) {
                this.touchFinish(0);
            }
            if (action == -6) {
                this.touchFinish(1);
            }
            if (action == -7) {
                this.touchFinish(2);
            }
            if (action == -8) {
                this.touchFinish(3);
            }
            if (action == 257) {
                this.timer = 1;
            }
            if (action >= 0) {
                this.touchField(action % 8, action / 8);
            }
        }
    }

    @Override
    public void updateLogic() {
        if (this.timer == 0) {
            boolean copy;
            int x2;
            int x1;
            --this.timer;
            boolean[] done = new boolean[4];
            done[3] = false;
            done[2] = false;
            done[1] = false;
            done[0] = false;
            for (x1 = 0; x1 < 4; ++x1) {
                if (this.cards_freecell[x1].suit == -1) continue;
                for (x2 = 0; x2 < 4; ++x2) {
                    copy = false;
                    if (this.cards_finish[x2].size() == 0) {
                        if (this.cards_freecell[x1].number == 0 && !done[x2]) {
                            copy = true;
                        }
                    } else if (this.cards_freecell[x1].number - 1 == this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).number && this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).suit == this.cards_freecell[x1].suit && !done[x2]) {
                        copy = true;
                    }
                    if (!copy) continue;
                    this.cards_freecell[x1].setShift(0, 16, 0);
                    this.cards_finish[x2].add(this.cards_freecell[x1]);
                    this.cards_freecell[x1] = new Card(-1, -1);
                    this.selector.set(-1, -1);
                    this.timer = 16;
                    done[x2] = true;
                }
            }
            for (x1 = 0; x1 < 8; ++x1) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.cards_field[x1].size() <= 0) continue;
                    copy = false;
                    if (this.cards_finish[x2].size() == 0) {
                        if (this.cards_field[x1].get((int)(this.cards_field[x1].size() - 1)).number == 0 && !done[x2]) {
                            copy = true;
                        }
                    } else if (this.cards_field[x1].get((int)(this.cards_field[x1].size() - 1)).number - 1 == this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).number && this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).suit == this.cards_field[x1].get((int)(this.cards_field[x1].size() - 1)).suit && !done[x2]) {
                        copy = true;
                    }
                    if (!copy) continue;
                    this.cards_field[x1].get(this.cards_field[x1].size() - 1).setShift(0, 16, 0);
                    this.cards_finish[x2].add(this.cards_field[x1].get(this.cards_field[x1].size() - 1));
                    this.cards_field[x1].remove(this.cards_finish[x1].size() - 1);
                    this.selector.set(-1, -1);
                    this.timer = 16;
                    done[x2] = true;
                }
            }
            this.compress();
        } else if (this.timer > 0) {
            --this.timer;
        }
        if (this.turnstate == 2 && this.cards_finish[0].size() == 13 && this.cards_finish[1].size() == 13 && this.cards_finish[2].size() == 13 && this.cards_finish[3].size() == 13 && this.turnstate < 4) {
            this.scorePoint = 100;
            this.turnstate = 4;
        }
    }

    @Override
    public void updateMotion() {
        int x;
        for (x = 0; x < 8; ++x) {
            if (this.cards_field[x].size() <= 0) continue;
            for (Card c : this.cards_field[x]) {
                c.update();
            }
        }
        for (x = 0; x < 4; ++x) {
            if (this.cards_finish[x].size() > 0) {
                for (Card c : this.cards_finish[x]) {
                    c.update();
                }
            }
            this.cards_freecell[x].update();
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.cards_field[0] = this.loadCardList(compound, 0);
        this.cards_field[1] = this.loadCardList(compound, 1);
        this.cards_field[2] = this.loadCardList(compound, 2);
        this.cards_field[3] = this.loadCardList(compound, 3);
        this.cards_field[4] = this.loadCardList(compound, 4);
        this.cards_field[5] = this.loadCardList(compound, 5);
        this.cards_field[6] = this.loadCardList(compound, 6);
        this.cards_field[7] = this.loadCardList(compound, 7);
        this.cards_finish[0] = this.loadCardList(compound, 8);
        this.cards_finish[1] = this.loadCardList(compound, 9);
        this.cards_finish[2] = this.loadCardList(compound, 10);
        this.cards_finish[3] = this.loadCardList(compound, 11);
        this.cards_freecell = this.loadCardArray(compound, 12);
        this.compress = compound.func_74762_e("compress");
        this.timer = compound.func_74762_e("timer");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveCardList(compound, 0, this.cards_field[0]);
        this.saveCardList(compound, 1, this.cards_field[1]);
        this.saveCardList(compound, 2, this.cards_field[2]);
        this.saveCardList(compound, 3, this.cards_field[3]);
        this.saveCardList(compound, 4, this.cards_field[4]);
        this.saveCardList(compound, 5, this.cards_field[5]);
        this.saveCardList(compound, 6, this.cards_field[6]);
        this.saveCardList(compound, 7, this.cards_field[7]);
        this.saveCardList(compound, 8, this.cards_finish[0]);
        this.saveCardList(compound, 9, this.cards_finish[1]);
        this.saveCardList(compound, 10, this.cards_finish[2]);
        this.saveCardList(compound, 11, this.cards_finish[3]);
        this.saveCardArray(compound, 12, this.cards_freecell);
        compound.func_74768_a("compress", this.compress);
        compound.func_74768_a("timer", this.timer);
        return compound;
    }

    private void transferCards(List<Card> cards, List<Card> deck, int position, int count) {
        for (int i = 0; i < count; ++i) {
            cards.add(deck.get(0));
            deck.remove(0);
        }
        this.setJingle(1);
    }

    private void transferCards(List<Card> cards_field2, List<Card> deck, int position, int count, int shiftX, int shiftY) {
        for (int i = position; i < position + count; ++i) {
            deck.get(position).setShift(shiftX, shiftY, 0);
            cards_field2.add(deck.get(position));
            deck.remove(position);
        }
        this.setJingle(1);
    }

    private List<Card> shuffleDeck() {
        ArrayList<Card> stack = new ArrayList<Card>();
        ArrayList<Card> deck = new ArrayList<Card>();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 13; ++x) {
                stack.add(new Card(x, y));
            }
        }
        while (stack.size() > 1) {
            int r = this.RANDOM.nextInt(stack.size() - 1);
            deck.add((Card)stack.get(r));
            stack.remove(r);
        }
        deck.add((Card)stack.get(0));
        return deck;
    }

    private void freeCell(int cell) {
        if (this.selector.matches(-1, -1)) {
            if (!this.cards_freecell[cell].equals(-1, -1)) {
                this.selector.set(cell, -2);
            }
        } else if (this.selector.Y >= 0 && this.cards_freecell[cell].suit == -1 && this.selector.Y == this.cards_field[this.selector.X].size() - 1) {
            this.cards_field[this.selector.X].get(this.cards_field[this.selector.X].size() - 1).setShift(0, 16, 0);
            this.cards_freecell[cell].set(this.cards_field[this.selector.X].get(this.cards_field[this.selector.X].size() - 1));
            this.cards_field[this.selector.X].remove(this.cards_field[this.selector.X].size() - 1);
            this.selector.set(-1, -1);
            this.setJingle(1);
        }
    }

    private void touchFinish(int slot) {
        if (!this.selector.matches(-1, -1)) {
            if (this.selector.Y == -2) {
                boolean copy = false;
                if (this.cards_finish[slot].size() == 0) {
                    if (this.cards_freecell[this.selector.X].number == 0) {
                        copy = true;
                    }
                } else if (this.cards_freecell[this.selector.X].number - 1 == this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).number && this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).suit == this.cards_freecell[this.selector.X].suit) {
                    copy = true;
                }
                if (copy) {
                    this.cards_freecell[this.selector.X].setShift(0, 16, 0);
                    this.cards_finish[slot].add(this.cards_freecell[this.selector.X]);
                    this.cards_freecell[this.selector.X] = new Card(-1, -1);
                    this.selector.set(-1, -1);
                    this.setJingle(1);
                }
            } else if (this.selector.Y == this.cards_field[this.selector.X].size() - 1) {
                boolean copy = false;
                if (this.cards_finish[slot].size() == 0) {
                    if (this.cards_field[this.selector.X].get((int)(this.cards_field[this.selector.X].size() - 1)).number == 0) {
                        copy = true;
                    }
                } else if (this.cards_field[this.selector.X].get((int)this.selector.Y).number - 1 == this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).number && this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).suit == this.cards_field[this.selector.X].get((int)this.selector.Y).suit) {
                    copy = true;
                }
                if (copy) {
                    this.cards_field[this.selector.X].get(this.cards_field[this.selector.X].size() - 1).setShift(0, 16, 0);
                    this.cards_finish[slot].add(this.cards_field[this.selector.X].get(this.cards_field[this.selector.X].size() - 1));
                    this.cards_field[this.selector.X].remove(this.cards_field[this.selector.X].size() - 1);
                    this.selector.set(-1, -1);
                    this.setJingle(1);
                }
            }
        }
        this.compress();
    }

    private void touchField(int x, int y) {
        int x2 = x;
        int y2 = y;
        if (this.selector.Y == -2) {
            if (!this.moveStack(x, y)) {
                this.selector.set(-1, -1);
            }
        } else if (this.cards_field[x2].size() >= y2 - 1) {
            if (this.selector.matches(-1, -1)) {
                y2 = this.cards_field[x2].size() <= y2 ? this.cards_field[x2].size() - 1 : y2;
                float tempCard = this.cards_field[x2].get((int)y2).number;
                float tempSuit = this.cards_field[x2].get((int)y2).suit;
                for (int i = y2; i < this.cards_field[x2].size(); ++i) {
                    if (i == this.cards_field[x2].size() - 1 || (this.cards_field[x2].get((int)i).number - 1 == this.cards_field[x2].get((int)(i + 1)).number || this.cards_field[x2].get((int)i).number == 1 && this.cards_field[x2].get((int)(i + 1)).number == 13) && this.differentColors(this.cards_field[x2].get((int)i).suit, this.cards_field[x2].get((int)(i + 1)).suit)) continue;
                    return;
                }
                this.selector.set(x2, y2);
            } else if (!this.moveStack(x, y)) {
                this.selector.set(-1, -1);
            }
        }
        this.compress();
    }

    private boolean moveStack(int x, int y) {
        int x2 = x;
        int y2 = this.cards_field[x2].size() - 1;
        if (this.selector.Y != -2) {
            if (this.cards_field[x2].size() == 0 || this.cards_field[this.selector.X].get((int)this.selector.Y).number + 1 == this.cards_field[x2].get((int)y2).number && this.differentColors(this.cards_field[x2].get((int)y2).suit, this.cards_field[this.selector.X].get((int)this.selector.Y).suit)) {
                this.transferCards(this.cards_field[x2], this.cards_field[this.selector.X], this.selector.Y, this.cards_field[this.selector.X].size() - this.selector.Y, 0, 16);
                this.selector.set(-1, -1);
                return true;
            }
        } else if (this.cards_field[x2].size() == 0 || this.cards_freecell[this.selector.X].number + 1 == this.cards_field[x2].get((int)y2).number && this.differentColors(this.cards_field[x2].get((int)y2).suit, this.cards_freecell[this.selector.X].suit)) {
            this.cards_freecell[this.selector.X].setShift(0, 16, 0);
            this.cards_field[x2].add(new Card(this.cards_freecell[this.selector.X]));
            this.cards_freecell[this.selector.X].set(-1, -1);
            this.selector.set(-1, -1);
            return true;
        }
        return false;
    }

    private void compress() {
        int i = 0;
        for (int x = 0; x < 8; ++x) {
            if (this.cards_field[x].size() <= i) continue;
            i = this.cards_field[x].size();
        }
        this.compress = i > 6 ? i - 3 : 0;
    }

    private boolean differentColors(float a, float b) {
        if (!(a != 0.0f && a != 1.0f || b != 2.0f && b != 3.0f)) {
            return true;
        }
        if (a == 2.0f || a == 3.0f) {
            return b == 0.0f || b == 1.0f;
        }
        return false;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 1;
    }
}

