/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicCardCyan
extends LogicBase {
    public List<Card>[] cards_field = new ArrayList[10];
    public List<Card>[] cards_reserve = new ArrayList[5];
    public List<Card> cards_finish = new ArrayList<Card>();
    public int compress = 4;

    public LogicCardCyan(int table) {
        super(table);
    }

    @Override
    public void start2() {
        List<Card> deck = this.shuffleDeck();
        this.cards_field[0] = new ArrayList<Card>();
        this.transferCards(this.cards_field[0], deck, 0, 6);
        this.cards_field[1] = new ArrayList<Card>();
        this.transferCards(this.cards_field[1], deck, 0, 6);
        this.cards_field[2] = new ArrayList<Card>();
        this.transferCards(this.cards_field[2], deck, 0, 6);
        this.cards_field[3] = new ArrayList<Card>();
        this.transferCards(this.cards_field[3], deck, 0, 6);
        this.cards_field[4] = new ArrayList<Card>();
        this.transferCards(this.cards_field[4], deck, 0, 5);
        this.cards_field[5] = new ArrayList<Card>();
        this.transferCards(this.cards_field[5], deck, 0, 5);
        this.cards_field[6] = new ArrayList<Card>();
        this.transferCards(this.cards_field[6], deck, 0, 5);
        this.cards_field[7] = new ArrayList<Card>();
        this.transferCards(this.cards_field[7], deck, 0, 5);
        this.cards_field[8] = new ArrayList<Card>();
        this.transferCards(this.cards_field[8], deck, 0, 5);
        this.cards_field[9] = new ArrayList<Card>();
        this.transferCards(this.cards_field[9], deck, 0, 5);
        this.cards_reserve[0] = new ArrayList<Card>();
        this.transferCards(this.cards_reserve[0], deck, 0, 10);
        this.cards_reserve[1] = new ArrayList<Card>();
        this.transferCards(this.cards_reserve[1], deck, 0, 10);
        this.cards_reserve[2] = new ArrayList<Card>();
        this.transferCards(this.cards_reserve[2], deck, 0, 10);
        this.cards_reserve[3] = new ArrayList<Card>();
        this.transferCards(this.cards_reserve[3], deck, 0, 10);
        this.cards_reserve[4] = new ArrayList<Card>();
        this.transferCards(this.cards_reserve[4], deck, 0, 10);
        this.selector = new Vector2(-1, -1);
        this.compress = 2;
        for (int x = 0; x < 10; ++x) {
            int y = 0;
            for (Card c : this.cards_field[x]) {
                c.setShift(0, -24 * y, 70 - 10 * y + x * 3);
                ++y;
            }
        }
        this.setJingle(2);
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.drawReserve();
        }
        if (action >= 0) {
            this.touchField(action % 10, action / 10);
        }
    }

    @Override
    public void updateLogic() {
        for (int x = 0; x < 10; ++x) {
            if (this.cards_field[x].size() <= 0) continue;
            for (Card c : this.cards_field[x]) {
                c.update();
            }
        }
        if (this.cards_finish.size() == 8 && this.turnstate < 4) {
            this.scorePoint = 100;
            this.turnstate = 4;
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.cards_field[0] = this.loadCardList(compound, 0);
        this.cards_field[1] = this.loadCardList(compound, 1);
        this.cards_field[2] = this.loadCardList(compound, 2);
        this.cards_field[3] = this.loadCardList(compound, 3);
        this.cards_field[4] = this.loadCardList(compound, 4);
        this.cards_field[5] = this.loadCardList(compound, 5);
        this.cards_field[6] = this.loadCardList(compound, 6);
        this.cards_field[7] = this.loadCardList(compound, 7);
        this.cards_field[8] = this.loadCardList(compound, 8);
        this.cards_field[9] = this.loadCardList(compound, 9);
        this.cards_reserve[0] = this.loadCardList(compound, 10);
        this.cards_reserve[1] = this.loadCardList(compound, 11);
        this.cards_reserve[2] = this.loadCardList(compound, 12);
        this.cards_reserve[3] = this.loadCardList(compound, 13);
        this.cards_reserve[4] = this.loadCardList(compound, 14);
        this.cards_finish.addAll(this.loadCardList(compound, 15));
        this.compress = compound.func_74762_e("compress");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveCardList(compound, 0, this.cards_field[0]);
        this.saveCardList(compound, 1, this.cards_field[1]);
        this.saveCardList(compound, 2, this.cards_field[2]);
        this.saveCardList(compound, 3, this.cards_field[3]);
        this.saveCardList(compound, 4, this.cards_field[4]);
        this.saveCardList(compound, 5, this.cards_field[5]);
        this.saveCardList(compound, 6, this.cards_field[6]);
        this.saveCardList(compound, 7, this.cards_field[7]);
        this.saveCardList(compound, 8, this.cards_field[8]);
        this.saveCardList(compound, 9, this.cards_field[9]);
        this.saveCardList(compound, 10, this.cards_reserve[0]);
        this.saveCardList(compound, 11, this.cards_reserve[1]);
        this.saveCardList(compound, 12, this.cards_reserve[2]);
        this.saveCardList(compound, 13, this.cards_reserve[3]);
        this.saveCardList(compound, 14, this.cards_reserve[4]);
        this.saveCardList(compound, 15, this.cards_finish);
        compound.func_74768_a("compress", this.compress);
        return compound;
    }

    private void transferCards(List<Card> cards_field2, List<Card> deck, int position, int count) {
        for (int i = position; i < position + count; ++i) {
            cards_field2.add(deck.get(position));
            deck.remove(position);
            this.setJingle(1);
        }
    }

    private void transferCards(List<Card> cards_field2, List<Card> deck, int position, int count, int shiftX, int shiftY) {
        for (int i = position; i < position + count; ++i) {
            deck.get(position).setShift(shiftX, shiftY, 0);
            cards_field2.add(deck.get(position));
            deck.remove(position);
            this.setJingle(1);
        }
    }

    private List<Card> shuffleDeck() {
        ArrayList<Card> stack = new ArrayList<Card>();
        ArrayList<Card> deck = new ArrayList<Card>();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 13; ++x) {
                stack.add(new Card(x, y));
                stack.add(new Card(x, y));
            }
        }
        while (stack.size() > 1) {
            int r = this.RANDOM.nextInt(stack.size() - 1);
            deck.add((Card)stack.get(r));
            stack.remove(r);
        }
        deck.add((Card)stack.get(0));
        return deck;
    }

    private void drawReserve() {
        if (this.cards_reserve[0].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[0].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[0].get(x));
                this.setJingle(2);
            }
            this.cards_reserve[0].clear();
        } else if (this.cards_reserve[1].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[1].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[1].get(x));
                this.setJingle(2);
            }
            this.cards_reserve[1].clear();
        } else if (this.cards_reserve[2].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[2].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[2].get(x));
                this.setJingle(2);
            }
            this.cards_reserve[2].clear();
        } else if (this.cards_reserve[3].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[3].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[3].get(x));
                this.setJingle(2);
            }
            this.cards_reserve[3].clear();
        } else if (this.cards_reserve[4].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[4].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[4].get(x));
                this.setJingle(2);
            }
            this.cards_reserve[4].clear();
        }
    }

    private void touchField(int x, int y) {
        if (this.cards_field[x].size() >= y - 1) {
            if (this.selector.matches(-1, -1)) {
                int x2 = x;
                int y2 = this.cards_field[x].size() <= y ? this.cards_field[x].size() - 1 : y;
                float tempCard = this.cards_field[x2].get((int)y2).number;
                for (int i = y2; i < this.cards_field[x2].size(); ++i) {
                    if (i == this.cards_field[x2].size() - 1 || this.cards_field[x2].get((int)i).number - 1 == this.cards_field[x2].get((int)(i + 1)).number || this.cards_field[x2].get((int)i).number == 1 && this.cards_field[x2].get((int)(i + 1)).number == 13) continue;
                    return;
                }
                this.selector.set(x2, y2);
            } else if (!this.moveStack(x, y)) {
                this.selector.set(-1, -1);
            }
        }
        this.compress();
    }

    private boolean moveStack(int x, int y) {
        int x2 = x;
        int y2 = this.cards_field[x2].size() - 1;
        if (this.cards_field[x2].size() == 0) {
            this.transferCards(this.cards_field[x2], this.cards_field[this.selector.X], this.selector.Y, this.cards_field[this.selector.X].size() - this.selector.Y, 0, 16);
            this.selector.set(-1, -1);
            this.clearRow(x2);
            this.setJingle(1);
            return true;
        }
        if (this.cards_field[this.selector.X].get((int)this.selector.Y).number + 1 == this.cards_field[x2].get((int)y2).number) {
            this.transferCards(this.cards_field[x2], this.cards_field[this.selector.X], this.selector.Y, this.cards_field[this.selector.X].size() - this.selector.Y, 0, 16);
            this.selector.set(-1, -1);
            this.clearRow(x2);
            this.setJingle(1);
            return true;
        }
        return false;
    }

    private void clearRow(int row) {
        if (this.cards_field[row].size() >= 13) {
            block0: for (int i = 0; i < this.cards_field[row].size(); ++i) {
                if (this.cards_field[row].get((int)i).number != 12) continue;
                for (int j = 0; j < this.cards_field[row].size() - 1; ++j) {
                    if (12 - j == 0 && this.cards_field[row].get((int)(i + j)).number == 13 && this.cards_field[row].get((int)i).suit == this.cards_field[row].get((int)(i + j)).suit) {
                        this.cards_finish.add(this.cards_field[row].get(this.cards_field[row].size() - 1));
                        for (int z = this.cards_field[row].size() - 13; z < this.cards_field[row].size() - 13; ++z) {
                            this.cards_field[row].remove(z);
                        }
                        return;
                    }
                    if (12 - j != this.cards_field[row].get((int)(i + j)).number || this.cards_field[row].get((int)i).suit != this.cards_field[row].get((int)(i + j)).suit) continue block0;
                }
            }
        }
    }

    private void compress() {
        int i = 0;
        for (int x = 0; x < 8; ++x) {
            if (this.cards_field[x].size() <= i) continue;
            i = this.cards_field[x].size();
        }
        this.compress = i > 8 ? i - 5 : 0;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 3;
    }
}

