/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.chip;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicChipCyan
extends LogicBase {
    public boolean active_hold;
    public int[] container_next = new int[3];
    public int[] container_hold = new int[3];
    public int[] container_current = new int[3];
    public double time_last;
    public double time_break;
    public int timer;
    public Vector2[] tromino = new Vector2[]{new Vector2(0, 0), new Vector2(0, 0), new Vector2(0, 0)};
    public List<Vector2> clear = new ArrayList<Vector2>();
    public int alpha;

    public LogicChipCyan(int tableID) {
        super(tableID, 6, 15);
    }

    @Override
    public void start2() {
        this.active_hold = true;
        this.container_next[0] = this.Column_Roll();
        this.container_next[1] = this.Column_Roll();
        this.container_next[2] = this.Column_Roll();
        this.container_hold[0] = -1;
        this.container_hold[1] = -1;
        this.container_hold[2] = -1;
        this.container_current[0] = this.Column_Roll();
        this.container_current[1] = this.Column_Roll();
        this.container_current[2] = this.Column_Roll();
        this.Column_Create();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.grid[i][j] = -1;
            }
        }
        this.time_break = 200.0;
        this.time_last = 0.0;
        this.clear.clear();
        this.alpha = 255;
    }

    @Override
    public void command(int action) {
        if (action == 265) {
            this.commandCycle(true);
        }
        if (action == 264) {
            this.columnDrop();
        }
        if (action == 263) {
            this.commandStrafe(true);
        }
        if (action == 262) {
            this.commandStrafe(false);
        }
        if (action == 257) {
            this.commandHold();
        }
    }

    @Override
    public void updateLogic() {
        this.timer += 15;
        if (this.alpha == 255) {
            if ((double)this.timer > this.time_last + this.time_break - (double)(this.scoreLevel * 5) && this.turnstate == 2) {
                this.columnFall();
                this.time_last = this.timer;
            }
        } else {
            this.alpha -= 10;
            if (this.alpha <= 0) {
                this.alpha = 255;
                for (int y = 0; y < 15; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        if (!this.isCleared(x, y)) continue;
                        this.grid[x][y] = -1;
                    }
                }
                this.setJingle(12);
                this.commandCollapse();
            }
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.active_hold = compound.func_74767_n("activehold");
        this.container_next[0] = compound.func_74762_e("container_next0");
        this.container_next[1] = compound.func_74762_e("container_next1");
        this.container_next[2] = compound.func_74762_e("container_next2");
        this.container_hold[0] = compound.func_74762_e("container_hold0");
        this.container_hold[1] = compound.func_74762_e("container_hold1");
        this.container_hold[2] = compound.func_74762_e("container_hold2");
        this.container_current[0] = compound.func_74762_e("container_current0");
        this.container_current[1] = compound.func_74762_e("container_current1");
        this.container_current[2] = compound.func_74762_e("container_current2");
        this.time_last = compound.func_74769_h("timelast");
        this.time_break = compound.func_74769_h("timebreak");
        this.timer = compound.func_74762_e("timer");
        this.tromino[0].set(compound.func_74762_e("tromino0x"), compound.func_74762_e("tromino0y"));
        this.tromino[1].set(compound.func_74762_e("tromino1x"), compound.func_74762_e("tromino1y"));
        this.tromino[2].set(compound.func_74762_e("tromino2x"), compound.func_74762_e("tromino2y"));
        this.alpha = compound.func_74762_e("alpha");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        compound.func_74757_a("activehold", this.active_hold);
        compound.func_74768_a("container_next0", this.container_next[0]);
        compound.func_74768_a("container_next1", this.container_next[1]);
        compound.func_74768_a("container_next2", this.container_next[2]);
        compound.func_74768_a("container_hold0", this.container_hold[0]);
        compound.func_74768_a("container_hold1", this.container_hold[1]);
        compound.func_74768_a("container_hold2", this.container_hold[2]);
        compound.func_74768_a("container_current0", this.container_current[0]);
        compound.func_74768_a("container_current1", this.container_current[1]);
        compound.func_74768_a("container_current2", this.container_current[2]);
        compound.func_74780_a("timelast", this.time_last);
        compound.func_74780_a("timebreak", this.time_break);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("tromino0x", this.tromino[0].X);
        compound.func_74768_a("tromino0y", this.tromino[0].Y);
        compound.func_74768_a("tromino1x", this.tromino[1].X);
        compound.func_74768_a("tromino1y", this.tromino[1].Y);
        compound.func_74768_a("tromino2x", this.tromino[2].X);
        compound.func_74768_a("tromino2y", this.tromino[2].Y);
        compound.func_74768_a("alpha", this.alpha);
        return compound;
    }

    public boolean inLine(int x, int y) {
        for (Vector2 v : this.clear) {
            if (!v.matches(x, y)) continue;
            return true;
        }
        return false;
    }

    private void columnDrop() {
        int tempPoint = this.scorePoint;
        while (this.scorePoint == tempPoint) {
            this.columnFall();
        }
    }

    private boolean isCleared(int x, int y) {
        for (int i = 0; i < this.clear.size(); ++i) {
            if (this.clear.get((int)i).X != x || this.clear.get((int)i).Y != y) continue;
            return true;
        }
        return false;
    }

    private void commandCollapse() {
        boolean temp = false;
        boolean falling = true;
        for (int x = 0; x < 6; ++x) {
            block1: for (int y = 14; y >= 1; --y) {
                if (this.grid[x][y] != -1) continue;
                for (int y2 = y - 1; y2 >= 0; --y2) {
                    if (this.grid[x][y2] == -1) continue;
                    this.grid[x][y] = this.grid[x][y2];
                    this.grid[x][y2] = -1;
                    continue block1;
                }
            }
        }
        this.clear.clear();
        this.alpha = 255;
        this.checkField();
    }

    private void commandStrafe(boolean totheleft) {
        int dir = 0;
        if (totheleft) {
            dir = -1;
            if (this.tromino[0].X > 0 && this.tromino[1].X > 0 && this.tromino[2].X > 0 && this.grid[this.tromino[0].X + dir][this.tromino[0].Y] == -1 && this.grid[this.tromino[1].X + dir][this.tromino[1].Y] == -1 && this.grid[this.tromino[2].X + dir][this.tromino[2].Y] == -1) {
                this.tromino[0].X += dir;
                this.tromino[1].X += dir;
                this.tromino[2].X += dir;
            }
        } else {
            dir = 1;
            if (this.tromino[0].X < 5 && this.tromino[1].X < 5 && this.tromino[2].X < 5 && this.grid[this.tromino[0].X + dir][this.tromino[0].Y] == -1 && this.grid[this.tromino[1].X + dir][this.tromino[1].Y] == -1 && this.grid[this.tromino[2].X + dir][this.tromino[2].Y] == -1) {
                this.tromino[0].X += dir;
                this.tromino[1].X += dir;
                this.tromino[2].X += dir;
            }
        }
    }

    private void commandCycle(boolean totheleft) {
        if (totheleft) {
            int temp = this.container_current[0];
            this.container_current[0] = this.container_current[1];
            this.container_current[1] = this.container_current[2];
            this.container_current[2] = temp;
        } else {
            int temp = this.container_current[2];
            this.container_current[2] = this.container_current[1];
            this.container_current[1] = this.container_current[0];
            this.container_current[0] = temp;
        }
    }

    private void commandHold() {
        if (this.active_hold) {
            this.active_hold = false;
            if (this.container_hold[0] == -1) {
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_hold[2] = this.container_current[2];
                this.container_current[0] = this.container_next[0];
                this.container_current[1] = this.container_next[1];
                this.container_current[2] = this.container_next[2];
                this.container_next[0] = this.Column_Roll();
                this.container_next[1] = this.Column_Roll();
                this.container_next[2] = this.Column_Roll();
            } else {
                int[] temp = new int[]{this.container_hold[0], this.container_hold[1], this.container_hold[2]};
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_hold[2] = this.container_current[2];
                this.container_current[0] = temp[0];
                this.container_current[1] = temp[1];
                this.container_current[2] = temp[2];
            }
            this.Column_Create();
        }
    }

    private int Column_Roll() {
        int r = this.RANDOM.nextInt(6) + 1;
        return r >= 3 ? r + 1 : r;
    }

    private void Column_Create() {
        this.tromino[0] = new Vector2(2, 0);
        this.tromino[1] = new Vector2(2, 1);
        this.tromino[2] = new Vector2(2, 2);
        this.setJingle(5);
    }

    private void columnFall() {
        if (this.tromino[0].Y < 14 && this.tromino[1].Y < 14 && this.tromino[2].Y < 14) {
            if (this.grid[this.tromino[0].X][this.tromino[0].Y + 1] == -1 && this.grid[this.tromino[1].X][this.tromino[1].Y + 1] == -1 && this.grid[this.tromino[2].X][this.tromino[2].Y + 1] == -1) {
                ++this.tromino[0].Y;
                ++this.tromino[1].Y;
                ++this.tromino[2].Y;
            } else {
                this.columnPlace();
            }
        } else {
            this.columnPlace();
        }
    }

    private void columnPlace() {
        this.active_hold = true;
        this.grid[this.tromino[0].X][this.tromino[0].Y] = this.container_current[0];
        this.grid[this.tromino[1].X][this.tromino[1].Y] = this.container_current[1];
        this.grid[this.tromino[2].X][this.tromino[2].Y] = this.container_current[2];
        this.scorePoint += 4;
        if (this.tromino[0].Y == 0) {
            this.turnstate = 4;
        }
        this.container_current[0] = this.container_next[0];
        this.container_current[1] = this.container_next[1];
        this.container_current[2] = this.container_next[2];
        this.container_next[0] = this.Column_Roll();
        this.container_next[1] = this.Column_Roll();
        this.container_next[2] = this.Column_Roll();
        this.Column_Create();
        this.checkField();
    }

    private void checkField() {
        int points = 0;
        int bonus = 0;
        for (int y = 14; y >= 0; --y) {
            for (int x = 0; x < 6; ++x) {
                if (x < 4 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x + 1][y] && this.grid[x][y] == this.grid[x + 2][y]) {
                    this.clear.add(new Vector2(x, y));
                    this.clear.add(new Vector2(x + 1, y));
                    this.clear.add(new Vector2(x + 2, y));
                    points += 30 + bonus;
                    bonus += 10;
                }
                if (y > 1 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x][y - 1] && this.grid[x][y] == this.grid[x][y - 2]) {
                    this.clear.add(new Vector2(x, y));
                    this.clear.add(new Vector2(x, y - 1));
                    this.clear.add(new Vector2(x, y - 2));
                    points += 30 + bonus;
                    bonus += 10;
                }
                if (x < 4 && y > 1 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x + 1][y - 1] && this.grid[x][y] == this.grid[x + 2][y - 2]) {
                    this.clear.add(new Vector2(x, y));
                    this.clear.add(new Vector2(x + 1, y - 1));
                    this.clear.add(new Vector2(x + 2, y - 2));
                    points += 30 + bonus;
                    bonus += 10;
                }
                if (x >= 4 || y >= 13 || this.grid[x][y] == -1 || this.grid[x][y] != this.grid[x + 1][y + 1] || this.grid[x][y] != this.grid[x + 2][y + 2]) continue;
                this.clear.add(new Vector2(x, y));
                this.clear.add(new Vector2(x + 1, y + 1));
                this.clear.add(new Vector2(x + 2, y + 2));
                points += 30 + bonus;
                bonus += 10;
            }
        }
        if (points > 0) {
            this.alpha -= 5;
            this.scorePoint += points * 2 * (this.scoreLevel + 1);
            ++this.scoreLives;
            if (this.scoreLives > (1 + this.scoreLevel) * 10) {
                ++this.scoreLevel;
                this.time_break -= this.time_break / 10.0;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 19;
    }
}

