/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.chip;

import mod.casinocraft.logic.LogicBase;
import net.minecraft.nbt.CompoundNBT;

public class LogicChipLightGray
extends LogicBase {
    public boolean placing = false;
    public boolean timerActive = false;
    public int timer = 0;
    public int direction = 0;

    public LogicChipLightGray(int tableID) {
        super(tableID, 4, 4);
    }

    @Override
    public void start2() {
        this.placing = false;
        this.grid[0][0] = this.RANDOM.nextInt(1) + 1;
        this.grid[3][0] = this.RANDOM.nextInt(1) + 1;
        this.grid[0][3] = this.RANDOM.nextInt(1) + 1;
        this.grid[3][3] = this.RANDOM.nextInt(1) + 1;
        this.timerActive = false;
        this.timer = 0;
        this.direction = 0;
    }

    @Override
    public void command(int action) {
        if (action == 265) {
            this.move(1);
        }
        if (action == 264) {
            this.move(2);
        }
        if (action == 263) {
            this.move(3);
        }
        if (action == 262) {
            this.move(4);
        }
    }

    @Override
    public void updateLogic() {
        if (this.timerActive) {
            this.timer += 16;
            if (this.timer == 48) {
                this.timerActive = false;
                this.timer = 0;
                this.change();
                this.move(this.direction);
                this.placing = true;
            }
        } else {
            if (this.placing) {
                this.place();
                this.placing = false;
            }
            this.direction = 0;
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.placing = compound.func_74767_n("placing");
        this.timerActive = compound.func_74767_n("timeractive");
        this.timer = compound.func_74762_e("timer");
        this.direction = compound.func_74762_e("direction");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        compound.func_74757_a("placing", this.placing);
        compound.func_74757_a("timeractive", this.timerActive);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("direction", this.direction);
        return compound;
    }

    private void move(int s) {
        int y;
        int x;
        int x2;
        int y2;
        if (s == 1) {
            for (y2 = 1; y2 < 4; ++y2) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.grid[x2][y2] == 0 || this.grid[x2][y2 - 1] != 0 && this.grid[x2][y2 - 1] != this.grid[x2][y2]) continue;
                    int[] nArray = this.grid[x2];
                    int n = y2;
                    nArray[n] = nArray[n] + 100;
                    this.timerActive = true;
                    this.direction = s;
                }
            }
        }
        if (s == 2) {
            for (y2 = 2; y2 > -1; --y2) {
                for (x2 = 3; x2 > -1; --x2) {
                    if (this.grid[x2][y2] == 0 || this.grid[x2][y2 + 1] != 0 && this.grid[x2][y2 + 1] != this.grid[x2][y2]) continue;
                    int[] nArray = this.grid[x2];
                    int n = y2;
                    nArray[n] = nArray[n] + 100;
                    this.timerActive = true;
                    this.direction = s;
                }
            }
        }
        if (s == 3) {
            for (x = 1; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (this.grid[x][y] == 0 || this.grid[x - 1][y] != 0 && this.grid[x - 1][y] != this.grid[x][y]) continue;
                    int[] nArray = this.grid[x];
                    int n = y;
                    nArray[n] = nArray[n] + 100;
                    this.timerActive = true;
                    this.direction = s;
                }
            }
        }
        if (s == 4) {
            for (x = 2; x > -1; --x) {
                for (y = 3; y > -1; --y) {
                    if (this.grid[x][y] == 0 || this.grid[x + 1][y] != 0 && this.grid[x + 1][y] != this.grid[x][y]) continue;
                    int[] nArray = this.grid[x];
                    int n = y;
                    nArray[n] = nArray[n] + 100;
                    this.timerActive = true;
                    this.direction = s;
                }
            }
        }
    }

    private void change() {
        int y;
        int x;
        int x2;
        int y2;
        if (this.direction == 1) {
            for (y2 = 1; y2 < 4; ++y2) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.grid[x2][y2] < 100) continue;
                    int[] nArray = this.grid[x2];
                    int n = y2;
                    nArray[n] = nArray[n] - 100;
                    if (this.grid[x2][y2 - 1] == 0) {
                        this.grid[x2][y2 - 1] = this.grid[x2][y2];
                    } else {
                        this.grid[x2][y2 - 1] = this.grid[x2][y2 - 1] + 1;
                        this.addPoints(this.grid[x2][y2 - 1]);
                    }
                    this.grid[x2][y2] = 0;
                }
            }
        }
        if (this.direction == 2) {
            for (y2 = 2; y2 > -1; --y2) {
                for (x2 = 3; x2 > -1; --x2) {
                    if (this.grid[x2][y2] < 100) continue;
                    int[] nArray = this.grid[x2];
                    int n = y2;
                    nArray[n] = nArray[n] - 100;
                    if (this.grid[x2][y2 + 1] == 0) {
                        this.grid[x2][y2 + 1] = this.grid[x2][y2];
                    } else {
                        this.grid[x2][y2 + 1] = this.grid[x2][y2 + 1] + 1;
                        this.addPoints(this.grid[x2][y2 + 1]);
                    }
                    this.grid[x2][y2] = 0;
                }
            }
        }
        if (this.direction == 3) {
            for (x = 1; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (this.grid[x][y] < 100) continue;
                    int[] nArray = this.grid[x];
                    int n = y;
                    nArray[n] = nArray[n] - 100;
                    if (this.grid[x - 1][y] == 0) {
                        this.grid[x - 1][y] = this.grid[x][y];
                    } else {
                        this.grid[x - 1][y] = this.grid[x - 1][y] + 1;
                        this.addPoints(this.grid[x - 1][y]);
                    }
                    this.grid[x][y] = 0;
                }
            }
        }
        if (this.direction == 4) {
            for (x = 2; x > -1; --x) {
                for (y = 3; y > -1; --y) {
                    if (this.grid[x][y] < 100) continue;
                    int[] nArray = this.grid[x];
                    int n = y;
                    nArray[n] = nArray[n] - 100;
                    if (this.grid[x + 1][y] == 0) {
                        this.grid[x + 1][y] = this.grid[x][y];
                    } else {
                        this.grid[x + 1][y] = this.grid[x + 1][y] + 1;
                        this.addPoints(this.grid[x + 1][y]);
                    }
                    this.grid[x][y] = 0;
                }
            }
        }
    }

    private void place() {
        for (int i = 0; i < 24; ++i) {
            int y;
            int x = this.RANDOM.nextInt(4);
            if (this.grid[x][y = this.RANDOM.nextInt(4)] != 0) continue;
            this.grid[x][y] = 1;
            break;
        }
        this.check();
    }

    private void check() {
        int y;
        int x;
        int x2;
        int y2;
        boolean b = false;
        for (y2 = 1; y2 < 4; ++y2) {
            for (x2 = 0; x2 < 4; ++x2) {
                if (this.grid[x2][y2] == 0 || this.grid[x2][y2 - 1] != 0 && this.grid[x2][y2 - 1] != this.grid[x2][y2]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (y2 = 2; y2 > -1; --y2) {
            for (x2 = 3; x2 > -1; --x2) {
                if (this.grid[x2][y2] == 0 || this.grid[x2][y2 + 1] != 0 && this.grid[x2][y2 + 1] != this.grid[x2][y2]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (x = 1; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                if (this.grid[x][y] == 0 || this.grid[x - 1][y] != 0 && this.grid[x - 1][y] != this.grid[x][y]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (x = 2; x > -1; --x) {
            for (y = 3; y > -1; --y) {
                if (this.grid[x][y] == 0 || this.grid[x + 1][y] != 0 && this.grid[x + 1][y] != this.grid[x][y]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        if (!b) {
            this.turnstate = 4;
        }
    }

    private void addPoints(int i) {
        if (i == 1) {
            this.scorePoint += 2;
        }
        if (i == 2) {
            this.scorePoint += 4;
        }
        if (i == 3) {
            this.scorePoint += 8;
        }
        if (i == 4) {
            this.scorePoint += 16;
        }
        if (i == 5) {
            this.scorePoint += 32;
        }
        if (i == 6) {
            this.scorePoint += 64;
        }
        if (i == 7) {
            this.scorePoint += 128;
        }
        if (i == 8) {
            this.scorePoint += 256;
        }
        if (i == 9) {
            this.scorePoint += 512;
        }
        if (i == 10) {
            this.scorePoint += 1024;
        }
        if (i == 11) {
            this.scorePoint += 2048;
        }
        if (i == 12) {
            this.scorePoint += 4096;
        }
        if (i == 13) {
            this.scorePoint += 8192;
        }
        if (i == 14) {
            this.scorePoint += 16384;
        }
        if (i == 15) {
            this.scorePoint += 32768;
        }
        if (i == 16) {
            this.scorePoint += 65536;
        }
        this.setJingle(12);
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 23;
    }
}

