/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.chip;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Ship;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicChipOrange
extends LogicBase {
    public Ship octanom_head = new Ship(1, new Vector2(0, 0), new Vector2(0, 0));
    public List<Ship> octanom_tail = new ArrayList<Ship>();
    public int temp_player;
    public int temp_auto;
    public Vector2 point = new Vector2(0, 0);
    public boolean active_move_tail;

    public LogicChipOrange(int tableID) {
        super(tableID);
    }

    @Override
    public void start2() {
        this.active_move_tail = true;
        this.temp_player = 0;
        this.temp_auto = 0;
        this.commandSpawnPoint();
        this.octanom_tail.clear();
    }

    @Override
    public void command(int action) {
        this.temp_player = action;
    }

    @Override
    public void updateLogic() {
        if (this.turnstate >= 2 && this.turnstate < 4) {
            this.octanom_head.update();
            if (this.active_move_tail) {
                for (Ship tail : this.octanom_tail) {
                    tail.update();
                }
            }
            this.commandMove();
            this.commandCollision();
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.octanom_head = this.loadEntity(compound, 0);
        this.octanom_tail = this.loadEntityList(compound, 1);
        this.temp_player = compound.func_74762_e("tempplayer");
        this.temp_auto = compound.func_74762_e("temp_auto");
        this.point.set(compound.func_74762_e("pointx"), compound.func_74762_e("pointy"));
        this.active_move_tail = compound.func_74767_n("active_move_tail");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveEntity(compound, 0, this.octanom_head);
        this.saveEntityList(compound, 1, this.octanom_tail);
        compound.func_74768_a("tempplayer", this.temp_player);
        compound.func_74768_a("temp_auto", this.temp_auto);
        compound.func_74768_a("pointx", this.point.X);
        compound.func_74768_a("pointy", this.point.Y);
        compound.func_74757_a("active_move_tail", this.active_move_tail);
        return compound;
    }

    private void commandMove() {
        if (this.octanom_head.getPos().matches(this.octanom_head.getNext())) {
            Vector2 position = new Vector2(this.octanom_head.getPos());
            if (this.temp_player == 265 && this.octanom_head.getNext().Y != 0) {
                this.octanom_head.setInMotion(0, -this.speed());
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 265 && this.octanom_head.getNext().Y == 0) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_player == 264 && this.octanom_head.getNext().Y != 224) {
                this.octanom_head.setInMotion(0, this.speed());
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 264 && this.octanom_head.getNext().Y == 224) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_player == 263 && this.octanom_head.getNext().X != 0) {
                this.octanom_head.setInMotion(-this.speed(), 0);
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 263 && this.octanom_head.getNext().X == 0) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_player == 262 && this.octanom_head.getNext().X != 176) {
                this.octanom_head.setInMotion(this.speed(), 0);
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 262 && this.octanom_head.getNext().X == 176) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_auto == 1 && this.octanom_head.getNext().Y != 0) {
                this.octanom_head.setInMotion(0, -this.speed());
            } else if (this.temp_auto == 1 && this.octanom_head.getNext().Y == 0) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
            } else if (this.temp_auto == 2 && this.octanom_head.getNext().Y != 224) {
                this.octanom_head.setInMotion(0, this.speed());
            } else if (this.temp_auto == 2 && this.octanom_head.getNext().Y == 224) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
            } else if (this.temp_auto == 3 && this.octanom_head.getNext().X != 0) {
                this.octanom_head.setInMotion(-this.speed(), 0);
            } else if (this.temp_auto == 3 && this.octanom_head.getNext().X == 0) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
            } else if (this.temp_auto == 4 && this.octanom_head.getNext().X != 176) {
                this.octanom_head.setInMotion(this.speed(), 0);
            } else if (this.temp_auto == 4 && this.octanom_head.getNext().X == 176) {
                this.octanom_head.setInMotion(0, 0);
                this.temp_auto = 0;
            }
            for (Ship tail : this.octanom_tail) {
                if (position.X > tail.getPos().X) {
                    tail.setPos(position.X - 16, position.Y);
                    tail.setVel(this.speed(), 0);
                } else if (position.X < tail.getPos().X) {
                    tail.setPos(position.X + 16, position.Y);
                    tail.setVel(-this.speed(), 0);
                } else if (position.Y > tail.getPos().Y) {
                    tail.setPos(position.X, position.Y - 16);
                    tail.setVel(0, this.speed());
                } else if (position.Y < tail.getPos().Y) {
                    tail.setPos(position.X, position.Y + 16);
                    tail.setVel(0, -this.speed());
                }
                position.set(tail.getPos());
            }
            this.active_move_tail = !this.octanom_head.getVel().matches(0, 0);
        }
    }

    private void commandCollision() {
        for (int i = 0; i < 5; ++i) {
            if (!this.octanom_head.getPos().matches(this.point.X * 16, this.point.Y * 16)) continue;
            ++this.scorePoint;
            this.commandSpawnPoint();
            this.commandSpawnTail();
            this.setJingle(12);
        }
        if (this.octanom_tail.size() > 1) {
            for (Ship tail : this.octanom_tail) {
                if (!this.octanom_head.getPos().matches(tail.getPos())) continue;
                this.turnstate = 4;
                this.setJingle(5);
            }
        }
    }

    private int speed() {
        return 4;
    }

    private void commandSpawnPoint() {
        boolean temp_break = false;
        int x = 0;
        int y = 0;
        int b = 0;
        while (!temp_break) {
            boolean temp_internal = false;
            x = this.RANDOM.nextInt(10) + 1;
            y = this.RANDOM.nextInt(13) + 1;
            if (++b < 10) {
                if (!this.octanom_head.getNext().matches(x, y)) {
                    for (Ship tail : this.octanom_tail) {
                        if (!tail.getGrid().matches(x, y)) continue;
                        temp_internal = true;
                        break;
                    }
                    if (this.point.matches(x, y)) {
                        temp_internal = true;
                    }
                    if (!temp_internal) {
                        temp_break = true;
                    }
                }
            } else if (!this.octanom_head.getNext().matches(x, y)) {
                temp_break = true;
            }
            this.point = new Vector2(x, y);
        }
    }

    private void commandSpawnTail() {
        Vector2 pos = new Vector2(this.octanom_head.getPos());
        int i = 0;
        for (Ship tail : this.octanom_tail) {
            if (i + 1 == this.octanom_tail.size()) {
                pos.set(tail.getPos());
            }
            ++i;
        }
        this.octanom_tail.add(new Ship(0, pos, pos));
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 26;
    }
}

