/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.chip;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.MapRoom;
import mod.casinocraft.util.Ship;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicChipPink
extends LogicBase {
    public Ship octanom = new Ship(1, new Vector2(240, 240), new Vector2(240, 240));
    public List<Ship> crate = new ArrayList<Ship>();
    public List<Ship> cross = new ArrayList<Ship>();
    public boolean moving;
    public int mapID;

    public LogicChipPink(int tableID) {
        super(tableID, 12, 15);
    }

    @Override
    public void start2() {
        this.crate.clear();
        this.cross.clear();
    }

    @Override
    public void command(int action) {
        if (this.turnstate == 3) {
            this.commandMove(action);
        } else if (this.turnstate == 2) {
            this.commandSelect(action);
            if (action == 257) {
                this.loadMap();
            }
        }
    }

    @Override
    public void updateLogic() {
        if (this.moving) {
            boolean swittch = true;
            for (Ship c : this.crate) {
                if (c.getPos().X == c.getNext().X * 16 && c.getPos().Y == c.getNext().Y * 16) {
                    c.setInMotion(0, 0);
                    continue;
                }
                swittch = false;
            }
            if (swittch) {
                this.moving = false;
            }
        }
        if (this.turnstate >= 2 && this.turnstate < 4) {
            this.octanom.update();
            boolean win = true;
            for (Ship e : this.crate) {
                e.update();
                boolean hp1 = true;
                for (Ship c : this.cross) {
                    if (!c.getPos().matches(e.getPos())) continue;
                    hp1 = false;
                }
                if (hp1) {
                    e.setHP(1);
                    win = false;
                    continue;
                }
                e.setHP(2);
            }
            for (Ship e : this.cross) {
                e.update();
            }
            if (win && this.turnstate == 3) {
                boolean unlocked = false;
                for (int i = 0; i < 20; ++i) {
                    if (this.scoreHigh[i] != this.mapID + 1) continue;
                    unlocked = true;
                }
                if (!unlocked) {
                    this.scorePoint = this.mapID + 1;
                }
                this.turnstate = 4;
            }
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.octanom = this.loadEntity(compound, 0);
        this.crate = this.loadEntityList(compound, 1);
        this.cross = this.loadEntityList(compound, 2);
        this.moving = compound.func_74767_n("moving");
        this.mapID = compound.func_74762_e("map_id");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveEntity(compound, 0, this.octanom);
        this.saveEntityList(compound, 1, this.crate);
        this.saveEntityList(compound, 2, this.cross);
        compound.func_74757_a("moving", this.moving);
        compound.func_74768_a("map_id", this.mapID);
        return compound;
    }

    private void loadMap() {
        this.turnstate = 3;
        List<String> list = MapRoom.loadSokoban(this.mapID);
        int y = 0;
        for (String s : list) {
            block8: for (int x = 0; x < s.length(); ++x) {
                char c = s.charAt(x);
                switch (c) {
                    case ' ': {
                        continue block8;
                    }
                    case 'X': {
                        this.grid[x][y] = 1;
                        continue block8;
                    }
                    case 'O': {
                        this.octanom = new Ship(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y));
                        continue block8;
                    }
                    case 'M': {
                        this.cross.add(new Ship(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                        continue block8;
                    }
                    case 'C': {
                        this.crate.add(new Ship(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                    }
                }
            }
            ++y;
        }
    }

    private void commandMove(int direction) {
        if (!this.octanom.isMoving()) {
            int x = 0;
            int y = 0;
            if (direction == 265) {
                x = 0;
                y = -1;
            }
            if (direction == 264) {
                x = 0;
                y = 1;
            }
            if (direction == 263) {
                x = -1;
                y = 0;
            }
            if (direction == 262) {
                x = 1;
                y = 0;
            }
            if (this.grid[this.octanom.getGrid().X + x][this.octanom.getGrid().Y + y] == 0) {
                boolean blockedO = false;
                for (Ship c : this.crate) {
                    if (c.getGrid().X != this.octanom.getGrid().X + x || c.getGrid().Y != this.octanom.getGrid().Y + y) continue;
                    blockedO = true;
                    this.setJingle(5);
                    if (this.grid[this.octanom.getGrid().X + x * 2][this.octanom.getGrid().Y + y * 2] != 0) continue;
                    boolean blockedC = false;
                    for (Ship c2 : this.crate) {
                        if (c.getGrid().X != this.octanom.getGrid().X + x * 2 || c.getGrid().Y != this.octanom.getGrid().Y + y * 2) continue;
                        blockedC = true;
                        this.setJingle(5);
                    }
                    if (blockedC) continue;
                    this.moving = true;
                    c.setInMotion(x * 4, y * 4);
                }
                if (!blockedO) {
                    this.octanom.setInMotion(x * 4, y * 4);
                }
            }
        }
    }

    private void commandSelect(int direction) {
        if (direction == 265 && this.mapID / 4 > 0) {
            this.mapID -= 4;
        }
        if (direction == 264 && this.mapID / 4 < 4) {
            this.mapID += 4;
        }
        if (direction == 263 && this.mapID % 4 > 0) {
            --this.mapID;
        }
        if (direction == 262 && this.mapID % 4 < 3) {
            ++this.mapID;
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 27;
    }
}

