/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import mod.casinocraft.logic.LogicBase;
import net.minecraft.nbt.CompoundNBT;

public class LogicMinoGray
extends LogicBase {
    public LogicMinoGray(int tableID) {
        super(tableID, 7, 7);
    }

    @Override
    public void start2() {
        this.scorePoint = 1;
        this.scoreLevel = 1;
        this.fillGrid();
    }

    public void restart() {
        this.turnstate = 2;
        ++this.scoreLevel;
        this.fillGrid();
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else if (action >= 100) {
            this.setJingle(3);
            this.mark(action - 100);
        } else {
            this.setJingle(3);
            this.flip(action);
        }
    }

    @Override
    public void updateLogic() {
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        return compound;
    }

    private void fillGrid() {
        int y;
        int i;
        int x;
        int y2;
        for (y2 = 0; y2 < 5; ++y2) {
            for (x = 0; x < 5; ++x) {
                this.grid[x][y2] = 1;
            }
        }
        for (i = 0; i < Math.min(this.scoreLevel + 8, 16); ++i) {
            x = this.RANDOM.nextInt(5);
            if (this.grid[x][y = this.RANDOM.nextInt(5)] == 1) {
                this.grid[x][y] = 0;
                continue;
            }
            --i;
        }
        for (i = 0; i < Math.min(this.scoreLevel * 2 + 6, 32); ++i) {
            x = this.RANDOM.nextInt(5);
            if (this.grid[x][y = this.RANDOM.nextInt(5)] > 0 && this.grid[x][y] <= 5) {
                int[] nArray = this.grid[x];
                int n = y;
                nArray[n] = nArray[n] + 1;
                continue;
            }
            --i;
        }
        for (y2 = 0; y2 < 5; ++y2) {
            this.grid[5][y2] = 0;
            this.grid[6][y2] = 0;
            for (x = 0; x < 5; ++x) {
                if (this.grid[x][y2] == 0) {
                    int[] nArray = this.grid[6];
                    int n = y2;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = this.grid[5];
                int n = y2;
                nArray[n] = nArray[n] + this.grid[x][y2];
            }
        }
        for (int x2 = 0; x2 < 5; ++x2) {
            this.grid[x2][5] = 0;
            this.grid[x2][6] = 0;
            for (int y3 = 0; y3 < 5; ++y3) {
                if (this.grid[x2][y3] == 0) {
                    int[] nArray = this.grid[x2];
                    nArray[6] = nArray[6] + 1;
                    continue;
                }
                int[] nArray = this.grid[x2];
                nArray[5] = nArray[5] + this.grid[x2][y3];
            }
        }
        for (y2 = 0; y2 < 5; ++y2) {
            for (x = 0; x < 5; ++x) {
                int[] nArray = this.grid[x];
                int n = y2;
                nArray[n] = nArray[n] + 100;
            }
        }
    }

    private void flip(int action) {
        int x = action % 5;
        int y = action / 5;
        if (this.grid[x][y] >= 100) {
            this.grid[x][y] = this.grid[x][y] % 100;
            if (this.grid[x][y] == 0) {
                this.turnstate = 4;
                this.scorePoint /= 2;
            } else {
                this.scorePoint *= this.grid[x][y];
                this.checkGrid();
            }
        }
    }

    private void mark(int action) {
        int x = action % 5;
        int y = action / 5;
        if (this.grid[x][y] >= 200) {
            int[] nArray = this.grid[x];
            int n = y;
            nArray[n] = nArray[n] - 100;
        } else if (this.grid[x][y] >= 100) {
            int[] nArray = this.grid[x];
            int n = y;
            nArray[n] = nArray[n] + 100;
        }
    }

    private void checkGrid() {
        boolean allCleared = true;
        block0: for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                if (this.grid[x][y] % 100 <= 1 || this.grid[x][y] < 100) continue;
                allCleared = false;
                continue block0;
            }
        }
        if (allCleared) {
            this.turnstate = 3;
            this.uncoverAll();
        }
    }

    private void uncoverAll() {
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int[] nArray = this.grid[x];
                int n = y;
                nArray[n] = nArray[n] % 100;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 36;
    }
}

