/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Dice;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicMinoOrange
extends LogicBase {
    public Dice[] dice = new Dice[2];
    public int result = 0;
    public int point = 0;
    public int comepoint = 0;

    public LogicMinoOrange(int tableID) {
        super(tableID, 8, 5);
    }

    @Override
    public void start2() {
        this.hand = "Place your Bets..";
        this.selector = new Vector2(3, 2);
        this.result = -1;
        this.point = -1;
        this.comepoint = -1;
        this.dice[0] = new Dice(0, 1);
        this.dice[1] = new Dice(0, 1);
    }

    @Override
    public void command(int action) {
        this.timeout = 0;
        if (action == -2) {
            if (this.selector.X > -1) {
                this.grid[this.selector.X][this.selector.Y] = this.activePlayer + 1;
                this.selector.set(-1, -1);
            }
            this.spin();
        } else if (action == -1) {
            if (this.selector.X > -1) {
                this.grid[this.selector.X][this.selector.Y] = this.activePlayer + 1;
                this.selector.set(-1, -1);
            }
        } else {
            int x = action % 8;
            int y = action / 8;
            if (this.grid[x][y] == 0) {
                this.selector.set(x, y);
                this.setJingle(3);
            }
        }
    }

    private void reset() {
        this.turnstate = 2;
        this.activePlayer = 0;
        this.timeout = 0;
    }

    @Override
    public void updateLogic() {
        if (this.turnstate == 2) {
            ++this.timeout;
            if (this.timeout == (Integer)CasinoKeeper.config_timeout.get()) {
                this.spin();
            }
        }
        if (this.turnstate == 3) {
            for (int i = 0; i < 2; ++i) {
                if (this.dice[i].shiftX > 45) {
                    this.dice[i].Update(1, this.RANDOM.nextInt(6));
                    continue;
                }
                if (this.dice[i].shiftX <= 0) continue;
                this.dice[i].shiftX = 0;
                this.dice[i].shiftY = 0;
            }
        }
        if (this.turnstate == 4) {
            this.selector = new Vector2(-1, -1);
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.dice = this.loadDice(compound);
        this.result = compound.func_74762_e("result");
        this.point = compound.func_74762_e("point");
        this.comepoint = compound.func_74762_e("comepoint");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveDice(compound, this.dice);
        compound.func_74768_a("result", this.result);
        compound.func_74768_a("point", this.point);
        compound.func_74768_a("comepoint", this.comepoint);
        return compound;
    }

    private void spin() {
        if (this.turnstate == 2) {
            ++this.activePlayer;
            if (this.activePlayer >= this.getFirstFreePlayerSlot()) {
                this.setJingle(4);
                this.dice[0].setUp(200 + this.RANDOM.nextInt(50), 50 + this.RANDOM.nextInt(200), this.RANDOM.nextInt(2) == 0);
                this.dice[1].setUp(50 + this.RANDOM.nextInt(200), 200 + this.RANDOM.nextInt(50), this.RANDOM.nextInt(2) == 0);
                if (this.selector.X > -1) {
                    this.grid[this.selector.X][this.selector.Y] = 1;
                    this.selector = new Vector2(-1, -1);
                }
                this.turnstate = 3;
            }
        } else if (this.turnstate == 3 && this.dice[0].shiftX == 0 && this.dice[1].shiftX == 0) {
            this.result();
        }
    }

    private void result() {
        this.dice[0].Reset();
        this.dice[1].Reset();
        boolean hasCome = false;
        for (int i = 0; i < 5; ++i) {
            if (this.grid[0][i] == 1) {
                hasCome = true;
            }
            if (this.grid[7][i] != 1) continue;
            hasCome = true;
        }
        if (this.point == -1) {
            this.point = this.dice[0].number + 1 + this.dice[1].number + 1;
            this.result = this.dice[0].number + 1 + this.dice[1].number + 1;
            if (this.result == 7 || this.result == 11) {
                this.resultPass(true);
                this.resultDontPass(false);
                this.hand = "Natura Roll!";
                this.turnstate = 4;
            } else if (this.result == 2 || this.result == 3 || this.result == 12) {
                this.resultPass(false);
                this.resultDontPass(true);
                this.hand = "Crab...";
                this.turnstate = 4;
            } else {
                this.hand = "Roll again...";
                this.reset();
            }
        } else {
            this.result = this.dice[0].number + 1 + this.dice[1].number + 1;
            this.resultSingleOdds();
            this.reset();
            if (hasCome) {
                if (this.comepoint == -1) {
                    this.comepoint = this.result;
                } else if (this.result == this.comepoint) {
                    this.resultCome(true);
                    this.resultDontCome(false);
                } else if (this.comepoint == 7) {
                    this.resultCome(false);
                    this.resultDontCome(true);
                }
            }
            if (this.comepoint == 7) {
                this.resultPass(false);
                this.resultPassOdds(false);
                this.resultDontPass(true);
                this.resultDontPassOdds(true);
                this.hand = "SEVEN";
                this.turnstate = 4;
            } else if (this.result == this.point) {
                this.resultPass(false);
                this.resultPassOdds(false);
                this.resultDontPass(true);
                this.resultDontPassOdds(true);
                this.hand = "POINT";
                this.turnstate = 4;
            }
        }
    }

    private void resultCome(boolean won) {
        if (this.grid[0][0] > 0) {
            if (won) {
                int n = this.grid[0][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[0][0] = 0;
            }
        }
        if (this.grid[0][1] > 0) {
            if (won) {
                int n = this.grid[0][1] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[0][1] = 0;
            }
        }
        if (this.grid[0][2] > 0) {
            if (won) {
                int n = this.grid[0][2] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[0][2] = 0;
            }
        }
        if (this.grid[0][3] > 0) {
            if (won) {
                int n = this.grid[0][3] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[0][3] = 0;
            }
        }
        if (this.grid[0][4] > 0) {
            if (won) {
                int n = this.grid[0][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[0][4] = 0;
            }
        }
    }

    private void resultDontCome(boolean won) {
        if (this.grid[7][0] == 1) {
            if (won) {
                int n = this.grid[7][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[7][0] = 0;
            }
        }
        if (this.grid[7][1] == 1) {
            if (won) {
                int n = this.grid[7][1] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[7][1] = 0;
            }
        }
        if (this.grid[7][2] == 1) {
            if (won) {
                int n = this.grid[7][2] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[7][2] = 0;
            }
        }
        if (this.grid[7][3] == 1) {
            if (won) {
                int n = this.grid[7][3] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[7][3] = 0;
            }
        }
        if (this.grid[7][4] == 1) {
            if (won) {
                int n = this.grid[7][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[7][4] = 0;
            }
        }
    }

    private void resultPass(boolean won) {
        if (this.grid[1][0] == 1) {
            if (won) {
                int n = this.grid[1][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[1][0] = 0;
            }
        }
        if (this.grid[2][0] == 1) {
            if (won) {
                int n = this.grid[2][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[2][0] = 0;
            }
        }
        if (this.grid[3][0] == 1) {
            if (won) {
                int n = this.grid[3][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[3][0] = 0;
            }
        }
        if (this.grid[4][0] == 1) {
            if (won) {
                int n = this.grid[4][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[4][0] = 0;
            }
        }
        if (this.grid[5][0] == 1) {
            if (won) {
                int n = this.grid[5][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[5][0] = 0;
            }
        }
        if (this.grid[6][0] == 1) {
            if (won) {
                int n = this.grid[6][0] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[6][0] = 0;
            }
        }
    }

    private void resultDontPass(boolean won) {
        if (this.grid[1][4] == 1) {
            if (won) {
                int n = this.grid[1][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[1][4] = 0;
            }
        }
        if (this.grid[2][4] == 1) {
            if (won) {
                int n = this.grid[2][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[2][4] = 0;
            }
        }
        if (this.grid[3][4] == 1) {
            if (won) {
                int n = this.grid[3][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[3][4] = 0;
            }
        }
        if (this.grid[4][4] == 1) {
            if (won) {
                int n = this.grid[4][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[4][4] = 0;
            }
        }
        if (this.grid[5][4] == 1) {
            if (won) {
                int n = this.grid[5][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[5][4] = 0;
            }
        }
        if (this.grid[6][4] == 1) {
            if (won) {
                int n = this.grid[6][4] - 1;
                this.reward[n] = this.reward[n] + 2;
            } else {
                this.grid[6][4] = 0;
            }
        }
    }

    private void resultPassOdds(boolean won) {
        if (this.grid[1][1] == 1) {
            if (won) {
                if (this.result == 4) {
                    int n = this.grid[1][1] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[1][1] = 0;
                }
            } else {
                this.grid[1][1] = 0;
            }
        }
        if (this.grid[2][1] == 1) {
            if (won) {
                if (this.result == 5) {
                    int n = this.grid[2][1] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[2][1] = 0;
                }
            } else {
                this.grid[2][1] = 0;
            }
        }
        if (this.grid[3][1] == 1) {
            if (won) {
                if (this.result == 6) {
                    int n = this.grid[3][1] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[3][1] = 0;
                }
            } else {
                this.grid[3][1] = 0;
            }
        }
        if (this.grid[4][1] == 1) {
            if (won) {
                if (this.result == 8) {
                    int n = this.grid[4][1] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[4][1] = 0;
                }
            } else {
                this.grid[4][1] = 0;
            }
        }
        if (this.grid[5][1] == 1) {
            if (won) {
                if (this.result == 9) {
                    int n = this.grid[5][1] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[5][1] = 0;
                }
            } else {
                this.grid[5][1] = 0;
            }
        }
        if (this.grid[6][1] == 1) {
            if (won) {
                if (this.result == 10) {
                    int n = this.grid[6][1] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[6][1] = 0;
                }
            } else {
                this.grid[6][1] = 0;
            }
        }
    }

    private void resultDontPassOdds(boolean won) {
        if (this.grid[1][3] == 1) {
            if (won) {
                if (this.result == 4) {
                    int n = this.grid[1][3] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[1][3] = 0;
                }
            } else {
                this.grid[1][3] = 0;
            }
        }
        if (this.grid[2][3] == 1) {
            if (won) {
                if (this.result == 5) {
                    int n = this.grid[2][3] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[2][3] = 0;
                }
            } else {
                this.grid[2][3] = 0;
            }
        }
        if (this.grid[3][3] == 1) {
            if (won) {
                if (this.result == 6) {
                    int n = this.grid[3][3] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[3][3] = 0;
                }
            } else {
                this.grid[3][3] = 0;
            }
        }
        if (this.grid[4][3] == 1) {
            if (won) {
                if (this.result == 8) {
                    int n = this.grid[4][3] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[4][3] = 0;
                }
            } else {
                this.grid[4][3] = 0;
            }
        }
        if (this.grid[5][3] == 1) {
            if (won) {
                if (this.result == 9) {
                    int n = this.grid[5][3] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[5][3] = 0;
                }
            } else {
                this.grid[5][3] = 0;
            }
        }
        if (this.grid[6][3] == 1) {
            if (won) {
                if (this.result == 10) {
                    int n = this.grid[6][3] - 1;
                    this.reward[n] = this.reward[n] + 2;
                } else {
                    this.grid[6][3] = 0;
                }
            } else {
                this.grid[6][3] = 0;
            }
        }
    }

    private void resultSingleOdds() {
        if (this.grid[1][2] == 1) {
            if (this.result == 4) {
                int n = this.grid[1][2] - 1;
                this.reward[n] = this.reward[n] + 10;
            } else {
                this.grid[1][2] = 0;
            }
        }
        if (this.grid[2][2] == 1) {
            if (this.result == 5) {
                int n = this.grid[2][2] - 1;
                this.reward[n] = this.reward[n] + 8;
            } else {
                this.grid[2][2] = 0;
            }
        }
        if (this.grid[3][2] == 1) {
            if (this.result == 6) {
                int n = this.grid[3][2] - 1;
                this.reward[n] = this.reward[n] + 6;
            } else {
                this.grid[3][2] = 0;
            }
        }
        if (this.grid[4][2] == 1) {
            if (this.result == 8) {
                int n = this.grid[4][2] - 1;
                this.reward[n] = this.reward[n] + 6;
            } else {
                this.grid[4][2] = 0;
            }
        }
        if (this.grid[5][2] == 1) {
            if (this.result == 9) {
                int n = this.grid[5][2] - 1;
                this.reward[n] = this.reward[n] + 8;
            } else {
                this.grid[5][2] = 0;
            }
        }
        if (this.grid[6][2] == 1) {
            if (this.result == 10) {
                int n = this.grid[6][2] - 1;
                this.reward[n] = this.reward[n] + 10;
            } else {
                this.grid[6][2] = 0;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 42;
    }
}

