/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.other;

import mod.casinocraft.logic.LogicBase;
import net.minecraft.nbt.CompoundNBT;

public class LogicSlotGame
extends LogicBase {
    public int wheel;
    public int[] wheelPos = new int[3];
    public boolean[] lines = new boolean[5];

    public LogicSlotGame(int tableID) {
        super(tableID, 9, 3);
    }

    @Override
    public void start2() {
        this.fillGrid();
        this.wheelPos[0] = 0;
        this.wheelPos[1] = 0;
        this.wheelPos[2] = 0;
        this.scoreLevel = 1;
        this.wheel = 0;
        this.lines[0] = false;
        this.lines[1] = false;
        this.lines[2] = false;
        this.lines[3] = false;
        this.lines[4] = false;
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            if (this.scoreLevel < 5) {
                ++this.scoreLevel;
            }
        } else if (this.turnstate == 2) {
            this.turnstate = 3;
        } else if (this.turnstate == 3) {
            this.spin();
        }
    }

    @Override
    public void updateLogic() {
        int max = 432;
        if (this.turnstate == 3) {
            for (int i = 0; i < 3; ++i) {
                if (this.wheel <= i) {
                    this.wheelPos[i] = (this.wheelPos[i] + 6 + i * 6) % max;
                    continue;
                }
                if (this.wheelPos[i] % 48 == 0) continue;
                this.wheelPos[i] = (this.wheelPos[i] + 1) % max;
            }
            if (this.wheel == 3 && this.wheelPos[0] % 48 == 0 && this.wheelPos[1] % 48 == 0 && this.wheelPos[2] % 48 == 0) {
                this.result();
            }
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.wheel = compound.func_74762_e("wheel");
        this.wheelPos[0] = compound.func_74762_e("wheelpos0");
        this.wheelPos[1] = compound.func_74762_e("wheelpos1");
        this.wheelPos[2] = compound.func_74762_e("wheelpos2");
        this.lines[0] = compound.func_74767_n("lines0");
        this.lines[1] = compound.func_74767_n("lines1");
        this.lines[2] = compound.func_74767_n("lines2");
        this.lines[3] = compound.func_74767_n("lines3");
        this.lines[4] = compound.func_74767_n("lines4");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        compound.func_74768_a("wheel", this.wheel);
        compound.func_74768_a("wheelpos0", this.wheelPos[0]);
        compound.func_74768_a("wheelpos1", this.wheelPos[1]);
        compound.func_74768_a("wheelpos2", this.wheelPos[2]);
        compound.func_74757_a("lines0", this.lines[0]);
        compound.func_74757_a("lines1", this.lines[1]);
        compound.func_74757_a("lines2", this.lines[2]);
        compound.func_74757_a("lines3", this.lines[3]);
        compound.func_74757_a("lines4", this.lines[4]);
        return compound;
    }

    private void fillGrid() {
        for (int y = 0; y < 3; ++y) {
            int[] gridtemp = this.getGrid(y % 9);
            for (int x = 0; x < 9; ++x) {
                this.grid[x][y] = gridtemp[x];
            }
        }
    }

    private int[] getGrid(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 0, 5, 4, 3, 2, 0, 5, 4};
            }
            case 1: {
                return new int[]{1, 2, 0, 5, 4, 3, 2, 0, 5};
            }
            case 2: {
                return new int[]{1, 3, 2, 0, 5, 4, 3, 2, 0};
            }
        }
        return null;
    }

    private void spin() {
        if (this.wheel < 3) {
            ++this.wheel;
        }
    }

    private void result() {
        int pos0 = this.wheelPos[0] / 48;
        int pos1 = this.wheelPos[1] / 48;
        int pos2 = this.wheelPos[2] / 48;
        if (this.scoreLevel >= 1) {
            this.checkWheel(this.grid[(pos0 + 1) % 9][0], this.grid[(pos1 + 1) % 9][1], this.grid[(pos2 + 1) % 9][2], 0);
        }
        if (this.scoreLevel >= 2) {
            this.checkWheel(this.grid[(pos0 + 0) % 9][0], this.grid[(pos1 + 0) % 9][1], this.grid[(pos2 + 0) % 9][2], 1);
        }
        if (this.scoreLevel >= 3) {
            this.checkWheel(this.grid[(pos0 + 2) % 9][0], this.grid[(pos1 + 2) % 9][1], this.grid[(pos2 + 2) % 9][2], 2);
        }
        if (this.scoreLevel >= 4) {
            this.checkWheel(this.grid[(pos0 + 0) % 9][0], this.grid[(pos1 + 1) % 9][1], this.grid[(pos2 + 2) % 9][2], 3);
        }
        if (this.scoreLevel >= 5) {
            this.checkWheel(this.grid[(pos0 + 2) % 9][0], this.grid[(pos1 + 1) % 9][1], this.grid[(pos2 + 0) % 9][2], 4);
        }
        this.turnstate = 4;
    }

    private void checkWheel(int wheel0, int wheel1, int wheel2, int index) {
        if (wheel0 == 0) {
            this.reward[0] = this.reward[0] + 1;
        }
        if (wheel0 == 1) {
            this.reward[0] = this.reward[0] + 1;
        }
        if (wheel0 == 2) {
            this.reward[0] = this.reward[0] + 1;
        }
        if (wheel0 == 2 && wheel1 == 2 && wheel2 == 2) {
            this.reward[0] = this.reward[0] + 5;
            this.lines[index] = true;
        }
        if (wheel0 == 3 && wheel1 == 3 && wheel2 == 3) {
            this.reward[0] = this.reward[0] + 10;
            this.lines[index] = true;
        }
        if (wheel0 == 4 && wheel1 == 4 && wheel2 == 4) {
            this.reward[0] = this.reward[0] + 20;
            this.lines[index] = true;
        }
        if (wheel0 == 5 && wheel1 == 5 && wheel2 == 5) {
            this.reward[0] = this.reward[0] + 35;
            this.lines[index] = true;
        }
        if (wheel0 == 1 && wheel1 == 1 && wheel2 == 1) {
            this.reward[0] = this.reward[0] + 77;
            this.lines[index] = true;
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 49;
    }
}

