/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import java.util.function.Predicate;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.logic.other.LogicDummy;
import mod.casinocraft.network.MessageInventoryServer;
import mod.casinocraft.network.MessagePlayerServer;
import mod.casinocraft.network.MessageScoreServer;
import mod.casinocraft.network.MessageStartServer;
import mod.casinocraft.network.MessageStateServer;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.InventoryUtil;
import mod.casinocraft.util.Ship;
import mod.casinocraft.util.Vector2;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ScreenCasino
extends ContainerScreen<ContainerCasino> {
    private final PlayerInventory PLAYER;
    protected final ContainerCasino CONTAINER;
    protected int tableID;
    protected int playerToken = -1;
    protected int bet = 0;
    protected int colour = 0;
    protected int colourize = 65793;
    private final int grayscale = 0xFFFFFF;
    protected int camera1 = 0;
    protected int camera0 = 0;
    protected boolean showDebug = false;
    protected boolean showForfeit = false;
    protected int highlightIndex = 0;
    private int highlightTimer = 0;

    public ScreenCasino(ContainerCasino container, PlayerInventory player, ITextComponent name) {
        super((Container)container, player, name);
        this.PLAYER = player;
        this.CONTAINER = container;
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.tableID = this.CONTAINER.tableID;
    }

    private LogicBase logic() {
        return this.CONTAINER.logic();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.keyTyped(keyCode);
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void keyTyped(int keyCode) {
        if (keyCode == 259) {
            boolean bl = this.showDebug = !this.showDebug;
        }
        if (this.isCurrentPlayer() && !this.logic().pause && (this.logic().turnstate == 2 || this.logic().turnstate == 3)) {
            if (keyCode == 265) {
                this.action(265);
            }
            if (keyCode == 264) {
                this.action(264);
            }
            if (keyCode == 263) {
                this.action(263);
            }
            if (keyCode == 262) {
                this.action(262);
            }
            if (keyCode == 257) {
                this.action(257);
            }
            if (keyCode == 48) {
                this.action(348);
            }
            if (keyCode == 49) {
                this.action(349);
            }
            if (keyCode == 50) {
                this.action(350);
            }
            if (keyCode == 51) {
                this.action(351);
            }
            if (keyCode == 52) {
                this.action(352);
            }
            if (keyCode == 53) {
                this.action(353);
            }
            if (keyCode == 54) {
                this.action(354);
            }
            if (keyCode == 55) {
                this.action(355);
            }
            if (keyCode == 56) {
                this.action(356);
            }
            if (keyCode == 57) {
                this.action(357);
            }
        }
        if (this.tableID == 0) {
            if (this.CONTAINER.turnstate() == 0 && keyCode == 257) {
                if (!this.CONTAINER.hasToken() || this.playerToken >= this.CONTAINER.getBettingLow()) {
                    if (this.CONTAINER.hasToken()) {
                        this.collectBet();
                    }
                    this.start();
                }
            } else if (this.CONTAINER.turnstate() == 7 && this.tableID == 0 && keyCode == 257) {
                this.reset();
            } else if (this.CONTAINER.turnstate() == 5 && this.tableID == 0 && keyCode == 257) {
                if (this.logic().hasHighscore()) {
                    this.turnstate(7);
                } else {
                    this.reset();
                }
            }
            if ((this.CONTAINER.turnstate() == 2 || this.CONTAINER.turnstate() == 3) && this.tableID == 0 && keyCode == 32) {
                this.turnstate(-1);
            }
            if ((this.CONTAINER.turnstate() == 2 || this.CONTAINER.turnstate() == 3) && this.CONTAINER.logic().pause && this.tableID == 0 && keyCode == 257) {
                this.turnstate(4);
            }
        } else if (this.tableID == 3) {
            if (this.CONTAINER.turnstate() == 0 && keyCode == 257) {
                if (this.playerToken >= this.CONTAINER.getBettingLow()) {
                    this.collectBet();
                    this.start();
                }
            } else if (this.CONTAINER.turnstate() == 5 && keyCode == 257) {
                this.reset();
            }
            if (this.logic().turnstate == 2) {
                if (keyCode == 257 && this.logic().scoreLevel < 5 && this.playerToken >= this.bet) {
                    this.collectBet();
                    this.playerToken = -1;
                    this.action(0);
                }
                if (keyCode == 32) {
                    this.action(1);
                }
            } else if (keyCode == 32) {
                this.action(1);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 || mouseButton == 1) {
            if (this.CONTAINER.turnstate() == 0) {
                if (this.logic().hasHighscore() && this.mouseRect(82, 164, 92, 26, mouseX, mouseY)) {
                    this.turnstate(7);
                }
                if (this.mouseRect(56, 204, 26, 26, mouseX, mouseY) && this.bet > this.CONTAINER.getBettingLow()) {
                    this.highlight(1);
                    --this.bet;
                }
                if (this.mouseRect(174, 204, 26, 26, mouseX, mouseY) && this.bet < this.CONTAINER.getBettingHigh()) {
                    this.highlight(2);
                    ++this.bet;
                }
                if (this.mouseRect(82, 204, 92, 26, mouseX, mouseY)) {
                    if (!this.CONTAINER.hasToken()) {
                        this.start();
                    } else if (this.playerToken >= this.bet) {
                        this.collectBet();
                        this.playerToken = -1;
                        this.start();
                    }
                }
            } else if (this.CONTAINER.turnstate() == 5) {
                if (this.mouseRect(82, 204, 92, 26, mouseX, mouseY)) {
                    if (this.logic().hasHighscore()) {
                        this.turnstate(7);
                    } else {
                        this.reset();
                    }
                }
            } else if (this.CONTAINER.turnstate() == 7) {
                if (this.mouseRect(82, 204, 92, 26, mouseX, mouseY)) {
                    this.reset();
                }
            } else if (this.CONTAINER.logic().isMultiplayer() && this.CONTAINER.turnstate() == 2 && !this.isCurrentPlayer()) {
                if (this.CONTAINER.logic().hasFreePlayerSlots() && this.mouseRect(26, 237, 78, 22, mouseX, mouseY)) {
                    if (!this.CONTAINER.hasToken()) {
                        this.addNewPlayer();
                    } else if (this.playerToken >= this.bet) {
                        this.collectBet();
                        this.playerToken = -1;
                        this.addNewPlayer();
                    }
                }
            } else if (this.isCurrentPlayer()) {
                if (this.mouseRect(this.tableID == 1 ? 241 : 337, 241, 14, 14, mouseX, mouseY)) {
                    if (this.showForfeit) {
                        this.turnstate(4);
                    } else {
                        this.showForfeit = true;
                        this.highlightTimer = 100;
                    }
                }
                if (!(this.logic() instanceof LogicDummy)) {
                    this.mouseClickedSUB(mouseX, mouseY, mouseButton);
                }
            }
        }
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.highlightTimer > 0) {
            --this.highlightTimer;
            if (this.highlightTimer == 0) {
                this.highlightIndex = 0;
                this.showForfeit = false;
            }
        }
        this.colour += this.colourize;
        if (this.colour <= 0 || this.colour >= 0xFFFFFF) {
            this.colourize = -this.colourize;
        }
        if (this.showDebug) {
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYER1: " + this.logic().currentPlayer[0], this.tableID == 2 ? 355.0f : 260.0f, 15.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYER2: " + this.logic().currentPlayer[1], this.tableID == 2 ? 355.0f : 260.0f, 25.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYER3: " + this.logic().currentPlayer[2], this.tableID == 2 ? 355.0f : 260.0f, 35.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYER4: " + this.logic().currentPlayer[3], this.tableID == 2 ? 355.0f : 260.0f, 45.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYER5: " + this.logic().currentPlayer[4], this.tableID == 2 ? 355.0f : 260.0f, 55.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYER6: " + this.logic().currentPlayer[5], this.tableID == 2 ? 355.0f : 260.0f, 65.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "TIMEOUT: " + this.logic().timeout, this.tableID == 2 ? 355.0f : 260.0f, 75.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "STATE:   " + this.logic().turnstate, this.tableID == 2 ? 355.0f : 260.0f, 85.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "PLAYERS: " + this.logic().getFirstFreePlayerSlot(), this.tableID == 2 ? 355.0f : 260.0f, 95.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, "ACTIVE:  " + this.logic().activePlayer, this.tableID == 2 ? 355.0f : 260.0f, 105.0f, 0xFFFFFF);
        }
        if (this.logic() instanceof LogicDummy) {
            return;
        }
        if (this.playerToken == -1 && this.logic().turnstate < 4) {
            this.validateBet();
        }
        if (this.CONTAINER.logic().isMultiplayer() && this.CONTAINER.turnstate() == 2 && !this.isCurrentPlayer() && this.CONTAINER.logic().hasFreePlayerSlots()) {
            this.drawFont(matrixStack, "BET:", 158, 244);
            this.field_230707_j_.func_175042_a(this.CONTAINER.getItemToken(), 178, 240);
            if (this.CONTAINER.getBettingLow() > 1) {
                this.drawFont(matrixStack, "x" + this.CONTAINER.getBettingLow(), 208, 244);
            }
        }
        if (this.CONTAINER.turnstate() == 0 && this.tableID != 0) {
            if (this.tableID < 3) {
                if (this.CONTAINER.hasToken() && this.CONTAINER.getBettingHigh() > 0) {
                    if (this.CONTAINER.getBettingLow() == this.CONTAINER.getBettingHigh()) {
                        this.drawFont(matrixStack, "The bet is:", 30, 100);
                        this.field_230707_j_.func_175042_a(this.CONTAINER.getItemToken(), 100, 96);
                        if (this.CONTAINER.getBettingLow() > 1) {
                            this.drawFont(matrixStack, "x" + this.CONTAINER.getBettingLow(), 124, 100);
                        }
                    } else {
                        this.drawFont(matrixStack, "The bets are:", 30, 100);
                        this.field_230707_j_.func_175042_a(this.CONTAINER.getItemToken(), 100, 96);
                        this.drawFont(matrixStack, "x" + this.CONTAINER.getBettingLow() + " to x" + this.CONTAINER.getBettingHigh(), 124, 100);
                    }
                    if (this.playerToken < this.CONTAINER.getBettingLow()) {
                        this.drawFont(matrixStack, "You don't have enough Token to play...", 30, 120);
                    } else {
                        this.drawFont(matrixStack, "Do you wish to play?", 30, 120);
                    }
                    if (this.CONTAINER.getBettingHigh() != this.CONTAINER.getBettingLow()) {
                        this.drawFont(matrixStack, "Your Bet:  " + this.bet, 30, 140);
                    }
                }
            } else if (this.CONTAINER.hasToken() && this.CONTAINER.getBettingHigh() > 0) {
                this.field_230712_o_.func_238421_b_(matrixStack, "INSERT ", 128.0f, 210.0f, 0xFFFFFF);
                this.field_230707_j_.func_175042_a(this.CONTAINER.getItemToken(), 160, 206);
                if (this.CONTAINER.getBettingLow() > 1) {
                    this.field_230712_o_.func_238421_b_(matrixStack, "x" + this.CONTAINER.getBettingLow(), 180.0f, 210.0f, 0xFFFFFF);
                }
                this.field_230712_o_.func_238421_b_(matrixStack, "Press ENTER", 128.0f, 225.0f, 0xFFFFFF);
            }
        } else if (this.CONTAINER.turnstate() == 7 && this.tableID != 0) {
            for (int i = 0; i < 18; ++i) {
                this.drawFont(matrixStack, this.logic().scoreName[i], 40, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
                this.drawFontInvert(matrixStack, "" + this.logic().scoreHigh[i], 216, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
            }
        } else if (this.CONTAINER.turnstate() == 0 && this.tableID == 0) {
            if (this.CONTAINER.hasToken() && this.CONTAINER.getBettingHigh() > 0) {
                this.field_230712_o_.func_238421_b_(matrixStack, "INSERT ", 90.0f, 180.0f, 0xFFFFFF);
                this.field_230707_j_.func_175042_a(this.CONTAINER.getItemToken(), 126, 176);
                if (this.CONTAINER.getBettingLow() > 1) {
                    this.field_230712_o_.func_238421_b_(matrixStack, "x" + this.CONTAINER.getBettingLow(), 145.0f, 180.0f, 0xFFFFFF);
                }
                if (this.playerToken < this.CONTAINER.getBettingLow()) {
                    this.field_230712_o_.func_238421_b_(matrixStack, "NOT ENOUGH TOKEN", 80.0f, 220.0f, this.colour);
                } else {
                    this.field_230712_o_.func_238421_b_(matrixStack, "Press ENTER", 95.0f, 220.0f, this.colour);
                }
            } else {
                this.field_230712_o_.func_238421_b_(matrixStack, "Press ENTER", 95.0f, 220.0f, this.colour);
            }
        } else if (this.CONTAINER.turnstate() == 7 && this.tableID == 0) {
            for (int i = 0; i < 20; ++i) {
                this.drawFont(matrixStack, this.logic().scoreName[i], 40, 15 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
                this.drawFontInvert(matrixStack, "" + this.logic().scoreHigh[i], 216, 15 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
            }
            this.field_230712_o_.func_238421_b_(matrixStack, "Press ENTER", 95.0f, 220.0f, this.colour);
        } else {
            this.drawGuiContainerForegroundLayerSUB(matrixStack, mouseX, mouseY);
            if ((this.CONTAINER.turnstate() == 2 || this.CONTAINER.turnstate() == 3) && this.CONTAINER.logic().pause) {
                this.field_230712_o_.func_238421_b_(matrixStack, "PAUSE", 103.0f, 200.0f, 0xFFFFFF);
                this.field_230712_o_.func_238421_b_(matrixStack, "Press ENTER to FORFEIT", 65.0f, 220.0f, 0xFFFFFF);
            }
            if (this.showForfeit && this.showDebug) {
                this.field_230712_o_.func_238421_b_(matrixStack, "" + this.highlightTimer, 94.0f, 245.0f, 0);
            }
            if (this.CONTAINER.turnstate() == 5 && this.tableID == 0) {
                this.field_230712_o_.func_238421_b_(matrixStack, "GAME OVER", 103.0f, 200.0f, 0xFFFFFF);
                this.field_230712_o_.func_238421_b_(matrixStack, "Press ENTER", 95.0f, 220.0f, this.colour);
            }
            if (this.logic().turnstate == 4) {
                this.gameOver();
            }
        }
        if (this.CONTAINER.getID() != this.logic().getID()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tableID == 0) {
            if (this.logic() instanceof LogicDummy) {
                Random RANDOM = new Random();
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_STATIC);
                for (int y = 0; y < 8; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        this.func_238474_b_(matrixStack, this.field_147003_i + 32 + 32 * x, this.field_147009_r + 32 * y, 32 * RANDOM.nextInt(8), 32 * RANDOM.nextInt(8), 32, 32);
                    }
                }
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_GROUND_ARCADE);
                this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            } else {
                this.field_230706_i_.func_110434_K().func_110577_a(this.getParallaxTexture(true));
                this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, this.camera1, 256, 256);
                this.field_230706_i_.func_110434_K().func_110577_a(this.getParallaxTexture(false));
                this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, this.camera0, 256, 256);
            }
        } else if (this.tableID < 3) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.tableID == 0 ? CasinoKeeper.TEXTURE_GROUND_ARCADE : this.getBackground());
            if (this.tableID == 2) {
                this.func_238474_b_(matrixStack, this.field_147003_i - 128 + 32, this.field_147009_r, 0, 0, this.field_146999_f - 32, this.field_147000_g);
                this.func_238474_b_(matrixStack, this.field_147003_i + 128, this.field_147009_r, 32, 0, this.field_146999_f - 32, this.field_147000_g);
            } else {
                this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            }
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_SLOTMACHINE);
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        if (this.CONTAINER.turnstate() <= 1) {
            this.drawLogo(matrixStack);
        }
        if (this.logic() instanceof LogicDummy) {
            return;
        }
        if (this.CONTAINER.turnstate() >= 1 && this.CONTAINER.turnstate() < 6) {
            if (this.logic().pause) {
                GlStateManager.func_227702_d_((float)0.35f, (float)0.35f, (float)0.35f, (float)1.0f);
            }
            this.drawGuiContainerBackgroundLayerSUB(matrixStack, partialTicks, mouseX, mouseY);
            if (this.isCurrentPlayer()) {
                this.drawGuiContainerBackgroundLayerGUI(matrixStack, partialTicks, mouseX, mouseY);
            }
            if (this.logic().pause) {
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (!(this.CONTAINER.turnstate() != 5 && this.CONTAINER.turnstate() != 0 && this.CONTAINER.turnstate() != 7 || this.tableID != 1 && this.tableID != 2)) {
            if (this.CONTAINER.turnstate() == 5 && this.logic().hasHighscore()) {
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.func_238474_b_(matrixStack, this.field_147003_i + 89, this.field_147009_r + 206, 0, 22, 78, 22);
            } else if (this.CONTAINER.turnstate() == 5) {
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.func_238474_b_(matrixStack, this.field_147003_i + 89, this.field_147009_r + 206, 156, 22, 78, 22);
            } else if (this.CONTAINER.turnstate() == 7) {
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.func_238474_b_(matrixStack, this.field_147003_i + 89, this.field_147009_r + 206, 156, 22, 78, 22);
            } else if (!this.CONTAINER.hasToken() || this.playerToken >= this.CONTAINER.getBettingLow()) {
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.func_238474_b_(matrixStack, this.field_147003_i + 89, this.field_147009_r + 206, 78, 22, 78, 22);
            }
            if (this.CONTAINER.turnstate() == 0 && this.logic().hasHighscore()) {
                this.func_238474_b_(matrixStack, this.field_147003_i + 89, this.field_147009_r + 166, 0, 22, 78, 22);
            }
            if (this.CONTAINER.turnstate() == 0 && this.playerToken >= this.CONTAINER.getBettingLow()) {
                this.func_238474_b_(matrixStack, this.field_147003_i + 58, this.field_147009_r + 206, 234, 88 + (this.highlightIndex == 1 ? 22 : 0) + (this.bet == this.CONTAINER.getBettingLow() ? 44 : 0), 22, 22);
                this.func_238474_b_(matrixStack, this.field_147003_i + 176, this.field_147009_r + 206, 234, (this.highlightIndex == 2 ? 22 : 0) + (this.bet == this.CONTAINER.getBettingHigh() ? 44 : 0), 22, 22);
            }
        }
        if (this.CONTAINER.logic().isMultiplayer() && this.CONTAINER.turnstate() == 2 && !this.isCurrentPlayer() && this.CONTAINER.logic().hasFreePlayerSlots()) {
            this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
            this.func_238474_b_(matrixStack, this.field_147003_i + 153, this.field_147009_r + 237, 78, 220, 78, 22);
            if (!this.CONTAINER.hasToken() || this.playerToken >= this.CONTAINER.getBettingLow()) {
                this.func_238474_b_(matrixStack, this.field_147003_i + 26, this.field_147009_r + 237, 0, 220, 78, 22);
            }
            this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_DICE);
            this.func_238474_b_(matrixStack, this.field_147003_i + 128 - 16, this.field_147009_r + 232, 192, 32 + 32 * this.CONTAINER.logic().getFirstFreePlayerSlot(), 32, 32);
        }
        if (!(this.CONTAINER.logic().isMultiplayer() || this.CONTAINER.turnstate() != 2 || this.tableID != 1 && this.tableID != 2)) {
            this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
            this.func_238474_b_(matrixStack, this.field_147003_i + (this.tableID == 1 ? 241 : 337), this.field_147009_r + 241, this.showForfeit ? 14 : 0, 242, 14, 14);
            if (this.showForfeit) {
                this.func_238474_b_(matrixStack, this.field_147003_i + 128 - 39, this.field_147009_r + 241, 28, 242, 78, 14);
            }
        }
        if (this.tableID == 0) {
            int shift2;
            this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_GROUND_ARCADE);
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            int n = shift2 = this.CONTAINER.turnstate() == 2 || this.CONTAINER.turnstate() == 3 ? 2 : 1;
            if (this.CONTAINER.turnstate() != 5 && !this.CONTAINER.logic().pause) {
                this.camera1 = (this.camera1 + shift2) % 256;
            }
            if (this.CONTAINER.turnstate() != 5 && !this.CONTAINER.logic().pause) {
                this.camera0 = (this.camera0 + shift2 * 2) % 256;
            }
        }
        if ((this.logic().turnstate == 2 || this.logic().turnstate == 3) && this.logic().isMultiplayer()) {
            this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_DICE);
            for (int i = 0; i < this.logic().getFirstFreePlayerSlot(); ++i) {
                this.func_238474_b_(matrixStack, this.field_147003_i + (this.tableID == 2 ? 340 : 245), this.field_147009_r + 32 + 36 * i, 224, 32 + 32 * i, 32, 32);
            }
            if (this.logic().activePlayer < this.logic().getFirstFreePlayerSlot()) {
                this.func_238474_b_(matrixStack, this.field_147003_i + (this.tableID == 2 ? 340 : 245), this.field_147009_r + 32 + 36 * this.logic().activePlayer, 192, 32 + 32 * this.logic().activePlayer, 32, 32);
            }
        }
    }

    protected void highlight(int index) {
        this.highlightTimer = 10;
        this.highlightIndex = index;
    }

    private void gameOver() {
        int pos = this.getPlayerPosition();
        if (pos > -1 && this.playerToken != -1) {
            this.payBet(this.logic().reward[pos]);
            this.turnstate(10 + pos);
            this.playerToken = -1;
        }
        if (this.allCleared()) {
            this.turnstate(5);
            if (this.logic().hasHighscore()) {
                this.highscore();
            } else {
                this.turnstate(-3);
            }
        }
    }

    private boolean allCleared() {
        for (int i = 0; i < 6; ++i) {
            if (this.logic().reward[i] <= 0) continue;
            return false;
        }
        return true;
    }

    private void highscore() {
        CasinoPacketHandler.sendToServer(new MessageScoreServer(this.PLAYER.field_70458_d.func_200200_C_().getString(), this.logic().scorePoint, this.CONTAINER.pos()));
        int lastScore = 0;
        int prizeSET = 0;
        int prizeCON = 0;
        if (this.CONTAINER.getPrizeCount1() > 0) {
            if (this.CONTAINER.getPrizeMode1()) {
                if (this.CONTAINER.getPrizeScore1() <= this.CONTAINER.logic().scorePoint && this.CONTAINER.getPrizeScore1() > lastScore) {
                    lastScore = this.CONTAINER.getPrizeScore1();
                    prizeSET = this.CONTAINER.getPrizeCount1();
                }
            } else if (this.CONTAINER.getPrizeScore1() > 0) {
                prizeCON += this.CONTAINER.getPrizeCount1() * (this.CONTAINER.logic().scorePoint / this.CONTAINER.getPrizeScore1());
            }
        }
        if (this.CONTAINER.getPrizeCount2() > 0) {
            if (this.CONTAINER.getPrizeMode2()) {
                if (this.CONTAINER.getPrizeScore2() <= this.CONTAINER.logic().scorePoint && this.CONTAINER.getPrizeScore2() > lastScore) {
                    lastScore = this.CONTAINER.getPrizeScore2();
                    prizeSET = this.CONTAINER.getPrizeCount2();
                }
            } else if (this.CONTAINER.getPrizeScore2() > 0) {
                prizeCON += this.CONTAINER.getPrizeCount2() * (this.CONTAINER.logic().scorePoint / this.CONTAINER.getPrizeScore2());
            }
        }
        if (this.CONTAINER.getPrizeCount3() > 0) {
            if (this.CONTAINER.getPrizeMode3()) {
                if (this.CONTAINER.getPrizeScore3() <= this.CONTAINER.logic().scorePoint && this.CONTAINER.getPrizeScore3() > lastScore) {
                    lastScore = this.CONTAINER.getPrizeScore3();
                    prizeSET = this.CONTAINER.getPrizeCount3();
                }
            } else if (this.CONTAINER.getPrizeScore3() > 0) {
                prizeCON += this.CONTAINER.getPrizeCount3() * (this.CONTAINER.logic().scorePoint / this.CONTAINER.getPrizeScore3());
            }
        }
        this.payPrize(prizeSET + prizeCON);
    }

    private ResourceLocation getBackground() {
        if (this.CONTAINER.color == DyeColor.BLACK) {
            return CasinoKeeper.TEXTURE_GROUND_BLACK;
        }
        if (this.CONTAINER.color == DyeColor.BLUE) {
            return CasinoKeeper.TEXTURE_GROUND_BLUE;
        }
        if (this.CONTAINER.color == DyeColor.BROWN) {
            return CasinoKeeper.TEXTURE_GROUND_BROWN;
        }
        if (this.CONTAINER.color == DyeColor.CYAN) {
            return CasinoKeeper.TEXTURE_GROUND_CYAN;
        }
        if (this.CONTAINER.color == DyeColor.GRAY) {
            return CasinoKeeper.TEXTURE_GROUND_GRAY;
        }
        if (this.CONTAINER.color == DyeColor.GREEN) {
            return CasinoKeeper.TEXTURE_GROUND_GREEN;
        }
        if (this.CONTAINER.color == DyeColor.LIGHT_BLUE) {
            return CasinoKeeper.TEXTURE_GROUND_LIGHT_BLUE;
        }
        if (this.CONTAINER.color == DyeColor.LIME) {
            return CasinoKeeper.TEXTURE_GROUND_LIME;
        }
        if (this.CONTAINER.color == DyeColor.MAGENTA) {
            return CasinoKeeper.TEXTURE_GROUND_MAGENTA;
        }
        if (this.CONTAINER.color == DyeColor.ORANGE) {
            return CasinoKeeper.TEXTURE_GROUND_ORANGE;
        }
        if (this.CONTAINER.color == DyeColor.PINK) {
            return CasinoKeeper.TEXTURE_GROUND_PINK;
        }
        if (this.CONTAINER.color == DyeColor.PURPLE) {
            return CasinoKeeper.TEXTURE_GROUND_PURPLE;
        }
        if (this.CONTAINER.color == DyeColor.RED) {
            return CasinoKeeper.TEXTURE_GROUND_RED;
        }
        if (this.CONTAINER.color == DyeColor.LIGHT_GRAY) {
            return CasinoKeeper.TEXTURE_GROUND_LIGHT_GRAY;
        }
        if (this.CONTAINER.color == DyeColor.WHITE) {
            return CasinoKeeper.TEXTURE_GROUND_WHITE;
        }
        if (this.CONTAINER.color == DyeColor.YELLOW) {
            return CasinoKeeper.TEXTURE_GROUND_YELLOW;
        }
        return CasinoKeeper.TEXTURE_GROUND_GRAY;
    }

    protected boolean mouseRect(int x, int y, int width, int height, double mouseX, double mouseY) {
        if ((double)(this.field_147003_i + x) < mouseX && mouseX < (double)(this.field_147003_i + x + width)) {
            return (double)(this.field_147009_r + y) < mouseY && mouseY < (double)(this.field_147009_r + y + height);
        }
        return false;
    }

    protected void validateBet() {
        this.playerToken = -2;
        if (this.bet < this.CONTAINER.getBettingLow()) {
            this.bet = this.CONTAINER.getBettingLow();
        }
        if (this.bet > this.CONTAINER.getBettingHigh()) {
            this.bet = this.CONTAINER.getBettingHigh();
        }
        if (this.CONTAINER.hasToken()) {
            Item item = this.CONTAINER.getItemToken().func_77973_b();
            int count = 0;
            for (int i = 0; i < 36; ++i) {
                if (item != this.PLAYER.func_70301_a(i).func_77973_b()) continue;
                count += this.PLAYER.func_70301_a(i).func_190916_E();
            }
            this.playerToken = count;
        }
    }

    protected boolean anotherBet() {
        this.validateBet();
        if (this.playerToken >= this.bet) {
            this.collectBet();
            return true;
        }
        return false;
    }

    protected void collectBet() {
        if (this.CONTAINER.hasToken()) {
            InventoryUtil.decreaseInventory(this.PLAYER, this.CONTAINER.getItemToken(), this.bet);
            int i = 0;
            ItemStack itemStack = ItemStack.field_190927_a;
            Predicate<ItemStack> p_195408_1_ = Predicate.isEqual(this.CONTAINER.getItemToken());
            int count = this.bet;
            for (int j = 0; j < this.PLAYER.func_70302_i_(); ++j) {
                ItemStack itemstack = this.PLAYER.func_70301_a(j);
                if (itemstack.func_190926_b() || !p_195408_1_.test(itemstack)) continue;
                int k = count <= 0 ? itemstack.func_190916_E() : Math.min(count - i, itemstack.func_190916_E());
                i += k;
                if (count == 0) continue;
                itemstack.func_190918_g(k);
                if (!itemstack.func_190926_b()) continue;
                this.PLAYER.func_70299_a(j, ItemStack.field_190927_a);
            }
            if (!itemStack.func_190926_b() && p_195408_1_.test(itemStack)) {
                int l;
                int n = l = count <= 0 ? itemStack.func_190916_E() : Math.min(count - i, itemStack.func_190916_E());
                if (count != 0) {
                    itemStack.func_190918_g(l);
                }
            }
            CasinoPacketHandler.sendToServer(new MessagePlayerServer(this.CONTAINER.getItemToken().func_77973_b(), -this.bet));
            if (!this.CONTAINER.getSettingInfiniteToken()) {
                this.CONTAINER.setStorageToken(this.CONTAINER.getStorageToken() + this.bet);
                this.sendMessageBlock();
            }
        }
    }

    private void payBet(int multi) {
        if (multi <= 0) {
            return;
        }
        if (this.CONTAINER.hasToken()) {
            if (!this.CONTAINER.getSettingInfiniteToken()) {
                Item item = this.CONTAINER.getItemToken().func_77973_b();
                int count = this.bet * multi;
                int count2 = 0;
                count2 = Math.min(this.CONTAINER.getStorageToken(), count);
                this.CONTAINER.setStorageToken(this.CONTAINER.getStorageToken() - count);
                if (this.CONTAINER.getStorageToken() <= 0) {
                    this.CONTAINER.setStorageToken(0);
                    this.CONTAINER.setItemToken(new ItemStack((IItemProvider)Blocks.field_150350_a));
                }
                this.sendMessageBlock();
                this.PLAYER.func_70441_a(new ItemStack((IItemProvider)item, count2));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count2));
            } else {
                Item item = this.CONTAINER.getItemToken().func_77973_b();
                int count = this.bet * multi;
                this.PLAYER.func_70441_a(new ItemStack((IItemProvider)item, count));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count));
            }
        }
    }

    private void payPrize(int amount) {
        if (amount <= 0) {
            return;
        }
        if (this.CONTAINER.hasReward()) {
            if (!this.CONTAINER.getSettingInfinitePrize()) {
                Item item = this.CONTAINER.getItemPrize().func_77973_b();
                int count = amount;
                int count2 = 0;
                count2 = Math.min(this.CONTAINER.getStoragePrize(), count);
                this.CONTAINER.setStoragePrize(this.CONTAINER.getStoragePrize() - count);
                if (this.CONTAINER.getStoragePrize() <= 0) {
                    this.CONTAINER.setStoragePrize(0);
                    this.CONTAINER.setItemPrize(new ItemStack((IItemProvider)Blocks.field_150350_a));
                }
                this.sendMessageBlock();
                this.PLAYER.func_70441_a(new ItemStack((IItemProvider)item, count2));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count2));
            } else {
                Item item = this.CONTAINER.getItemPrize().func_77973_b();
                int count = amount;
                this.PLAYER.func_70441_a(new ItemStack((IItemProvider)item, count));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count));
            }
        }
    }

    protected void action(int action) {
        CasinoPacketHandler.sendToServer(new MessageStateServer(false, action, this.CONTAINER.pos()));
    }

    protected void start() {
        Random r = new Random();
        CasinoPacketHandler.sendToServer(new MessageStartServer(this.PLAYER.field_70458_d.func_200200_C_().getString(), r.nextInt(1000000), this.CONTAINER.pos()));
    }

    private void reset() {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, 0, this.CONTAINER.pos()));
    }

    protected void turnstate(int state) {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, state, this.CONTAINER.pos()));
    }

    private void addNewPlayer() {
        CasinoPacketHandler.sendToServer(new MessageStartServer(this.PLAYER.field_70458_d.func_200200_C_().getString(), -1, this.CONTAINER.pos()));
    }

    protected boolean isCurrentPlayer() {
        if (this.CONTAINER.logic().isMultiplayer()) {
            if (this.CONTAINER.getCurrentPlayer(0).matches("void")) {
                return true;
            }
            for (int i = 0; i < 6; ++i) {
                if (!this.CONTAINER.getCurrentPlayer(i).matches(this.PLAYER.field_70458_d.func_200200_C_().getString())) continue;
                return true;
            }
        } else {
            return this.CONTAINER.getCurrentPlayer(0).matches("void") || this.CONTAINER.getCurrentPlayer(0).matches(this.PLAYER.field_70458_d.func_200200_C_().getString());
        }
        return false;
    }

    protected boolean isActivePlayer() {
        if (this.CONTAINER.logic().isMultiplayer()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.CONTAINER.getCurrentPlayer(i).matches(this.PLAYER.field_70458_d.func_200200_C_().getString()) || i != this.logic().activePlayer) continue;
                return true;
            }
        } else {
            return this.CONTAINER.getCurrentPlayer(0).matches(this.PLAYER.field_70458_d.func_200200_C_().getString());
        }
        return false;
    }

    protected int getPlayerPosition() {
        if (this.CONTAINER.logic().isMultiplayer()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.CONTAINER.getCurrentPlayer(i).matches(this.PLAYER.field_70458_d.func_200200_C_().getString())) continue;
                return i;
            }
        } else {
            return this.CONTAINER.getCurrentPlayer(0).matches(this.PLAYER.field_70458_d.func_200200_C_().getString()) ? 0 : -1;
        }
        return -1;
    }

    protected void drawFont(MatrixStack matrixStack, String text, int x, int y) {
        this.drawFont(matrixStack, text, x, y, 0xFFFFFF);
    }

    protected void drawFont(MatrixStack matrixStack, String text, int x, int y, int color) {
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)(x + 1), (float)(y + 1), 0);
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)(x + 0), (float)(y + 0), color);
    }

    protected void drawFontInvert(MatrixStack matrixStack, String text, int x, int y) {
        this.drawFontInvert(matrixStack, text, x, y, 0xFFFFFF);
    }

    protected void drawFontInvert(MatrixStack matrixStack, String text, int x, int y, int color) {
        int w = this.field_230712_o_.func_78256_a(text);
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)(x + 1 - w), (float)(y + 1), 0);
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)(x + 0 - w), (float)(y + 0), color);
    }

    protected void drawFontCenter(MatrixStack matrixStack, String text, int x, int y) {
        this.drawFontCenter(matrixStack, text, x, y, 0xFFFFFF);
    }

    protected void drawFontCenter(MatrixStack matrixStack, String text, int x, int y, int color) {
        int w = this.field_230712_o_.func_78256_a(text);
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)(x + 1 - w / 2), (float)(y + 1), 0);
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)(x + 0 - w / 2), (float)(y + 0), color);
    }

    public void drawCard(MatrixStack matrixStack, int posX, int posY, Card card) {
        int texY;
        if (card.suit == -1) {
            return;
        }
        if (card.hidden) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.getCardsTexture(true));
        } else {
            if (card.suit <= 1) {
                this.field_230706_i_.func_110434_K().func_110577_a(this.getCardsTexture(false));
            }
            if (card.suit >= 2) {
                this.field_230706_i_.func_110434_K().func_110577_a(this.getCardsTexture(true));
            }
        }
        int texX = card.suit == -1 || card.hidden ? 0 : card.number % 8;
        int n = texY = card.suit == -1 || card.hidden ? 4 : card.suit % 2 * 2 + card.number / 8;
        if (((Boolean)CasinoKeeper.config_animated_cards.get()).booleanValue() && !card.hidden && card.number >= 10 && this.logic().frame == card.suit * 12 + (card.number - 10) * 3) {
            texX += 3;
        }
        this.func_238474_b_(matrixStack, this.field_147003_i + posX + card.shiftX, this.field_147009_r + posY + card.shiftY, texX * 32, texY * 48, 32, 48 - card.deathtimer);
    }

    public void drawCardBack(MatrixStack matrixStack, int posX, int posY, int color) {
        if (color <= 6) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.getCardsTexture(true));
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(this.getCardsTexture(false));
        }
        this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, color % 7 * 32, 192, 32, 48);
    }

    private void drawLetter(MatrixStack matrixStack, char c, int posX, int posY, int sizeX, int sizeY) {
        if (c == 'a') {
            this.func_238474_b_(matrixStack, posX, posY, 0, 0, sizeX, sizeY);
        }
        if (c == 'b') {
            this.func_238474_b_(matrixStack, posX, posY, sizeX, 0, sizeX, sizeY);
        }
        if (c == 'c') {
            this.func_238474_b_(matrixStack, posX, posY, 2 * sizeX, 0, sizeX, sizeY);
        }
        if (c == 'd') {
            this.func_238474_b_(matrixStack, posX, posY, 3 * sizeX, 0, sizeX, sizeY);
        }
        if (c == 'e') {
            this.func_238474_b_(matrixStack, posX, posY, 4 * sizeX, 0, sizeX, sizeY);
        }
        if (c == 'f') {
            this.func_238474_b_(matrixStack, posX, posY, 5 * sizeX, 0, sizeX, sizeY);
        }
        if (c == 'g') {
            this.func_238474_b_(matrixStack, posX, posY, 6 * sizeX, 0, sizeX, sizeY);
        }
        if (c == 'h') {
            this.func_238474_b_(matrixStack, posX, posY, 7 * sizeX, 0, sizeX, sizeY);
        }
        if (c == 'i') {
            this.func_238474_b_(matrixStack, posX, posY, 0, sizeY, sizeX, sizeY);
        }
        if (c == 'j') {
            this.func_238474_b_(matrixStack, posX, posY, sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'k') {
            this.func_238474_b_(matrixStack, posX, posY, 2 * sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'l') {
            this.func_238474_b_(matrixStack, posX, posY, 3 * sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'm') {
            this.func_238474_b_(matrixStack, posX, posY, 4 * sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'n') {
            this.func_238474_b_(matrixStack, posX, posY, 5 * sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'o') {
            this.func_238474_b_(matrixStack, posX, posY, 6 * sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'p') {
            this.func_238474_b_(matrixStack, posX, posY, 7 * sizeX, sizeY, sizeX, sizeY);
        }
        if (c == 'q') {
            this.func_238474_b_(matrixStack, posX, posY, 0, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 'r') {
            this.func_238474_b_(matrixStack, posX, posY, sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 's') {
            this.func_238474_b_(matrixStack, posX, posY, 2 * sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 't') {
            this.func_238474_b_(matrixStack, posX, posY, 3 * sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 'u') {
            this.func_238474_b_(matrixStack, posX, posY, 4 * sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 'v') {
            this.func_238474_b_(matrixStack, posX, posY, 5 * sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 'w') {
            this.func_238474_b_(matrixStack, posX, posY, 6 * sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 'x') {
            this.func_238474_b_(matrixStack, posX, posY, 7 * sizeX, 2 * sizeY, sizeX, sizeY);
        }
        if (c == 'y') {
            this.func_238474_b_(matrixStack, posX, posY, 0, 3 * sizeY, sizeX, sizeY);
        }
        if (c == 'z') {
            this.func_238474_b_(matrixStack, posX, posY, sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '0') {
            this.func_238474_b_(matrixStack, posX, posY, 2 * sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '1') {
            this.func_238474_b_(matrixStack, posX, posY, 3 * sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '2') {
            this.func_238474_b_(matrixStack, posX, posY, 4 * sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '3') {
            this.func_238474_b_(matrixStack, posX, posY, 5 * sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '4') {
            this.func_238474_b_(matrixStack, posX, posY, 6 * sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '5') {
            this.func_238474_b_(matrixStack, posX, posY, 7 * sizeX, 3 * sizeY, sizeX, sizeY);
        }
        if (c == '6') {
            this.func_238474_b_(matrixStack, posX, posY, 0, 4 * sizeY, sizeX, sizeY);
        }
        if (c == '7') {
            this.func_238474_b_(matrixStack, posX, posY, sizeX, 4 * sizeY, sizeX, sizeY);
        }
        if (c == '8') {
            this.func_238474_b_(matrixStack, posX, posY, 2 * sizeX, 4 * sizeY, sizeX, sizeY);
        }
        if (c == '9') {
            this.func_238474_b_(matrixStack, posX, posY, 3 * sizeX, 4 * sizeY, sizeX, sizeY);
        }
    }

    private void drawLogo(MatrixStack matrixStack) {
        int sizeX = 0;
        String[] logo = this.getGameName().split("_");
        if (this.tableID <= 2) {
            if (this.tableID == 0) {
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_FONT_ARCADE);
                sizeX = 16;
            } else if (this.tableID == 1 || this.tableID == 2) {
                this.field_230706_i_.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_FONT_CARDTABLE);
                sizeX = 32;
            }
            for (int i = 0; i < logo.length; ++i) {
                for (int k = 0; k < logo[i].length(); ++k) {
                    this.drawLetter(matrixStack, logo[i].charAt(k), this.field_147003_i + 128 - logo[i].length() * (sizeX / 2) + sizeX * k, this.field_147009_r + 32 + 32 * i, 32, 32);
                }
            }
        }
    }

    protected void drawMino(MatrixStack matrixStack, int posX, int posY, int idX, int idY) {
        this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, 24 * idX, 24 * idY, 24, 24);
    }

    protected void drawMino(MatrixStack matrixStack, int posX, int posY) {
        this.drawMino(matrixStack, posX, posY, 0, 0);
    }

    protected void drawMinoSmall(MatrixStack matrixStack, int posX, int posY, int id, boolean alternate) {
        if (alternate) {
            this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, 240, 16 * id, 16, 16);
        } else {
            this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, 16 * id, 240, 16, 16);
        }
    }

    protected void drawMinoSmall(MatrixStack matrixStack, int posX, int posY) {
        this.drawMinoSmall(matrixStack, posX, posY, 0, false);
    }

    protected void drawDigi(MatrixStack matrixStack, int posX, int posY, int idX, int idY) {
        this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, 16 * idX, 16 + 16 * idY, 16, 16);
    }

    protected void drawDigi(MatrixStack matrixStack, int posX, int posY) {
        this.drawDigi(matrixStack, posX, posY, 0, 0);
    }

    protected void drawDigiSmall(MatrixStack matrixStack, int posX, int posY, int id) {
        this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, 16 * id, 16, 6, 6);
        this.func_238474_b_(matrixStack, this.field_147003_i + posX + 6, this.field_147009_r + posY, 16 * id + 10, 16, 6, 6);
        this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY + 6, 16 * id, 26, 6, 6);
        this.func_238474_b_(matrixStack, this.field_147003_i + posX + 6, this.field_147009_r + posY + 6, 16 * id + 10, 26, 6, 6);
    }

    protected void drawDigiSmall(MatrixStack matrixStack, int posX, int posY) {
        this.drawDigiSmall(matrixStack, posX, posY, 0);
    }

    protected void drawDigiSymbol(MatrixStack matrixStack, int posX, int posY, int id) {
        this.func_238474_b_(matrixStack, this.field_147003_i + posX, this.field_147009_r + posY, 16 * id, 0, 16, 16);
    }

    protected void drawDigiSymbol(MatrixStack matrixStack, int posX, int posY) {
        this.drawDigiSymbol(matrixStack, posX, posY, 0);
    }

    protected void drawButton(MatrixStack matrixStack, int posX, int posY, int id) {
    }

    protected void drawShip(MatrixStack matrixStack, Ship ship, int shipID, int lookDirection, boolean animate) {
        int frame;
        int n = frame = this.logic().turnstate < 4 && animate ? this.logic().frame % 12 / 2 : 0;
        if (frame == 4) {
            frame = 2;
        }
        if (frame == 5) {
            frame = 1;
        }
        int direction = lookDirection == -1 ? ship.getLookDirection() : lookDirection;
        this.func_238474_b_(matrixStack, this.field_147003_i + 32 + ship.getPos().X, this.field_147009_r + 8 + ship.getPos().Y, 64 * (shipID % 4) + 16 * frame, 128 + direction * 16 + shipID / 4 * 64, 16, 16);
    }

    protected void drawShip(MatrixStack matrixStack, Vector2 vec, int shipID) {
        int frame;
        int n = frame = this.logic().turnstate < 4 ? this.logic().frame % 12 / 2 : 0;
        if (frame == 4) {
            frame = 2;
        }
        if (frame == 5) {
            frame = 1;
        }
        this.func_238474_b_(matrixStack, this.field_147003_i + 32 + vec.X * 16, this.field_147009_r + 8 + vec.Y * 16, 64 * (shipID % 4) + 16 * frame, 128 + shipID / 4 * 64, 16, 16);
    }

    private ResourceLocation getParallaxTexture(boolean lowTexture) {
        switch (this.CONTAINER.getSettingAlternateColor()) {
            case 0: {
                return lowTexture ? CasinoKeeper.TEXTURE_PARALLAX_0_LOW : CasinoKeeper.TEXTURE_PARALLAX_0_HIGH;
            }
            case 1: {
                return lowTexture ? CasinoKeeper.TEXTURE_PARALLAX_1_LOW : CasinoKeeper.TEXTURE_PARALLAX_1_HIGH;
            }
            case 2: {
                return lowTexture ? CasinoKeeper.TEXTURE_PARALLAX_2_LOW : CasinoKeeper.TEXTURE_PARALLAX_2_HIGH;
            }
            case 3: {
                return lowTexture ? CasinoKeeper.TEXTURE_PARALLAX_3_LOW : CasinoKeeper.TEXTURE_PARALLAX_3_HIGH;
            }
            case 4: {
                return lowTexture ? CasinoKeeper.TEXTURE_PARALLAX_4_LOW : CasinoKeeper.TEXTURE_PARALLAX_4_HIGH;
            }
            case 5: {
                return lowTexture ? CasinoKeeper.TEXTURE_PARALLAX_5_LOW : CasinoKeeper.TEXTURE_PARALLAX_5_HIGH;
            }
        }
        return CasinoKeeper.TEXTURE_STATIC;
    }

    protected ResourceLocation getCardsTexture(boolean noirTexture) {
        switch (this.CONTAINER.getSettingAlternateColor()) {
            case 0: {
                return noirTexture ? CasinoKeeper.TEXTURE_CARDS_0_NOIR : CasinoKeeper.TEXTURE_CARDS_0_ROUGE;
            }
            case 1: {
                return noirTexture ? CasinoKeeper.TEXTURE_CARDS_1_NOIR : CasinoKeeper.TEXTURE_CARDS_1_ROUGE;
            }
            case 2: {
                return noirTexture ? CasinoKeeper.TEXTURE_CARDS_2_NOIR : CasinoKeeper.TEXTURE_CARDS_2_ROUGE;
            }
            case 3: {
                return noirTexture ? CasinoKeeper.TEXTURE_CARDS_3_NOIR : CasinoKeeper.TEXTURE_CARDS_3_ROUGE;
            }
            case 4: {
                return noirTexture ? CasinoKeeper.TEXTURE_CARDS_4_NOIR : CasinoKeeper.TEXTURE_CARDS_4_ROUGE;
            }
            case 5: {
                return noirTexture ? CasinoKeeper.TEXTURE_CARDS_5_NOIR : CasinoKeeper.TEXTURE_CARDS_5_ROUGE;
            }
        }
        return CasinoKeeper.TEXTURE_STATIC;
    }

    private void sendMessageBlock() {
        NonNullList inv = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        inv.set(0, (Object)this.CONTAINER.inventory.func_70301_a(0));
        inv.set(1, (Object)this.CONTAINER.inventory.func_70301_a(1));
        inv.set(2, (Object)this.CONTAINER.inventory.func_70301_a(2));
        inv.set(3, (Object)this.CONTAINER.inventory.func_70301_a(3));
        inv.set(4, (Object)this.CONTAINER.inventory.func_70301_a(4));
        CasinoPacketHandler.sendToServer(new MessageInventoryServer((NonNullList<ItemStack>)inv, this.CONTAINER.getStorageToken(), this.CONTAINER.getStoragePrize(), this.CONTAINER.pos()));
    }

    protected abstract void mouseClickedSUB(double var1, double var3, int var5);

    protected abstract void drawGuiContainerForegroundLayerSUB(MatrixStack var1, int var2, int var3);

    protected abstract void drawGuiContainerBackgroundLayerSUB(MatrixStack var1, float var2, int var3, int var4);

    protected abstract void drawGuiContainerBackgroundLayerGUI(MatrixStack var1, float var2, int var3, int var4);

    protected abstract String getGameName();
}

