/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerMachine;
import mod.casinocraft.network.MessageSettingServer;
import mod.casinocraft.network.MessageStateServer;
import mod.casinocraft.system.CasinoPacketHandler;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ScreenMachine
extends ContainerScreen<ContainerMachine> {
    private static final ResourceLocation GUI_TEXTURE0 = new ResourceLocation("casinocraft:textures/gui/inventory0.png");
    private static final ResourceLocation GUI_TEXTURE1 = new ResourceLocation("casinocraft:textures/gui/inventory1.png");
    private static final ResourceLocation GUI_TEXTURE2 = new ResourceLocation("casinocraft:textures/gui/inventory2.png");
    private static final ResourceLocation GUI_TEXTURE3 = new ResourceLocation("casinocraft:textures/gui/inventory3.png");
    private static final ResourceLocation GUI_TEXTURE4 = new ResourceLocation("casinocraft:textures/gui/inventory4.png");
    private final PlayerInventory PLAYER;
    protected final ContainerMachine CONTAINER;
    private int page = 0;
    private int activeInput = 0;
    private String input = "";
    private boolean hasReset = false;
    private int highlightIndex = 0;
    private int highlightTimer = 0;

    public ScreenMachine(ContainerMachine container, PlayerInventory player, ITextComponent name) {
        super((Container)container, player, name);
        this.PLAYER = player;
        this.CONTAINER = container;
        this.field_146999_f = 176;
        this.field_147000_g = 204;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        this.keyTyped(keyCode);
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        boolean handled = this.func_195363_d(keyCode, scanCode);
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 0, ClickType.CLONE);
                handled = true;
            } else if (this.field_230706_i_.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, ScreenMachine.func_231172_r_() ? 1 : 0, ClickType.THROW);
                handled = true;
            }
        } else if (this.field_230706_i_.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
            handled = true;
        }
        return handled;
    }

    private void keyTyped(int keyCode) {
        if (this.activeInput > 0) {
            if (keyCode == 257) {
                if (this.input.length() == 0) {
                    this.input = "0";
                }
                int temp = Integer.parseInt(this.input);
                this.commandSetScore(this.activeInput - 1, temp);
                this.activeInput = 0;
            }
            if (keyCode == 259) {
                if (this.input.length() == 1) {
                    this.input = "";
                } else if (this.input.length() > 1) {
                    this.input = this.input.substring(0, this.input.length() - 1);
                }
            }
            if (keyCode == 49) {
                this.input = this.input + "1";
            }
            if (keyCode == 50) {
                this.input = this.input + "2";
            }
            if (keyCode == 51) {
                this.input = this.input + "3";
            }
            if (keyCode == 52) {
                this.input = this.input + "4";
            }
            if (keyCode == 53) {
                this.input = this.input + "5";
            }
            if (keyCode == 54) {
                this.input = this.input + "6";
            }
            if (keyCode == 55) {
                this.input = this.input + "7";
            }
            if (keyCode == 56) {
                this.input = this.input + "8";
            }
            if (keyCode == 57) {
                this.input = this.input + "9";
            }
            if (keyCode == 48) {
                this.input = this.input + "0";
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.hasKey() && this.activeInput == 0) {
            if (this.mouseRect(58, 0, 56, 24, mouseX, mouseY)) {
                this.commandChangePage(0);
            }
            if (this.mouseRect(116, 0, 56, 24, mouseX, mouseY)) {
                this.commandChangePage(1);
            }
            if (this.mouseRect(174, 0, 56, 24, mouseX, mouseY)) {
                this.commandChangePage(2);
            }
            if (this.page == 0) {
                if (this.mouseRect(60, 30, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(0);
                }
                if (this.mouseRect(60, 43, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(1);
                }
                if (this.mouseRect(60, 56, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(2);
                }
                if (this.mouseRect(60, 69, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(3);
                }
                if (this.mouseRect(60, 83, 12, 12, mouseX, mouseY)) {
                    this.commandResetGameState();
                }
                if (this.mouseRect(60, 96, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(4);
                }
            } else if (this.page == 1) {
                if (this.mouseRect(61, 31, 40, 20, mouseX, mouseY)) {
                    this.commandTransfer(true, true);
                }
                if (this.mouseRect(178, 31, 40, 20, mouseX, mouseY)) {
                    this.commandTransfer(true, false);
                }
                if (this.mouseRect(193, 73, 16, 16, mouseX, mouseY)) {
                    this.highlight(1);
                    this.commandChangeBet(false, false);
                }
                if (this.mouseRect(211, 73, 16, 16, mouseX, mouseY)) {
                    this.highlight(2);
                    this.commandChangeBet(true, false);
                }
                if (this.mouseRect(193, 91, 16, 16, mouseX, mouseY)) {
                    this.highlight(3);
                    this.commandChangeBet(false, true);
                }
                if (this.mouseRect(211, 91, 16, 16, mouseX, mouseY)) {
                    this.highlight(4);
                    this.commandChangeBet(true, true);
                }
            } else if (this.page == 2) {
                if (this.mouseRect(61, 31, 40, 20, mouseX, mouseY)) {
                    this.commandTransfer(false, true);
                }
                if (this.mouseRect(178, 31, 40, 20, mouseX, mouseY)) {
                    this.commandTransfer(false, false);
                }
                if (this.mouseRect(193, 55, 16, 16, mouseX, mouseY)) {
                    this.highlight(5);
                    this.commandChangeReward(false, 0);
                }
                if (this.mouseRect(211, 55, 16, 16, mouseX, mouseY)) {
                    this.highlight(6);
                    this.commandChangeReward(true, 0);
                }
                if (this.mouseRect(193, 73, 16, 16, mouseX, mouseY)) {
                    this.highlight(7);
                    this.commandChangeReward(false, 1);
                }
                if (this.mouseRect(211, 73, 16, 16, mouseX, mouseY)) {
                    this.highlight(8);
                    this.commandChangeReward(true, 1);
                }
                if (this.mouseRect(193, 91, 16, 16, mouseX, mouseY)) {
                    this.highlight(9);
                    this.commandChangeReward(false, 2);
                }
                if (this.mouseRect(211, 91, 16, 16, mouseX, mouseY)) {
                    this.highlight(10);
                    this.commandChangeReward(true, 2);
                }
                if (this.mouseRect(79, 55, 16, 16, mouseX, mouseY)) {
                    this.input = "";
                    this.activeInput = 1;
                }
                if (this.mouseRect(79, 73, 16, 16, mouseX, mouseY)) {
                    this.input = "";
                    this.activeInput = 2;
                }
                if (this.mouseRect(79, 91, 16, 16, mouseX, mouseY)) {
                    this.input = "";
                    this.activeInput = 3;
                }
                if (this.mouseRect(61, 55, 16, 16, mouseX, mouseY)) {
                    this.commandTogglePrize(0);
                }
                if (this.mouseRect(61, 73, 16, 16, mouseX, mouseY)) {
                    this.commandTogglePrize(1);
                }
                if (this.mouseRect(61, 91, 16, 16, mouseX, mouseY)) {
                    this.commandTogglePrize(2);
                }
            }
        }
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixstack, int mouseX, int mouseY) {
        if (this.activeInput == 0) {
            if (this.hasKey()) {
                if (this.page == 1) {
                    this.field_230707_j_.func_175042_a(this.CONTAINER.getItemToken(), 51, 33);
                    String text = this.CONTAINER.getStorageToken() == 0 ? "EMPTY" : (this.CONTAINER.getSettingInfiniteToken() ? "x(INFINITE)" : "x " + this.CONTAINER.getStorageToken());
                    this.field_230712_o_.func_238421_b_(matrixstack, text, 69.0f, 37.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getBettingLow(), 106.0f, 77.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getBettingHigh(), 106.0f, 95.0f, 0x404040);
                } else if (this.page == 2) {
                    this.field_230707_j_.func_175042_a(this.CONTAINER.getItemPrize(), 51, 33);
                    String text = this.CONTAINER.getStoragePrize() == 0 ? "EMPTY" : (this.CONTAINER.getSettingInfinitePrize() ? "x(INFINITE)" : "x " + this.CONTAINER.getStoragePrize());
                    this.field_230712_o_.func_238421_b_(matrixstack, text, 69.0f, 37.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getPrizeScore1(), 50.0f, 59.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getPrizeScore2(), 50.0f, 77.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getPrizeScore3(), 50.0f, 95.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getPrizeCount1(), 106.0f, 59.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getPrizeCount2(), 106.0f, 77.0f, 0x404040);
                    this.field_230712_o_.func_238421_b_(matrixstack, "" + this.CONTAINER.getPrizeCount3(), 106.0f, 95.0f, 0x404040);
                }
            }
        } else {
            this.field_230712_o_.func_238421_b_(matrixstack, this.input.length() == 0 ? "0" : this.input, 57.0f, 91.0f, 0x404040);
        }
    }

    protected void func_230450_a_(MatrixStack matrixstack, float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.getTexture());
        int i = (this.field_230708_k_ - this.field_146999_f) / 2 - 56;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixstack, i, j, 0, 0, this.field_146999_f + 56, this.field_147000_g);
        if (this.activeInput == 0 && this.hasKey()) {
            if (this.page == 0) {
                if (this.CONTAINER.getSettingInfiniteToken()) {
                    this.func_238474_b_(matrixstack, i + 60, j + 30, 108, 244, 12, 12);
                }
                if (this.CONTAINER.getSettingInfinitePrize()) {
                    this.func_238474_b_(matrixstack, i + 60, j + 43, 108, 244, 12, 12);
                }
                if (this.CONTAINER.getSettingDropOnBreak()) {
                    this.func_238474_b_(matrixstack, i + 60, j + 56, 108, 244, 12, 12);
                }
                if (this.CONTAINER.getSettingIndestructable()) {
                    this.func_238474_b_(matrixstack, i + 60, j + 69, 108, 244, 12, 12);
                }
                if (this.hasReset) {
                    this.func_238474_b_(matrixstack, i + 60, j + 83, 84, 244, 12, 12);
                }
                this.func_238474_b_(matrixstack, i + 60, j + 96, this.CONTAINER.getSettingAlternateColor() * 12, 244, 12, 12);
            } else if (this.page == 1) {
                if (this.CONTAINER.getTransferTokenIN()) {
                    this.func_238474_b_(matrixstack, i + 61, j + 31, 40, 236, 40, 20);
                }
                if (this.CONTAINER.getTransferTokenOUT()) {
                    this.func_238474_b_(matrixstack, i + 187, j + 31, 120, 236, 40, 20);
                }
                if (this.highlightIndex == 1) {
                    this.func_238474_b_(matrixstack, i + 193, j + 73, 176, 240, 16, 16);
                }
                if (this.highlightIndex == 2) {
                    this.func_238474_b_(matrixstack, i + 211, j + 73, 208, 240, 16, 16);
                }
                if (this.highlightIndex == 3) {
                    this.func_238474_b_(matrixstack, i + 193, j + 91, 176, 240, 16, 16);
                }
                if (this.highlightIndex == 4) {
                    this.func_238474_b_(matrixstack, i + 211, j + 91, 208, 240, 16, 16);
                }
            } else if (this.page == 2) {
                if (this.CONTAINER.getTransferPrizeIN()) {
                    this.func_238474_b_(matrixstack, i + 61, j + 31, 40, 236, 40, 20);
                }
                if (this.CONTAINER.getTransferPrizeOUT()) {
                    this.func_238474_b_(matrixstack, i + 187, j + 31, 120, 236, 40, 20);
                }
                if (this.highlightIndex == 5) {
                    this.func_238474_b_(matrixstack, i + 193, j + 55, 176, 240, 16, 16);
                }
                if (this.highlightIndex == 6) {
                    this.func_238474_b_(matrixstack, i + 211, j + 55, 208, 240, 16, 16);
                }
                if (this.highlightIndex == 7) {
                    this.func_238474_b_(matrixstack, i + 193, j + 73, 176, 240, 16, 16);
                }
                if (this.highlightIndex == 8) {
                    this.func_238474_b_(matrixstack, i + 211, j + 73, 208, 240, 16, 16);
                }
                if (this.highlightIndex == 9) {
                    this.func_238474_b_(matrixstack, i + 193, j + 91, 176, 240, 16, 16);
                }
                if (this.highlightIndex == 10) {
                    this.func_238474_b_(matrixstack, i + 211, j + 91, 208, 240, 16, 16);
                }
                if (this.highlightIndex == 11) {
                    this.func_238474_b_(matrixstack, i + 79, j + 55, 240, 240, 16, 16);
                }
                if (this.highlightIndex == 12) {
                    this.func_238474_b_(matrixstack, i + 79, j + 73, 240, 240, 16, 16);
                }
                if (this.highlightIndex == 13) {
                    this.func_238474_b_(matrixstack, i + 79, j + 91, 240, 240, 16, 16);
                }
                if (this.CONTAINER.getPrizeMode1()) {
                    this.func_238474_b_(matrixstack, i + 61, j + 55, 176, 224, 16, 16);
                }
                if (this.CONTAINER.getPrizeMode2()) {
                    this.func_238474_b_(matrixstack, i + 61, j + 73, 176, 224, 16, 16);
                }
                if (this.CONTAINER.getPrizeMode3()) {
                    this.func_238474_b_(matrixstack, i + 61, j + 91, 176, 224, 16, 16);
                }
            }
        }
        if (this.highlightTimer > 0) {
            --this.highlightTimer;
            if (this.highlightTimer == 0) {
                this.highlightIndex = 0;
            }
        }
    }

    public void commandChangeBet(boolean isHigher, boolean isMaxBet) {
        boolean send = false;
        if (isHigher && isMaxBet) {
            this.CONTAINER.setBettingHigh(this.CONTAINER.getBettingHigh() + 1);
            send = true;
        }
        if (!isHigher && isMaxBet && this.CONTAINER.getBettingHigh() > 0) {
            this.CONTAINER.setBettingHigh(this.CONTAINER.getBettingHigh() - 1);
            if (this.CONTAINER.getBettingLow() > this.CONTAINER.getBettingHigh()) {
                this.CONTAINER.setBettingLow(this.CONTAINER.getBettingHigh());
            }
            send = true;
        }
        if (isHigher && !isMaxBet) {
            this.CONTAINER.setBettingLow(this.CONTAINER.getBettingLow() + 1);
            if (this.CONTAINER.getBettingHigh() < this.CONTAINER.getBettingLow()) {
                this.CONTAINER.setBettingHigh(this.CONTAINER.getBettingLow());
            }
            send = true;
        }
        if (!isHigher && !isMaxBet && this.CONTAINER.getBettingLow() > 0) {
            this.CONTAINER.setBettingLow(this.CONTAINER.getBettingLow() - 1);
            send = true;
        }
        if (send) {
            this.sendPacket();
        }
    }

    public void commandChangeReward(boolean isHigher, int index) {
        boolean send = false;
        if (index == 0 && isHigher) {
            this.CONTAINER.setPrizeCount1(this.CONTAINER.getPrizeCount1() + 1);
            send = true;
        }
        if (index == 1 && isHigher) {
            this.CONTAINER.setPrizeCount2(this.CONTAINER.getPrizeCount2() + 1);
            send = true;
        }
        if (index == 2 && isHigher) {
            this.CONTAINER.setPrizeCount3(this.CONTAINER.getPrizeCount3() + 1);
            send = true;
        }
        if (index == 0 && !isHigher && this.CONTAINER.getPrizeCount1() > 0) {
            this.CONTAINER.setPrizeCount1(this.CONTAINER.getPrizeCount1() - 1);
            send = true;
        }
        if (index == 1 && !isHigher && this.CONTAINER.getPrizeCount2() > 0) {
            this.CONTAINER.setPrizeCount2(this.CONTAINER.getPrizeCount2() - 1);
            send = true;
        }
        if (index == 2 && !isHigher && this.CONTAINER.getPrizeCount3() > 0) {
            this.CONTAINER.setPrizeCount3(this.CONTAINER.getPrizeCount3() - 1);
            send = true;
        }
        if (send) {
            this.sendPacket();
        }
    }

    public void commandTransfer(boolean isToken, boolean isIN) {
        if (isToken && isIN) {
            this.CONTAINER.setTransferTokenIN(!this.CONTAINER.getTransferTokenIN());
            this.CONTAINER.setTransferTokenOUT(false);
            this.CONTAINER.setTransferPrizeIN(false);
            this.CONTAINER.setTransferPrizeOUT(false);
        }
        if (isToken && !isIN) {
            this.CONTAINER.setTransferTokenIN(false);
            this.CONTAINER.setTransferTokenOUT(!this.CONTAINER.getTransferTokenOUT());
            this.CONTAINER.setTransferPrizeIN(false);
            this.CONTAINER.setTransferPrizeOUT(false);
        }
        if (!isToken && isIN) {
            this.CONTAINER.setTransferTokenIN(false);
            this.CONTAINER.setTransferTokenOUT(false);
            this.CONTAINER.setTransferPrizeIN(!this.CONTAINER.getTransferPrizeIN());
            this.CONTAINER.setTransferPrizeOUT(false);
        }
        if (!isToken && !isIN) {
            this.CONTAINER.setTransferTokenIN(false);
            this.CONTAINER.setTransferTokenOUT(false);
            this.CONTAINER.setTransferPrizeIN(false);
            this.CONTAINER.setTransferPrizeOUT(!this.CONTAINER.getTransferPrizeOUT());
        }
        this.sendPacket();
    }

    public void commandToggleSettings(int settingID) {
        if (settingID == 0 && ((Boolean)CasinoKeeper.config_creative_token.get()).booleanValue()) {
            this.CONTAINER.setSettingInfiniteToken(!this.CONTAINER.getSettingInfiniteToken());
        }
        if (settingID == 1 && ((Boolean)CasinoKeeper.config_creative_reward.get()).booleanValue()) {
            this.CONTAINER.setSettingInfinitePrize(!this.CONTAINER.getSettingInfinitePrize());
        }
        if (settingID == 2) {
            this.CONTAINER.setSettingDropOnBreak(!this.CONTAINER.getSettingDropOnBreak());
        }
        if (settingID == 3) {
            this.CONTAINER.setSettingIndestructable(!this.CONTAINER.getSettingIndestructable());
        }
        if (settingID == 4) {
            this.CONTAINER.setSettingAlternateColor((this.CONTAINER.getSettingAlternateColor() + 1) % 6);
        }
        this.sendPacket();
    }

    public void commandChangePage(int index) {
        if (this.CONTAINER.getTransferTokenIN() || this.CONTAINER.getTransferTokenOUT() || this.CONTAINER.getTransferPrizeIN() || this.CONTAINER.getTransferPrizeOUT()) {
            this.CONTAINER.setTransferTokenIN(false);
            this.CONTAINER.setTransferTokenOUT(false);
            this.CONTAINER.setTransferPrizeIN(false);
            this.CONTAINER.setTransferPrizeOUT(false);
            this.sendPacket();
        }
        this.page = index;
    }

    public void commandResetGameState() {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, -2, this.CONTAINER.pos()));
        this.hasReset = true;
    }

    public void commandSetScore(int index, int score) {
        if (index == 0) {
            this.CONTAINER.setPrizeScore1(score);
        }
        if (index == 1) {
            this.CONTAINER.setPrizeScore2(score);
        }
        if (index == 2) {
            this.CONTAINER.setPrizeScore3(score);
        }
        this.sendPacket();
    }

    public void commandTogglePrize(int index) {
        if (index == 0) {
            this.CONTAINER.setPrizeMode1(!this.CONTAINER.getPrizeMode1());
        }
        if (index == 1) {
            this.CONTAINER.setPrizeMode2(!this.CONTAINER.getPrizeMode2());
        }
        if (index == 2) {
            this.CONTAINER.setPrizeMode3(!this.CONTAINER.getPrizeMode3());
        }
    }

    private ResourceLocation getTexture() {
        if (!this.hasKey()) {
            return GUI_TEXTURE0;
        }
        if (this.activeInput != 0) {
            return GUI_TEXTURE4;
        }
        if (this.page == 2) {
            return GUI_TEXTURE3;
        }
        if (this.page == 1) {
            return GUI_TEXTURE2;
        }
        return GUI_TEXTURE1;
    }

    protected void highlight(int index) {
        this.highlightTimer = 10;
        this.highlightIndex = index;
    }

    protected boolean mouseRect(int x, int y, int width, int height, double mouseX, double mouseY) {
        if ((double)(this.field_147003_i + x - 56) < mouseX && mouseX < (double)(this.field_147003_i + x + width - 56)) {
            return (double)(this.field_147009_r + y) < mouseY && mouseY < (double)(this.field_147009_r + y + height);
        }
        return false;
    }

    protected void sendPacket() {
        CasinoPacketHandler.sendToServer(new MessageSettingServer(this.CONTAINER.pos(), new int[]{this.CONTAINER.getBettingLow(), this.CONTAINER.getBettingHigh(), this.CONTAINER.getPrizeScore1(), this.CONTAINER.getPrizeScore2(), this.CONTAINER.getPrizeScore3(), this.CONTAINER.getPrizeCount1(), this.CONTAINER.getPrizeCount2(), this.CONTAINER.getPrizeCount3(), this.CONTAINER.getPrizeMode1() ? 1 : 0, this.CONTAINER.getPrizeMode2() ? 1 : 0, this.CONTAINER.getPrizeMode3() ? 1 : 0, this.CONTAINER.getTransferTokenIN() ? 1 : 0, this.CONTAINER.getTransferTokenOUT() ? 1 : 0, this.CONTAINER.getTransferPrizeIN() ? 1 : 0, this.CONTAINER.getTransferPrizeOUT() ? 1 : 0, this.CONTAINER.getSettingInfiniteToken() ? 1 : 0, this.CONTAINER.getSettingInfinitePrize() ? 1 : 0, this.CONTAINER.getSettingDropOnBreak() ? 1 : 0, this.CONTAINER.getSettingIndestructable() ? 1 : 0, this.CONTAINER.getSettingAlternateColor()}));
    }

    protected boolean hasKey() {
        return this.CONTAINER.hasKey();
    }
}

