/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.util;

import java.util.Random;

public class Card {
    public int number;
    public int suit;
    public int shiftX;
    public int shiftY;
    public int deathtimer;
    public boolean dead;
    public int idletimer;
    public boolean hidden;

    public Card(Random random) {
        this.number = random.nextInt(13);
        this.suit = random.nextInt(4);
        this.shiftX = 0;
        this.shiftY = 0;
        this.deathtimer = 0;
        this.dead = false;
        this.hidden = false;
    }

    public Card(int number, int suit) {
        this.number = number;
        this.suit = suit;
        this.shiftX = 0;
        this.shiftY = 0;
        this.deathtimer = 0;
        this.dead = false;
        this.hidden = false;
    }

    public Card(int number, int suit, boolean hidden) {
        this.number = number;
        this.suit = suit;
        this.shiftX = 0;
        this.shiftY = 0;
        this.deathtimer = 0;
        this.dead = false;
        this.hidden = hidden;
    }

    public Card(Random random, int shiftX, int shiftY) {
        this.number = random.nextInt(13);
        this.suit = random.nextInt(4);
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.deathtimer = 0;
        this.idletimer = 0;
        this.dead = false;
        this.hidden = false;
    }

    public Card(int number, int suit, int shiftX, int shiftY) {
        this.number = number;
        this.suit = suit;
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.deathtimer = 0;
        this.idletimer = 0;
        this.dead = false;
        this.hidden = false;
    }

    public Card(Random random, int shiftX, int shiftY, int idletimer, boolean hidden) {
        this.number = random.nextInt(13);
        this.suit = random.nextInt(4);
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.deathtimer = 0;
        this.idletimer = idletimer;
        this.dead = false;
        this.hidden = hidden;
    }

    public Card(int number, int suit, int shiftX, int shiftY, int idletimer, boolean hidden) {
        this.number = number;
        this.suit = suit;
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.deathtimer = 0;
        this.idletimer = idletimer;
        this.dead = false;
        this.hidden = hidden;
    }

    public Card(Card card) {
        this.number = card.number;
        this.suit = card.suit;
        this.shiftX = card.shiftX;
        this.shiftY = card.shiftY;
        this.deathtimer = card.deathtimer;
        this.idletimer = card.idletimer;
        this.dead = card.dead;
        this.hidden = card.hidden;
    }

    public boolean update() {
        if (this.idletimer > 0) {
            this.idletimer -= 2;
            if (this.idletimer >= 0) {
                return true;
            }
        } else {
            if (this.shiftX < 0) {
                this.shiftX += 2;
            }
            if (this.shiftX > 0) {
                this.shiftX -= 2;
            }
            if (this.shiftY < 0) {
                this.shiftY += 2;
            }
            if (this.shiftY > 0) {
                this.shiftY -= 2;
            }
            if (this.dead) {
                this.deathtimer += 2;
            }
        }
        return false;
    }

    public void setShift(int shiftX, int shiftY, int idletimer) {
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.idletimer = idletimer;
    }

    public int sortedNumber() {
        return this.number == 0 ? 13 : this.number;
    }

    public void set(int x, int y) {
        this.number = x;
        this.suit = y;
        this.shiftX = 0;
        this.shiftY = 0;
        this.idletimer = 0;
    }

    public void set(Card c) {
        this.number = c.number;
        this.suit = c.suit;
        this.shiftX = c.shiftX;
        this.shiftY = c.shiftY;
        this.idletimer = c.idletimer;
        this.hidden = c.hidden;
    }

    public boolean equals(int x, int y) {
        return this.number == x && this.suit == y;
    }
}

