/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.config.ConfigLoot;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;

public class ChampionEventsHandler {
    private static final Field EXPLOSION_SIZE = ObfuscationReflectionHelper.findField(Explosion.class, (String)"field_77280_f");

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223602_e) || !ChampionsConfig.fakeLoot && evt.getSource().func_76346_g() instanceof FakePlayer) {
            return;
        }
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
            List<ItemStack> loot;
            IChampion.Server serverChampion = champion.getServer();
            ServerWorld serverWorld = (ServerWorld)livingEntity.func_130014_f_();
            if (ChampionsConfig.lootSource != ConfigEnums.LootSource.CONFIG) {
                LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(new ResourceLocation("champions:champion_loot"));
                DamageSource source = evt.getSource();
                LootContext.Builder lootcontext$builder = new LootContext.Builder(serverWorld).func_216023_a(livingEntity.func_70681_au()).func_216015_a(LootParameters.field_216281_a, (Object)livingEntity).func_216015_a(LootParameters.field_237457_g_, (Object)livingEntity.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)source).func_216021_b(LootParameters.field_216284_d, (Object)source.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)source.func_76364_f());
                LivingEntity attackingEntity = livingEntity.func_94060_bK();
                if (attackingEntity instanceof PlayerEntity) {
                    lootcontext$builder = lootcontext$builder.func_216015_a(LootParameters.field_216282_b, (Object)((PlayerEntity)attackingEntity)).func_186469_a(((PlayerEntity)attackingEntity).func_184817_da());
                }
                List stacks = lootTable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d));
                stacks.forEach(stack -> {
                    ItemEntity itemEntity = new ItemEntity((World)serverWorld, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), stack);
                    itemEntity.func_174869_p();
                    evt.getDrops().add(itemEntity);
                });
            }
            if (ChampionsConfig.lootSource != ConfigEnums.LootSource.LOOT_TABLE && !(loot = ConfigLoot.getLootDrops(serverChampion.getRank().map(Rank::getTier).orElse(0))).isEmpty()) {
                loot.forEach(stack -> {
                    ItemEntity itemEntity = new ItemEntity((World)serverWorld, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), stack);
                    itemEntity.func_174869_p();
                    evt.getDrops().add(itemEntity);
                });
            }
        });
    }

    @SubscribeEvent
    public void onLivingXpDrop(LivingExperienceDropEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> champion.getServer().getRank().ifPresent(rank -> {
            int growth = rank.getGrowthFactor();
            if (growth > 0) {
                evt.setDroppedExperience(growth * ChampionsConfig.experienceGrowth * evt.getOriginalExperience() + evt.getOriginalExperience());
            }
        }));
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start evt) {
        Explosion explosion = evt.getExplosion();
        LivingEntity livingEntity = explosion.func_94613_c();
        if (livingEntity != null && !livingEntity.func_130014_f_().func_201670_d()) {
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> champion.getServer().getRank().ifPresent(rank -> {
                int growth = rank.getGrowthFactor();
                if (growth > 0) {
                    try {
                        float size = EXPLOSION_SIZE.getFloat(explosion);
                        EXPLOSION_SIZE.setFloat(explosion, size + (float)(ChampionsConfig.explosionGrowth * growth));
                    }
                    catch (IllegalAccessException e) {
                        Champions.LOGGER.error("Cannot increase explosion size!");
                    }
                }
            }));
        }
    }

    @SubscribeEvent
    public void onLivingJoinWorld(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.func_130014_f_().func_201670_d() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> affix.onSpawn((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    List<Tuple<Effect, Integer>> effects = rank.getEffects();
                    effects.forEach(effectPair -> livingEntity.func_195064_c(new EffectInstance((Effect)effectPair.func_76341_a(), 200, ((Integer)effectPair.func_76340_b()).intValue())));
                });
            });
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.func_130014_f_().func_201670_d() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> affix.onUpdate((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    if (ChampionsConfig.showParticles && rank.getTier() > 0) {
                        int color = rank.getDefaultColor();
                        float r = (float)(color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(color & 0xFF) / 255.0f;
                        ((ServerWorld)livingEntity.func_130014_f_()).func_195598_a((IParticleData)ChampionsRegistry.RANK, livingEntity.func_226277_ct_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * (double)livingEntity.func_213311_cf(), livingEntity.func_226278_cu_() + livingEntity.func_70681_au().nextDouble() * (double)livingEntity.func_213302_cg(), livingEntity.func_226281_cx_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * (double)livingEntity.func_213311_cf(), 0, (double)r, (double)g, (double)b, 1.0);
                    }
                    if (livingEntity.field_70173_aa % 40 == 0) {
                        List<Tuple<Effect, Integer>> effects = rank.getEffects();
                        effects.forEach(effectPair -> livingEntity.func_195064_c(new EffectInstance((Effect)effectPair.func_76341_a(), 100, ((Integer)effectPair.func_76340_b()).intValue())));
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent evt) {
        Entity entity = evt.getEntity();
        if (entity.func_130014_f_().func_201670_d()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    if (!affix.onAttacked((IChampion)champion, evt.getSource(), evt.getAmount())) {
                        evt.setCanceled(true);
                    }
                });
            });
        }
        if (evt.isCanceled()) {
            return;
        }
        Entity source = evt.getSource().func_76346_g();
        if (source instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)source;
            ChampionCapability.getCapability(livingSource).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    if (!affix.onAttack((IChampion)champion, evt.getEntityLiving(), evt.getSource(), evt.getAmount())) {
                        evt.setCanceled(true);
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.func_130014_f_().func_201670_d() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    amounts[1] = affix.onHurt((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.func_130014_f_().func_201670_d() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    amounts[1] = affix.onDamage((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity.func_130014_f_().func_201670_d()) {
            return;
        }
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            serverChampion.getAffixes().forEach(affix -> {
                if (!affix.onDeath((IChampion)champion, evt.getSource())) {
                    evt.setCanceled(true);
                }
            });
            serverChampion.getRank().ifPresent(rank -> {
                MinecraftServer server;
                int messageTier;
                if (!evt.isCanceled() && evt.getSource().func_76346_g() instanceof PlayerEntity && (messageTier = ChampionsConfig.deathMessageTier) > 0 && rank.getTier() >= messageTier && (server = livingEntity.func_184102_h()) != null) {
                    server.func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("rank.champions.title." + rank.getTier()).func_240702_b_(" ").func_230529_a_(livingEntity.func_110142_aN().func_151521_b()), ChatType.SYSTEM, Util.field_240973_b_);
                }
            });
        });
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.func_130014_f_().func_201670_d() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    amounts[1] = affix.onHeal((IChampion)champion, amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }
}

