/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class AdaptableAffix
extends BasicAffix {
    public AdaptableAffix() {
        super("adaptable", AffixCategory.DEFENSE);
    }

    @Override
    public float onHurt(IChampion champion, DamageSource source, float amount, float newAmount) {
        String type = source.func_76355_l();
        DamageData damageData = AffixData.getData(champion, this.getIdentifier(), DamageData.class);
        if (damageData.name.equalsIgnoreCase(type)) {
            newAmount = (float)((double)newAmount - (double)amount * ChampionsConfig.adaptableDamageReductionIncrement * (double)damageData.count);
            ++damageData.count;
        } else {
            damageData.name = type;
            damageData.count = 0;
        }
        damageData.saveData();
        return Math.max(amount * (float)(1.0 - ChampionsConfig.adaptableMaxDamageReduction), newAmount);
    }

    public static class DamageData
    extends AffixData {
        String name;
        int count;

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.name = tag.func_74779_i("name");
            this.count = tag.func_74762_e("count");
        }

        @Override
        public CompoundNBT writeToNBT() {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("name", this.name);
            compound.func_74768_a("count", this.count);
            return compound;
        }
    }
}

