/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalAffix;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.rank.RankManager;

public class InfestedAffix
extends GoalAffix {
    public InfestedAffix() {
        super("infested", AffixCategory.OFFENSE);
    }

    @Override
    public void onInitialSpawn(IChampion champion) {
        AffixData.IntegerData buffer = AffixData.getData(champion, this.getIdentifier(), AffixData.IntegerData.class);
        buffer.num = Math.min(ChampionsConfig.infestedTotal, Math.max(1, (int)((double)champion.getLivingEntity().func_110138_aP() * ChampionsConfig.infestedPerHealth)));
        buffer.saveData();
    }

    @Override
    public float onHeal(IChampion champion, float amount, float newAmount) {
        if (newAmount > 0.0f && champion.getLivingEntity().func_70681_au().nextFloat() < 0.5f) {
            AffixData.IntegerData buffer = AffixData.getData(champion, this.getIdentifier(), AffixData.IntegerData.class);
            buffer.num = Math.min(ChampionsConfig.infestedTotal, buffer.num + 2);
            buffer.saveData();
            return Math.max(0.0f, newAmount - 1.0f);
        }
        return newAmount;
    }

    @Override
    public boolean onDeath(IChampion champion, DamageSource source) {
        World world;
        AffixData.IntegerData buffer = AffixData.getData(champion, this.getIdentifier(), AffixData.IntegerData.class);
        LivingEntity target = null;
        if (source.func_76346_g() instanceof LivingEntity) {
            target = (LivingEntity)source.func_76346_g();
        }
        if ((world = champion.getLivingEntity().func_130014_f_()) instanceof ServerWorld) {
            InfestedAffix.spawnParasites(champion.getLivingEntity(), buffer.num, target, (ServerWorld)world);
        }
        return true;
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new SpawnParasiteGoal((MobEntity)champion.getLivingEntity())));
    }

    @Override
    public boolean canApply(IChampion champion) {
        EntityType type = champion.getLivingEntity().func_200600_R();
        return type != ChampionsConfig.infestedParasite && type != ChampionsConfig.infestedEnderParasite && super.canApply(champion);
    }

    private static void spawnParasites(LivingEntity livingEntity, int amount, @Nullable LivingEntity target, ServerWorld world) {
        boolean isEnder = livingEntity instanceof EndermanEntity || livingEntity instanceof ShulkerEntity || livingEntity instanceof EndermiteEntity || livingEntity instanceof EnderDragonEntity;
        EntityType<?> type = isEnder ? ChampionsConfig.infestedEnderParasite : ChampionsConfig.infestedParasite;
        for (int i = 0; i < amount; ++i) {
            Entity entity = type.func_220349_b(world, null, null, null, livingEntity.func_233580_cy_(), SpawnReason.MOB_SUMMONED, false, false);
            if (!(entity instanceof LivingEntity)) continue;
            ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> champion.getServer().setRank(RankManager.getLowestRank()));
            livingEntity.func_130014_f_().func_217376_c(entity);
            if (!(entity instanceof MobEntity)) continue;
            ((MobEntity)entity).func_70656_aK();
            ((MobEntity)entity).func_70604_c(target);
            ((MobEntity)entity).func_70624_b(target);
        }
    }

    private class SpawnParasiteGoal
    extends Goal {
        private final MobEntity mobEntity;
        private int attackTime;

        public SpawnParasiteGoal(MobEntity mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void func_75249_e() {
            this.attackTime = ChampionsConfig.infestedInterval * 20;
        }

        public void func_75246_d() {
            --this.attackTime;
            if (this.attackTime <= 0) {
                ChampionCapability.getCapability((LivingEntity)this.mobEntity).ifPresent(champion -> {
                    AffixData.IntegerData buffer = AffixData.getData(champion, InfestedAffix.this.getIdentifier(), AffixData.IntegerData.class);
                    if (buffer.num > 0 && this.mobEntity.field_70170_p instanceof ServerWorld) {
                        this.attackTime = ChampionsConfig.infestedInterval * 20 + this.mobEntity.func_70681_au().nextInt(5) * 10;
                        int amount = ChampionsConfig.infestedAmount;
                        InfestedAffix.spawnParasites((LivingEntity)this.mobEntity, amount, this.mobEntity.func_70638_az(), (ServerWorld)this.mobEntity.field_70170_p);
                        buffer.num = Math.max(0, buffer.num - amount);
                        buffer.saveData();
                    }
                });
            }
        }

        public boolean func_75250_a() {
            return BasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.func_70638_az(), true);
        }
    }
}

