/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class MoltenAffix
extends BasicAffix {
    private static final Field GOALS = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");

    public MoltenAffix() {
        super("molten", AffixCategory.OFFENSE);
    }

    @Override
    public void onSpawn(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        livingEntity.func_195064_c(new EffectInstance(Effects.field_76426_n, 40, 0, true, false));
        if (livingEntity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)livingEntity;
            mobEntity.func_184644_a(PathNodeType.WATER, -1.0f);
            mobEntity.func_184644_a(PathNodeType.LAVA, 8.0f);
            mobEntity.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
            mobEntity.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
            try {
                Set goals = (Set)GOALS.get(mobEntity.field_70714_bg);
                Iterator iter = goals.iterator();
                while (iter.hasNext()) {
                    PrioritizedGoal goal = (PrioritizedGoal)iter.next();
                    Goal baseGoal = goal.func_220772_j();
                    if (!(baseGoal instanceof FleeSunGoal) && !(baseGoal instanceof RestrictSunGoal)) continue;
                    iter.remove();
                }
            }
            catch (Exception e) {
                Champions.LOGGER.error("Error accessing goals!");
            }
            if (mobEntity.func_70661_as() instanceof GroundPathNavigator) {
                ((GroundPathNavigator)mobEntity.func_70661_as()).func_179685_e(false);
            }
        }
    }

    @Override
    public void onUpdate(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        if (!livingEntity.func_130014_f_().func_201670_d() && livingEntity.field_70173_aa % 20 == 0) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76426_n, 40, 0, true, false));
            if (!ChampionsConfig.moltenWaterResistance && livingEntity.func_70026_G()) {
                livingEntity.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }

    @Override
    public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        target.func_70015_d(10);
        source.func_76361_j();
        return true;
    }
}

