/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractBulletEntity
extends Entity {
    private LivingEntity owner;
    private Entity target;
    @Nullable
    private Direction direction;
    private int steps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID ownerUniqueId;
    private int ownerId;
    @Nullable
    private UUID targetUniqueId;

    public AbstractBulletEntity(EntityType<? extends AbstractBulletEntity> type, World world) {
        super(type, world);
        this.field_70145_X = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractBulletEntity(EntityType<? extends AbstractBulletEntity> type, World worldIn, double x, double y, double z, double motionXIn, double motionYIn, double motionZIn) {
        this(type, worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_213293_j(motionXIn, motionYIn, motionZIn);
    }

    public AbstractBulletEntity(EntityType<? extends AbstractBulletEntity> type, World worldIn, LivingEntity ownerIn, Entity targetIn, Direction.Axis direction) {
        this(type, worldIn);
        this.setShooter((Entity)ownerIn);
        BlockPos blockpos = ownerIn.func_233580_cy_();
        double d0 = (double)blockpos.func_177958_n() + 0.5;
        double d1 = (double)blockpos.func_177956_o() + 0.5;
        double d2 = (double)blockpos.func_177952_p() + 0.5;
        this.func_70012_b(d0, d1, d2, this.field_70177_z, this.field_70125_A);
        this.target = targetIn;
        this.direction = Direction.UP;
        this.selectNextMoveDirection(direction);
    }

    public void setShooter(@Nullable Entity entityIn) {
        if (entityIn != null) {
            this.ownerUniqueId = entityIn.func_110124_au();
            this.ownerId = entityIn.func_145782_y();
        }
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("Owner", this.ownerUniqueId);
        }
        if (this.targetUniqueId != null) {
            compound.func_186854_a("Target", this.targetUniqueId);
        }
        if (this.direction != null) {
            compound.func_74768_a("Dir", this.direction.func_176745_a());
        }
        compound.func_74768_a("Steps", this.steps);
        compound.func_74780_a("TXD", this.targetDeltaX);
        compound.func_74780_a("TYD", this.targetDeltaY);
        compound.func_74780_a("TZD", this.targetDeltaZ);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.steps = compound.func_74762_e("Steps");
        this.targetDeltaX = compound.func_74769_h("TXD");
        this.targetDeltaY = compound.func_74769_h("TYD");
        this.targetDeltaZ = compound.func_74769_h("TZD");
        if (compound.func_150297_b("Dir", 99)) {
            this.direction = Direction.func_82600_a((int)compound.func_74762_e("Dir"));
        }
        if (compound.func_150297_b("Owner", 10)) {
            CompoundNBT compoundnbt = compound.func_74775_l("Owner");
            this.ownerUniqueId = NBTUtil.func_186860_b((INBT)compoundnbt);
        }
        if (compound.func_150297_b("Target", 10)) {
            CompoundNBT compoundnbt1 = compound.func_74775_l("Target");
            this.targetUniqueId = NBTUtil.func_186860_b((INBT)compoundnbt1);
        }
    }

    protected void func_70088_a() {
    }

    private void setDirection(@Nullable Direction directionIn) {
        this.direction = directionIn;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis axis) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.target == null) {
            blockpos = this.func_233580_cy_().func_177977_b();
        } else {
            d0 = (double)this.target.func_213302_cg() * 0.5;
            blockpos = new BlockPos(this.target.func_226277_ct_(), this.target.func_226278_cu_() + d0, this.target.func_226281_cx_());
        }
        double d1 = (double)blockpos.func_177958_n() + 0.5;
        double d2 = (double)blockpos.func_177956_o() + d0;
        double d3 = (double)blockpos.func_177952_p() + 0.5;
        Direction direction = null;
        if (!blockpos.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
            BlockPos blockpos1 = this.func_233580_cy_();
            ArrayList list = Lists.newArrayList();
            if (axis != Direction.Axis.X) {
                if (blockpos1.func_177958_n() < blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177974_f())) {
                    list.add(Direction.EAST);
                } else if (blockpos1.func_177958_n() > blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177976_e())) {
                    list.add(Direction.WEST);
                }
            }
            if (axis != Direction.Axis.Y) {
                if (blockpos1.func_177956_o() < blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177984_a())) {
                    list.add(Direction.UP);
                } else if (blockpos1.func_177956_o() > blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177977_b())) {
                    list.add(Direction.DOWN);
                }
            }
            if (axis != Direction.Axis.Z) {
                if (blockpos1.func_177952_p() < blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177968_d())) {
                    list.add(Direction.SOUTH);
                } else if (blockpos1.func_177952_p() > blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177978_c())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.func_239631_a_((Random)this.field_70146_Z);
            if (list.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_175623_d(blockpos1.func_177972_a(direction)) && i > 0; --i) {
                    direction = Direction.func_239631_a_((Random)this.field_70146_Z);
                }
            } else {
                direction = (Direction)list.get(this.field_70146_Z.nextInt(list.size()));
            }
            d1 = this.func_226277_ct_() + (double)direction.func_82601_c();
            d2 = this.func_226278_cu_() + (double)direction.func_96559_d();
            d3 = this.func_226281_cx_() + (double)direction.func_82599_e();
        }
        this.setDirection(direction);
        double d6 = d1 - this.func_226277_ct_();
        double d7 = d2 - this.func_226278_cu_();
        double d4 = d3 - this.func_226281_cx_();
        double d5 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7 + d4 * d4));
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.field_70160_al = true;
        this.steps = 10 + this.field_70146_Z.nextInt(5) * 10;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult raytraceresult;
            if (this.target == null && this.targetUniqueId != null) {
                this.target = ((ServerWorld)this.field_70170_p).func_217461_a(this.targetUniqueId);
                if (this.target == null) {
                    this.targetUniqueId = null;
                }
            }
            if (this.target == null || !this.target.func_70089_S() || this.target instanceof PlayerEntity && this.target.func_175149_v()) {
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = MathHelper.func_151237_a((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = MathHelper.func_151237_a((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = MathHelper.func_151237_a((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                Vector3d vector3d = this.func_213322_ci();
                this.func_213317_d(vector3d.func_72441_c((this.targetDeltaX - vector3d.field_72450_a) * 0.2, (this.targetDeltaY - vector3d.field_72448_b) * 0.2, (this.targetDeltaZ - vector3d.field_72449_c) * 0.2));
            }
            if ((raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_)).func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.bulletHit(raytraceresult);
            }
        }
        Vector3d vector3d1 = this.func_213322_ci();
        this.func_70107_b(this.func_226277_ct_() + vector3d1.field_72450_a, this.func_226278_cu_() + vector3d1.field_72448_b, this.func_226281_cx_() + vector3d1.field_72449_c);
        ProjectileHelper.func_188803_a((Entity)this, (float)0.5f);
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a(this.getParticle(), this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b + 0.15, this.func_226281_cx_() - vector3d1.field_72449_c, 0.0, 0.0, 0.0);
        } else if (this.target != null && this.target.func_70089_S()) {
            if (this.steps > 0) {
                --this.steps;
                if (this.steps == 0) {
                    this.selectNextMoveDirection(this.direction == null ? null : this.direction.func_176740_k());
                }
            }
            if (this.direction != null) {
                BlockPos blockpos = this.func_233580_cy_();
                Direction.Axis direction$axis = this.direction.func_176740_k();
                if (this.field_70170_p.func_217400_a(blockpos.func_177972_a(this.direction), (Entity)this)) {
                    this.selectNextMoveDirection(direction$axis);
                } else {
                    BlockPos blockpos1 = this.target.func_233580_cy_();
                    if (direction$axis == Direction.Axis.X && blockpos.func_177958_n() == blockpos1.func_177958_n() || direction$axis == Direction.Axis.Z && blockpos.func_177952_p() == blockpos1.func_177952_p() || direction$axis == Direction.Axis.Y && blockpos.func_177956_o() == blockpos1.func_177956_o()) {
                        this.selectNextMoveDirection(direction$axis);
                    }
                }
            }
        }
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        if (!p_230298_1_.func_175149_v() && p_230298_1_.func_70089_S() && p_230298_1_.func_70067_L() && !p_230298_1_.field_70145_X) {
            Entity entity = this.func_234616_v_();
            return entity == null || !entity.func_184223_x(p_230298_1_);
        }
        return false;
    }

    public Entity func_234616_v_() {
        if (this.ownerUniqueId != null && this.field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUniqueId);
        }
        return this.ownerId != 0 ? this.field_70170_p.func_73045_a(this.ownerId) : null;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected void bulletHit(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            this.bulletEffect(entity);
        } else {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2, 0.2, 0.2, 0.2, 0.0);
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.0f);
        }
        this.func_70106_y();
    }

    protected abstract void bulletEffect(Entity var1);

    protected abstract IParticleData getParticle();

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187777_eQ, 1.0f, 1.0f);
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.func_70106_y();
        }
        return true;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LivingEntity getOwner() {
        return this.owner;
    }
}

