/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.gamestages;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class ChampionsStages {
    private static final Map<String, Info> ENTITY_STAGE_INFO = new HashMap<String, Info>();
    private static final Map<Integer, Info> TIER_STAGE_INFO = new HashMap<Integer, Info>();

    public static void addStage(String entity, String stage) {
        ENTITY_STAGE_INFO.merge(entity, new Info(stage), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    public static void addStage(String entity, String stage, String dimension) {
        ENTITY_STAGE_INFO.merge(entity, new Info(stage, dimension), (k, v) -> {
            v.addStage(stage, dimension);
            return v;
        });
    }

    public static void addTierStage(int tier, String stage) {
        TIER_STAGE_INFO.merge(tier, new Info(stage), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    public static void addTierStage(int tier, String stage, String dimension) {
        TIER_STAGE_INFO.merge(tier, new Info(stage, dimension), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    private static Optional<Info> getStageInfo(String entity) {
        return Optional.ofNullable(ENTITY_STAGE_INFO.get(entity));
    }

    private static Optional<Info> getStageInfo(int tier) {
        return Optional.ofNullable(TIER_STAGE_INFO.get(tier));
    }

    public static boolean hasChampionStage(LivingEntity living) {
        ResourceLocation rl = living.func_200600_R().getRegistryName();
        if (rl != null) {
            String id = rl.toString();
            return ChampionsStages.getStageInfo(id).map(info -> ChampionsStages.hasRequiredStages(info, living)).orElse(true);
        }
        return true;
    }

    public static boolean hasTierStage(int tier, LivingEntity livingEntity) {
        return ChampionsStages.getStageInfo(tier).map(info -> ChampionsStages.hasRequiredStages(info, livingEntity)).orElse(true);
    }

    private static boolean hasRequiredStages(@Nonnull Info info, @Nonnull LivingEntity living) {
        String dimension = living.func_130014_f_().func_234923_W_().getRegistryName().toString();
        Set<String> stages = info.dimensionalStages.containsKey(dimension) ? info.dimensionalStages.get(dimension) : info.globalStages;
        if (stages.isEmpty()) {
            return true;
        }
        if (living.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)living.field_70170_p;
            for (ServerPlayerEntity player : serverWorld.func_217369_A()) {
                if (!GameStageHelper.hasAllOf((PlayerEntity)player, stages) || !(player.func_70032_d((Entity)living) <= 256.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Info {
        Map<String, Set<String>> dimensionalStages = new HashMap<String, Set<String>>();
        Set<String> globalStages = new HashSet<String>();

        Info(String stage) {
            this.addStage(stage);
        }

        Info(String stage, String dimension) {
            this.addStage(stage, dimension);
        }

        void addStage(String stage) {
            this.globalStages.add(stage);
        }

        void addStage(String stage, String dimension) {
            this.dimensionalStages.merge(dimension, new HashSet<String>(Collections.singleton(stage)), (k, v) -> {
                v.add(stage);
                return v;
            });
        }
    }
}

