/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.scalinghealth;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.scalinghealth.utils.SHDifficulty;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class ScalingHealthManager {
    private static final Map<Integer, Double> MODIFIERS = new TreeMap<Integer, Double>();

    public static double getSpawnIncrease(int tier, LivingEntity livingEntity) {
        double difficulty = SHDifficulty.areaDifficulty((World)livingEntity.field_70170_p, (BlockPos)livingEntity.func_233580_cy_());
        return ScalingHealthManager.getSpawnModifier(tier) * difficulty;
    }

    public static double getSpawnModifier(int tier) {
        return MODIFIERS.getOrDefault(tier, 0.0);
    }

    public static void buildModifiers() {
        MODIFIERS.clear();
        for (String string : ChampionsConfig.scalingHealthSpawnModifiers) {
            String[] parsed = string.split(";");
            if (parsed.length <= 1) continue;
            int tier = Integer.parseInt(parsed[0]);
            double modifier = Double.parseDouble(parsed[1]);
            if (tier <= 0 || !(modifier > 0.0)) continue;
            MODIFIERS.put(tier, modifier);
        }
    }
}

