/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.util.ChampionBuilder;

public class ChampionEggItem
extends Item {
    private static final String ID_TAG = "Id";
    private static final String ENTITY_TAG = "EntityTag";
    private static final String TIER_TAG = "Tier";
    private static final String AFFIX_TAG = "Affix";
    private static final String CHAMPION_TAG = "Champion";

    public ChampionEggItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        this.setRegistryName("champions:egg");
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        CompoundNBT tag;
        int tier = 0;
        Optional<EntityType<?>> type = ChampionEggItem.getType(stack);
        if (stack.func_77942_o() && (tag = stack.func_179543_a(CHAMPION_TAG)) != null) {
            tier = tag.func_74762_e(TIER_TAG);
        }
        TranslationTextComponent root = new TranslationTextComponent("rank.champions.title." + tier);
        root.func_240702_b_(" ");
        root.func_230529_a_(type.map(EntityType::func_212546_e).orElse(EntityType.field_200725_aD.func_212546_e()));
        root.func_240702_b_(" ");
        root.func_230529_a_((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack)));
        return root;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag;
        boolean hasAffix = false;
        if (stack.func_77942_o() && (tag = stack.func_179543_a(CHAMPION_TAG)) != null) {
            ListNBT listNBT = tag.func_150295_c(AFFIX_TAG, 8);
            if (!listNBT.isEmpty()) {
                hasAffix = true;
            }
            listNBT.forEach(affix -> Champions.API.getAffix(affix.func_150285_a_()).ifPresent(affix1 -> tooltip.add((ITextComponent)new TranslationTextComponent("affix.champions." + affix1.getIdentifier()).func_240699_a_(TextFormatting.GRAY))));
        }
        if (!hasAffix) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.champions.egg.tooltip").func_240699_a_(TextFormatting.AQUA));
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.func_201670_d() && world instanceof ServerWorld) {
            ItemStack itemstack = context.func_195996_i();
            BlockPos blockpos = context.func_195995_a();
            Direction direction = context.func_196000_l();
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
            Optional<EntityType<?>> entitytype = ChampionEggItem.getType(itemstack);
            entitytype.ifPresent(type -> {
                Entity entity = type.func_220349_b((ServerWorld)world, itemstack.func_77978_p(), null, context.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
                if (entity instanceof LivingEntity) {
                    ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> ChampionEggItem.read(champion, itemstack));
                    world.func_217376_c(entity);
                    itemstack.func_190918_g(1);
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.func_201670_d()) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (worldIn instanceof ServerWorld) {
            BlockRayTraceResult raytraceresult = ChampionEggItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            BlockPos blockpos = raytraceresult.func_216350_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.func_216354_b(), itemstack)) {
                Optional<EntityType<?>> entityType = ChampionEggItem.getType(itemstack);
                return entityType.map(type -> {
                    Entity entity = type.func_220349_b((ServerWorld)worldIn, itemstack.func_77978_p(), null, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false);
                    if (entity instanceof LivingEntity) {
                        ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> ChampionEggItem.read(champion, itemstack));
                        worldIn.func_217376_c(entity);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
                    }
                    return new ActionResult(ActionResultType.PASS, (Object)itemstack);
                }).orElse(new ActionResult(ActionResultType.PASS, (Object)itemstack));
            }
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        SpawnEggItem eggItem = SpawnEggItem.func_200889_b((EntityType)ChampionEggItem.getType(stack).orElse(EntityType.field_200725_aD));
        return eggItem != null ? eggItem.func_195983_a(tintIndex) : 0;
    }

    public static Optional<EntityType<?>> getType(ItemStack stack) {
        EntityType type;
        String id;
        CompoundNBT entityTag;
        if (stack.func_77942_o() && (entityTag = stack.func_179543_a(ENTITY_TAG)) != null && !(id = entityTag.func_74779_i(ID_TAG)).isEmpty() && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id))) != null) {
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static void read(IChampion champion, ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77942_o() && (tag = stack.func_179543_a(CHAMPION_TAG)) != null) {
            int tier = tag.func_74762_e(TIER_TAG);
            ListNBT listNBT = tag.func_150295_c(AFFIX_TAG, 8);
            ArrayList<IAffix> affixes = new ArrayList<IAffix>();
            listNBT.forEach(affix -> Champions.API.getAffix(affix.func_150285_a_()).ifPresent(affixes::add));
            ChampionBuilder.spawnPreset(champion, tier, affixes);
        }
    }

    public static void write(ItemStack stack, ResourceLocation entityId, int tier, Collection<IAffix> affixes) {
        CompoundNBT tag;
        CompoundNBT compoundNBT = tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        assert (tag != null);
        CompoundNBT compoundNBT2 = new CompoundNBT();
        compoundNBT2.func_74778_a(ID_TAG, entityId.toString());
        tag.func_218657_a(ENTITY_TAG, (INBT)compoundNBT2);
        CompoundNBT compoundNBT1 = new CompoundNBT();
        compoundNBT1.func_74768_a(TIER_TAG, tier);
        ListNBT listNBT = new ListNBT();
        affixes.forEach(affix -> listNBT.add((Object)StringNBT.func_229705_a_((String)affix.getIdentifier())));
        compoundNBT1.func_218657_a(AFFIX_TAG, (INBT)listNBT);
        tag.func_218657_a(CHAMPION_TAG, (INBT)compoundNBT1);
        stack.func_77982_d(tag);
    }
}

